/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "WcStatusInfoTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/WcStatusCache.h"
#include "subcommander/WcStatusInfo.h"
#include "util/String.h"


WcStatusInfoTest::WcStatusInfoTest() : CppUnit::TestCase("WcStatusInfoTest")
{
}

WcStatusInfoTest::~WcStatusInfoTest()
{
}

void WcStatusInfoTest::setUp()
{
}

void WcStatusInfoTest::tearDown()
{
}


CppUnit::Test *WcStatusInfoTest::suite()
{
  CppUnit::TestSuite *newSuite = new CppUnit::TestSuite("WcStatusInfoTest");

  newSuite->addTest(new CppUnit::TestCaller<WcStatusInfoTest>("testOperatorEqual",&WcStatusInfoTest::testOperatorEqual) );
  newSuite->addTest(new CppUnit::TestCaller<WcStatusInfoTest>("testGetAge",&WcStatusInfoTest::testGetAge) );

  return newSuite;
}

void WcStatusInfoTest::testOperatorEqual()
{
  svn::WcStatuss statuss;
  WcStatusInfo info1( sc::String("test"), 0, statuss );
  WcStatusInfo info2( sc::String("test"), 0, statuss );
  WcStatusInfo info3( sc::String("test"), 1, statuss );
  WcStatusInfo info4( sc::String("testx"), 0, statuss );

  CPPUNIT_ASSERT( info1 == info1 );
  CPPUNIT_ASSERT( info1 == info2 );
  CPPUNIT_ASSERT( !(info1 == info3) );
  CPPUNIT_ASSERT( !(info1 == info4) );
}

void WcStatusInfoTest::testGetAge()
{
  svn::WcStatuss statuss;
  WcStatusInfo info1( sc::String("test"), apr_time_now(), statuss );

  apr_sleep(5000 /*5ms*/);

  unsigned long age = info1.getAge();
  unsigned long ref = (unsigned long)((apr_time_now() - info1.getDate())/1000);
  CPPUNIT_ASSERT( age <= ref );
}
