/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#if defined(SC_ERROR_BUILD_TABLE) || !defined(SC_ERROR_BUILD_ENUM) 

// sc
#include "config.h"
#include "String.h"

/*
** In the normal #include case we build an enum which defines our error codes.
** If SC_ERROR_BUILD_TABLE is defined we create a table which maps error codes
** to error message. This way we have both definitions at the same place.
**
** Based on subversion/subversion/include/svn_error_codes.h
*/

namespace sc
{

#ifndef SC_ERROR_BUILD_ENUM
#define SC_ERROR_BUILD_ENUM

// build enum

#define SC_ERROR_BEGIN enum ErrorCode {

#define SC_ERROR_DEF(name,code,msg)\
  name = code, /** str */

#define SC_ERROR_END ErrLast };

/** error categories.. */
#define SC_ERR_START    10


#elif defined(SC_ERROR_BUILD_TABLE)

// build table


struct sc_error_t
{
  long    _code;
  String  _msg;
};


#define SC_ERROR_BEGIN static const struct sc_error_t errors[] = {

#define SC_ERROR_DEF(name,code,msg)\
  { code, msg },

#define SC_ERROR_END { 0, String(0) } };

#endif // SC_ERROR_BUILD_ENUM


/** build the enum or the table */

SC_ERROR_BEGIN
  // basic errors
  SC_ERROR_DEF( ErrUnknown,        SC_ERR_START + 0, String(_n("unknown error code")) )
  SC_ERROR_DEF( ErrSvn,            SC_ERR_START + 1, String(_n("error (subversion)")) )
  SC_ERROR_DEF( ErrApr,            SC_ERR_START + 2, String(_n("error (apr)")) )

  // specific errors
  SC_ERROR_DEF( ErrNoFile,         SC_ERR_START + 3, String(_n("file does not exist")) )
  SC_ERROR_DEF( ErrEncoding,       SC_ERR_START + 4, String(_n("unknown text encoding")) )
  SC_ERROR_DEF( ErrNoTextFile,     SC_ERR_START + 5, String(_n("file is not a text file")) )
  SC_ERROR_DEF( ErrDump,           SC_ERR_START + 6, String(_n("dump file")) )
SC_ERROR_END


#undef SC_ERROR_BEGIN
#undef SC_ERROR_DEF
#undef SC_ERROR_END


#ifdef SC_ERROR_BUILD_ENUM
String strError( ErrorCode code );
#endif // SC_ERROR_BUILD_ENUM

} // namespace

#endif // #if defined(SC_ERROR_BUILD_TABLE) || !defined(SC_ERROR_BUILD_ENUM)

