/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "Color.h"
#include <iostream>


/*
 *
 */
Color::Color()
{
	set(0,0,0,255);
}

Color::Color(unsigned int r, unsigned int g, unsigned int b, unsigned int a)
{
	set(r,g,b,a);
}
/*
Color::Color(const Gdk::Color &gdkcolor, unsigned int alpha)
{
	setGdkColor(gdkcolor, alpha);
}
*/

/*
 *
 */
void Color::set(unsigned int r, unsigned int g, unsigned int b, unsigned a)
{
#define clamp(x,min,max) if(x<min) x=min; else if(x>max) x=max;
	
	clamp(r,0,255);
	clamp(g,0,255);
	clamp(b,0,255);
	clamp(a,0,255);
	
	m_rgba[0]=r;
	m_rgba[1]=g;
	m_rgba[2]=b;
	m_rgba[3]=a;

#undef clamp
}


/*
 *
 */
/*
void Color::set(unsigned int rgb, unsigned int alpha)
{
	Color tmp;
	tmp.set(rgb);
	
	set(tmp.getR(), tmp.getG(), tmp.getB(), alpha);
}
*/


/*
 *	for SSA
 */
/*
unsigned int Color::getRGB()
{
	return (getB() << 16 | getG() << 8 | getR() << 0);
}
*/

/*
 *	for ASS
 */
/*
unsigned int Color::getRGBA()
{
	return rgba;
}
*/

/*
 *
 */
unsigned int Color::getR()
{
	return m_rgba[0];
	//return (rgba & 0x0000FF) >> 0;
}

unsigned int Color::getG()
{
	return m_rgba[1];
	//return (rgba & 0x00FF00) >> 8;
}

unsigned int Color::getB()
{
	return m_rgba[2];
	//return (rgba & 0xFF0000) >> 16;
}

unsigned int Color::getA()
{
	return m_rgba[3];
	//return ((rgba & 0xFF000000) >> 24);
}

/*
 *
 */
/*
void Color::setGdkColor(const Gdk::Color& gdkcolor, unsigned int alpha)
{
	unsigned int r = gdkcolor.get_red() / 257;
	unsigned int g = gdkcolor.get_green() / 257;
	unsigned int b = gdkcolor.get_blue() / 257;
	
	set(r,g,b,alpha);
}
*/

/*
 *
 */
/*
Gdk::Color Color::getGdkColor()
{
	Gdk::Color gdkcolor;
	gdkcolor.set_rgb(getR()*257, getG()*257, getB()*257);
	return gdkcolor;
}
*/

/*
 *	init button avec les info de color
 */
void Color::initColorButton(Gtk::ColorButton &button)
{
	Gdk::Color gdkcolor;
	gdkcolor.set_rgb(getR()*257, getG()*257, getB()*257);
	
	button.set_alpha(getA()*257);
	button.set_color(gdkcolor);

}

/*
 *	init color a partir de button
 */
void Color::getFromColorButton(const Gtk::ColorButton &button)
{
	Gdk::Color gdkcolor = button.get_color();
	
	unsigned int r = gdkcolor.get_red();
	unsigned int g = gdkcolor.get_green();
	unsigned int b = gdkcolor.get_blue();
	unsigned int a = button.get_alpha();

	set(r/257, g/257, b/257, a/257);
}
