/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */


#include "DialogMoveSubtitles.h"
//#include "utility.h"

/*
 *
 */
DialogMoveSubtitles::DialogMoveSubtitles(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
:Gtk::Dialog(cobject)
{
	refGlade->get_widget("spin-hours", m_spinHours);
	refGlade->get_widget("spin-mins", m_spinMins);
	refGlade->get_widget("spin-secs", m_spinSecs);
	refGlade->get_widget("spin-msecs", m_spinMSecs);

	set_default_response(Gtk::RESPONSE_OK);
}


void DialogMoveSubtitles::execute()
{
	Gtk::TreeIter it = SE::getInstance()->getSubtitleView()->getSelected();
	if(!it)
	{
		return;
	}

	SubtitleColumnRecorder m_column;

	SubtitleTime t((*it)[m_column.start]);

	m_spinHours->set_value(t.hours);
	m_spinMins->set_value(t.mins);
	m_spinSecs->set_value(t.secs);
	m_spinMSecs->set_value(t.msecs);

	if(run() == Gtk::RESPONSE_OK)
	{
		int hours = (int)m_spinHours->get_value();
		int mins = (int)m_spinMins->get_value();
		int secs = (int)m_spinSecs->get_value();
		int msecs = (int)m_spinMSecs->get_value();

		long diff = (SubtitleTime(hours, mins, secs, msecs) - t).totalmsecs;

		for( ; it; ++it)
		{
			// on n'utilise pas SubtitleModifier pour ne pas avoir
			// a recalculer a chaque fois "duration"
			(*it)[m_column.start] = SubtitleTime(SubtitleTime((*it)[m_column.start]).totalmsecs + diff).str();
			(*it)[m_column.end] = SubtitleTime(SubtitleTime((*it)[m_column.end]).totalmsecs + diff).str();
		}
	}
}
