#ifndef _SubtitleModel_h
#define _SubtitleModel_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <gtkmm/liststore.h>
#include "SubtitleTime.h"

class NameModel : public Gtk::ListStore
{
public:
	
	/*
	 *
	 */
	class Column : public Gtk::TreeModel::ColumnRecord
	{
	public:
		Column()
		{
			add(name);
		}

		Gtk::TreeModelColumn<Glib::ustring> name;
	};

public:
	
	/*
	 *	constructor
	 */
	NameModel()
	{
		set_column_types(m_column);
	}
	
public:
	Column	m_column;
};


/*
 *
 */
class SubtitleColumnRecorder : public Gtk::TreeModel::ColumnRecord
{
public:
	SubtitleColumnRecorder()
	{
		add(num);
		add(layer);
		add(start);
		add(end);
		add(duration);
		add(style);
		add(name);
		add(marginL);
		add(marginR);
		add(marginV);
		add(effect);
		add(text);
		add(translation);
		add(characters_per_line);
	}

	Gtk::TreeModelColumn<unsigned int>	 num;
	
	Gtk::TreeModelColumn<Glib::ustring>		layer;
	
	Gtk::TreeModelColumn<Glib::ustring>		start;
	Gtk::TreeModelColumn<Glib::ustring>		end;
	Gtk::TreeModelColumn<Glib::ustring>		duration;
	
	Gtk::TreeModelColumn<Glib::ustring>		style;
	Gtk::TreeModelColumn<Glib::ustring>		name;

	Gtk::TreeModelColumn<Glib::ustring>		marginL;
	Gtk::TreeModelColumn<Glib::ustring>		marginR;
	Gtk::TreeModelColumn<Glib::ustring>		marginV;

	Gtk::TreeModelColumn<Glib::ustring>		effect;

	Gtk::TreeModelColumn<Glib::ustring>		text;

	Gtk::TreeModelColumn<Glib::ustring>		translation;
	Gtk::TreeModelColumn<Glib::ustring>		characters_per_line;
};


/*
 *
 */
class SubtitleModel : public Gtk::ListStore
{
public:
	SubtitleModel();

	/*
	 * num = 0, start=end=0, ...
	 */
	void init(Gtk::TreeIter &iter);
	
	/*
	 *
	 */
	Gtk::TreeIter append();

	/*
	 *	retourne le premier element de la list
	 *	ou un iterator invalide
	 */
	Gtk::TreeIter getFirst();

	/*
	 *	retourne le dernier element de la list
	 *	ou un iterator invalide
	 */
	Gtk::TreeIter getLast();

	/*
	 *	retourne le nombre d'element dans la list
	 */
	unsigned int	getSize();

	/*
	 *	FONCTION DE RECHERCHE ****************************************************
	 */
	
	/*
	 *	recherche un subtitle grace a son numero
	 */
	Gtk::TreeIter find(unsigned int num);

	/*
	 *	recherche un subtitle grace a son temps
	 *	si time est compris entre start et end
	 */
	Gtk::TreeIter find(const SubtitleTime &time);
	
	/*
	 *	recherche un soustitre par rapport au temps
	 *	mais seulement si il est compris ou superieur au temps
	 */
	Gtk::TreeIter find_in_or_after(const SubtitleTime &time);
	
	/*
	 *	recherche a partir de start (+1) dans le text des subtitles
	 */
	Gtk::TreeIter find_text(Gtk::TreeIter &start, const Glib::ustring &text);
	
	/*
	 *	recherche l'iterator precedant iter
	 */
	Gtk::TreeIter find_previous(Gtk::TreeIter &iter);

	/*
	 *	recherche l'iterator suivant iter
	 *	(c'est pour la forme dans notre cas un simple ++iter donne la solution)
	 */
	Gtk::TreeIter find_next(Gtk::TreeIter &iter);

	/*
	 *	FONCTION D'EDITION	******************************************************
	 */
	
	/*
	 *	deplace tous les sous titres entre start et end de msecs.
	 */
	void move_in(unsigned int start, unsigned int end, unsigned int msecs);

	/*
	 *	deplace tous les sous titres a partir de start de msecs.
	 */
	void move_all(unsigned int start, unsigned int msecs);
	
	/*
	 *	insert sub avant iter et retourne l'iter de sub
	 *	et declale tout les autres (num)
	 */
	Gtk::TreeIter insertBefore(Gtk::TreeIter &iter);

	/*
	 *	insert sub apres iter et retourne l'iter de sub
	 *	et declale tout les autres (num)
	 */
	Gtk::TreeIter insertAfter(Gtk::TreeIter &iter);
	
	/*
	 *	efface un subtitle, on init les suivants avec le bon num
	 */
	void remove(Gtk::TreeIter &iter);
	
	/*
	 *	efface des elements de start a end
	 *	[start,end]
	 */
	void remove(unsigned int start, unsigned int end);

	/*
	 *	fait une copy de src dans this
	 */
	void copy(Glib::RefPtr<SubtitleModel> src);

	/*
	 *	check la colonne num pour init de [1,size]
	 */
	void rebuild_column_num();
protected:
	SubtitleColumnRecorder	m_column;
};


#endif//_SubtitleModel_h
