/**
 * \file SwamiUIGenGraph.h
 * \brief UI SoundFont generator graph control object
 */

/*
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMIUI_GENGRAPH_H__
#define __SWAMIUI_GENGRAPH_H__

#include <gtk/gtk.h>
#include <instpatch.h>

#include "swamidll.h"

typedef struct _SwamiUIGenGraph SwamiUIGenGraph;
typedef struct _SwamiUIGenGraphClass SwamiUIGenGraphClass;
typedef struct _GraphCache GraphCache;

#define SWAMIUI_TYPE_GENGRAPH   (swamiui_gengraph_get_type ())
#define SWAMIUI_GENGRAPH(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_GENGRAPH, SwamiUIGenGraph))
#define SWAMIUI_GENGRAPH_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_GENGRAPH, SwamiUIGenGraphClass))
#define SWAMIUI_IS_GENGRAPH(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_GENGRAPH))
#define SWAMIUI_IS_GENGRAPH_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_GENGRAPH))

struct _SwamiUIGenGraph
{
  GtkHPaned parent;
  GtkWidget *canvas;		/* canvas widget */
  IPZone *zone;			/* default zone */
  GList *ctrls;			/* private list of control items */
  GraphCache *cache;		/* graph variable cache */
  gboolean queue_update;	/* queue sync of gengraph to zone */
};

struct _SwamiUIGenGraphClass
{
  GtkHPanedClass parent_class;
};

SWAMI_API guint swamiui_gengraph_get_type (void);
SWAMI_API GtkWidget *swamiui_gengraph_new (void);
SWAMI_API void swamiui_gengraph_set_item (SwamiUIGenGraph *gengraph,
					  IPItem *item);

#endif
