/***************************************************************************
                     thmlhtml.cpp  -  ThML to HTML filter
                             -------------------
    begin                : 1999-10-27
    copyright            : 2001 by CrossWire Bible Society
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <thmlhtml.h>
#include <swmodule.h>
#include <utilxml.h>

SWORD_NAMESPACE_START

ThMLHTML::ThMLHTML() {
	setTokenStart("<");
	setTokenEnd(">");
/*
	setEscapeStart("&");
	setEscapeEnd(";");

	setEscapeStringCaseSensitive(true);

	addEscapeStringSubstitute("nbsp", " ");
	addEscapeStringSubstitute("quot", "\"");
	addEscapeStringSubstitute("amp", "&");
	addEscapeStringSubstitute("lt", "<");
	addEscapeStringSubstitute("gt", ">");
	addEscapeStringSubstitute("brvbar", "|");
	addEscapeStringSubstitute("sect", "");
	addEscapeStringSubstitute("copy", "");
	addEscapeStringSubstitute("laquo", "");
	addEscapeStringSubstitute("reg", "");
	addEscapeStringSubstitute("acute", "");
	addEscapeStringSubstitute("para", "");
	addEscapeStringSubstitute("raquo", "");

	addEscapeStringSubstitute("Aacute", "");
	addEscapeStringSubstitute("Agrave", "");
	addEscapeStringSubstitute("Acirc", "");
	addEscapeStringSubstitute("Auml", "");
	addEscapeStringSubstitute("Atilde", "");
	addEscapeStringSubstitute("Aring", "");
	addEscapeStringSubstitute("aacute", "");
	addEscapeStringSubstitute("agrave", "");
	addEscapeStringSubstitute("acirc", "");
	addEscapeStringSubstitute("auml", "");
	addEscapeStringSubstitute("atilde", "");
	addEscapeStringSubstitute("aring", "");
	addEscapeStringSubstitute("Eacute", "");
	addEscapeStringSubstitute("Egrave", "");
	addEscapeStringSubstitute("Ecirc", "");
	addEscapeStringSubstitute("Euml", "");
	addEscapeStringSubstitute("eacute", "");
	addEscapeStringSubstitute("egrave", "");
	addEscapeStringSubstitute("ecirc", "");
	addEscapeStringSubstitute("euml", "");
	addEscapeStringSubstitute("Iacute", "");
	addEscapeStringSubstitute("Igrave", "");
	addEscapeStringSubstitute("Icirc", "");
	addEscapeStringSubstitute("Iuml", "");
	addEscapeStringSubstitute("iacute", "");
	addEscapeStringSubstitute("igrave", "");
	addEscapeStringSubstitute("icirc", "");
	addEscapeStringSubstitute("iuml", "");
	addEscapeStringSubstitute("Oacute", "");
	addEscapeStringSubstitute("Ograve", "");
	addEscapeStringSubstitute("Ocirc", "");
	addEscapeStringSubstitute("Ouml", "");
	addEscapeStringSubstitute("Otilde", "");
	addEscapeStringSubstitute("oacute", "");
	addEscapeStringSubstitute("ograve", "");
	addEscapeStringSubstitute("ocirc", "");
	addEscapeStringSubstitute("ouml", "");
	addEscapeStringSubstitute("otilde", "");
	addEscapeStringSubstitute("Uacute", "");
	addEscapeStringSubstitute("Ugrave", "");
	addEscapeStringSubstitute("Ucirc", "");
	addEscapeStringSubstitute("Uuml", "");
	addEscapeStringSubstitute("uacute", "");
	addEscapeStringSubstitute("ugrave", "");
	addEscapeStringSubstitute("ucirc", "");
	addEscapeStringSubstitute("uuml", "");
	addEscapeStringSubstitute("Yacute", "");
	addEscapeStringSubstitute("yacute", "");
	addEscapeStringSubstitute("yuml", "");

	addEscapeStringSubstitute("deg", "");
	addEscapeStringSubstitute("plusmn", "");
	addEscapeStringSubstitute("sup2", "");
	addEscapeStringSubstitute("sup3", "");
	addEscapeStringSubstitute("sup1", "");
	addEscapeStringSubstitute("nbsp", "");
	addEscapeStringSubstitute("pound", "");
	addEscapeStringSubstitute("cent", "");
	addEscapeStringSubstitute("frac14", "");
	addEscapeStringSubstitute("frac12", "");
	addEscapeStringSubstitute("frac34", "");
	addEscapeStringSubstitute("iquest", "");
	addEscapeStringSubstitute("iexcl", "");
	addEscapeStringSubstitute("ETH", "");
	addEscapeStringSubstitute("eth", "");
	addEscapeStringSubstitute("THORN", "");
	addEscapeStringSubstitute("thorn", "");
	addEscapeStringSubstitute("AElig", "");
	addEscapeStringSubstitute("aelig", "");
	addEscapeStringSubstitute("Oslash", "");
	addEscapeStringSubstitute("curren", "");
	addEscapeStringSubstitute("Ccedil", "");
	addEscapeStringSubstitute("ccedil", "");
	addEscapeStringSubstitute("szlig", "");
	addEscapeStringSubstitute("Ntilde", "");
	addEscapeStringSubstitute("ntilde", "");
	addEscapeStringSubstitute("yen", "");
	addEscapeStringSubstitute("not", "");
	addEscapeStringSubstitute("ordf", "");
	addEscapeStringSubstitute("uml", "");
	addEscapeStringSubstitute("shy", "");
	addEscapeStringSubstitute("macr", "");
*/
	setTokenCaseSensitive(true);

	addTokenSubstitute("note", " <font color=\"#800000\"><small>(");
	addTokenSubstitute("/note", ")</small></font> ");
}


bool ThMLHTML::handleToken(SWBuf &buf, const char *token, BasicFilterUserData *userData) {
	if (!substituteToken(buf, token)) { // manually process if it wasn't a simple substitution
		MyUserData *u = (MyUserData *)userData;
		XMLTag tag(token);
		if (!strcmp(tag.getName(), "sync")) {
			if (tag.getAttribute("type") && tag.getAttribute("value") && !strcmp(tag.getAttribute("type"), "Strongs")) {
				const char* value = tag.getAttribute("value");
				if (*value == 'H' || *value == 'G' || *value == 'A') {
					value++;
					buf += "<small><em>";
					buf += value;
					buf += "</em></small>";
				}
				else if (*value == 'T') {
					value += 2;

					buf += "<small><i>";
					buf += value;
					buf += "</i></small>";
				}
			}
			else if (tag.getAttribute("type") && tag.getAttribute("value") && !strcmp(tag.getAttribute("type"), "morph")) {
				buf += "<small><em>";
				buf += tag.getAttribute("value");
				buf += "</em></small>";
			}
			else if (tag.getAttribute("type") && tag.getAttribute("value") && !strcmp(tag.getAttribute("type"), "lemma")) {
				buf += "<small><em>(";
				buf += tag.getAttribute("value");
				buf += ")</em></small>";
			}
		}
		else if (!strcmp(tag.getName(), "div")) {
			if (tag.isEndTag() && (u->SecHead)) {
				buf += "</i></b><br />";
				u->SecHead = false;
			}
			else if (tag.getAttribute("class")) {
				if (!strcmp(tag.getAttribute("class"), "sechead")) {
					u->SecHead = true;
					buf += "<br /><b><i>";
				}
				else if (!strcmp(tag.getAttribute("class"), "title")) {
					u->SecHead = true;
					buf += "<br /><b><i>";
				}
			}
		}
		else if (!strcmp(tag.getName(), "img")) {
			const char *src = strstr(token, "src");
			if (!src)		// assert we have a src attribute
				return false;

			buf += '<';
			for (const char *c = token; *c; c++) {
				if (c == src) {
					for (;((*c) && (*c != '"')); c++)
						buf += *c;

					if (!*c) { c--; continue; }

					buf += '"';
					if (*(c+1) == '/') {
						buf += "file:";
						buf += userData->module->getConfigEntry("AbsoluteDataPath");
						if (buf[buf.length()-2] == '/')
							c++;		// skip '/'
					}
					continue;
				}
				buf += *c;
			}
			buf += '>';
		}
		else if (!strcmp(tag.getName(), "scripRef")) { //do nothing with scrip refs, we leave them out

		}
		else {
			buf += '<';
			buf += token;
			buf += '>';

//			return false;  // we still didn't handle token
		}
	}
	return true;
}


SWORD_NAMESPACE_END
