/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GPSERIAL_H
#define GPSERIAL_H

#include <qthread.h>
#include <qstring.h>
#include <qapplication.h>

#include <kmainwindow.h>

#include <stdio.h>   /* Standard input/output definitions */
#include <string.h>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <termios.h> /* POSIX terminal control definitions */

#include "frmconfigini.h"
#include "config.h"

enum gprmc_data		// $GPRMC sentence fields
{
	sentence=0,
	sat_time,
	status,
	lat,
	lat_hemisf,
	lng,
	lng_hemisf,
	speed,
	bearing,
	date,
	magnet,
	checksum,
};

typedef struct gdata
{
	double lat_dms;			// latutide in deg/min/seg (DDMMSS)
	double lat_ddeg;		// latitude in decimal degrees
	double lat_dmin;		// latitude in decimal minutes
	double long_dms;		// longitude in deg/min/seg (DDMMSS)
	double long_ddeg;		// longitude in decimal degrees
	double long_dmin;		// longitude in decimal minutes
	double speed_knots;		// speed in knots
	double speed_mph;		// speed in miles per hour
	double speed_kph;		// speed in kilometers per hour
}geodata;

class GPSerial : public QThread {
  private:
	  int 		des;	// File descriptor of the port
 	  KMainWindow* 	parentobject;
	  const char*	objname;
	  
  public:
	  GPSerial(){ qDebug("Creating gpserial..."); };
	  GPSerial(KMainWindow * p, const char* n) : parentobject(p), objname(qstrdup(n)) { qDebug("Creating gpserial..."); };
	  ~GPSerial();
	  
	  virtual void run();
	  
	  int openPort(char * dev);
	  void closePort(int desc);
	  void configure(int fd);
	  int getData(char * buf);
	  int parseData(char * b, geodata* g);
	  int getDescriptor() { return des; };
	  double toDMS(double dmin);
	  double toDDeg(double dmin);
	  double toDMin(QString s);
	  const char * name() { return objname; };
	  void setName(const char * n ) { objname = qstrdup(n); };
	  KMainWindow * parent() { return parentobject; }; 
};

#endif
