/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "gpslog.h"

gpslog::gpslog()
{
}

int gpslog::open(QString file)
{
	uint answer;

	if (file == "")	
		file = KFileDialog::getSaveFileName(
					":<swslogfiles>",
					"*.swl|" + i18n("SWScanner GPS Log files") + " (*.swl)",
					0,
					i18n("Choose a logfile to save under"));		
	if (file == "") 
		return -1;
	
	logfile.setName( file );
	
	answer = KMessageBox::Yes;
	if (logfile.exists())
		answer = KMessageBox::questionYesNoCancel(0, i18n("A file called %1 already exists. Do you want to overwrite it?\n"
								"Select 'Yes' to overwrite it, or 'No' to append data to it.").arg( file ));
	switch (answer)
	{
		case KMessageBox::Yes:  // Overwrite
			logfile.remove();  // Delete previous
			if (!openLogFile())
			{
				close();
				return -3;
			}
			addLine("# $Creator: Simple Wireless Scanner (SWScanner) Version " + QString(VERSION));
			addLine("# $Format: adaptation of NetStumbler wi-scan with stensions.");
			addLine("# Latitude\tLongitude\t( SSID )\tType\t( BSSID )\tTime (GMT)\t[ SNR Sig Noise ]\t# ( Name )\tFlags\tChannelbits\tBcnIntvl\tDataRate\tLastChannel");
			addLine("# $DateGMT: " + QDate::currentDate(Qt::UTC).toString(Qt::ISODate));
			return 0;
	
		case KMessageBox::No: // Don't Overwrite, append
			if (!openLogFile())
			{
				close();
				return -3;
			}
			addLine("# $Creator: Simple Wireless Scanner (SWScanner) Version " + QString(VERSION));
			addLine("# $Format: adaptation of NetStumbler wi-scan with stensions.");
			addLine("# Latitude\tLongitude\t( SSID )\tType\t( BSSID )\tTime (GMT)\t[ SNR Sig Noise ]\t# ( Name )\tFlags\tChannelbits\tBcnIntvl\tDataRate\tLastChannel");
			addLine("# $DateGMT: " + QDate::currentDate(Qt::UTC).toString(Qt::ISODate));
			return 0;
	
		default: // Cancelled
			close();
			return -2;
	}
	return 0;
}

void gpslog::close()
{
	logfile.close();
	filename=QString::null;
}

void gpslog::addLine(APEntry * ap, double longi, double lati)
{
	char temp[32];
	int flag=0;
	long chan=0;
	QString str, snr, sig, noi, aux;
	
	if (ap->getSignal() == 0)
		sig=QVariant(ap->getSignalMax()+149).toString();
	else
		sig=QVariant(ap->getSignal()+149).toString();

	if (ap->getNoise() == 0)
		noi=QVariant( sig.toInt() - ap->getSNRMax() ).toString(); 
	else
		noi=QVariant(ap->getNoise()+149).toString();

	snr=QVariant(sig.toInt() - noi.toInt()).toString();
	
	if (lati > 0.0)
		str = "N " + aux.setNum(lati,'f',7);
	else
		str = "S " + aux.setNum(-lati,'f',7);
	if (longi > 0.0)
		str += "\tE " + aux.setNum(longi, 'f',7);
	else
		str += "\tW " + aux.setNum(-longi, 'f',7);
	str += "\t( " + QString(ap->getEssid(temp)) + " )";
	str += (ap->getMode()==0)? "\tBSS" : "\tad-hoc";
	str += "\t( " + QString(ap->getMAC(temp)).lower() + " )";
	str += "\t" + QTime::currentTime(Qt::UTC).toString() + " (GMT)";
	str += "\t[ "+ snr + " " + sig + " " + noi + " ]";
	str += "\t# (  )";	// Name is not supporter in SWScanner
		flag |= (ap->getMode() == 0) ? 0x1 : 0x2;
		flag |= (ap->getWEP()) ? 0x10 : 0x0;
	str += "\t" + aux.sprintf( "%04x", flag );
		chan |= (ap->getChannel() == 1) ? 0x2 : 0;
		chan |= (ap->getChannel() == 2) ? 0x4 : 0;	
		chan |= (ap->getChannel() == 3) ? 0x8 : 0;
		chan |= (ap->getChannel() == 4) ? 0x10 : 0;
		chan |= (ap->getChannel() == 5) ? 0x20 : 0;
		chan |= (ap->getChannel() == 6) ? 0x40 : 0;
		chan |= (ap->getChannel() == 7) ? 0x80 : 0;
		chan |= (ap->getChannel() == 8) ? 0x100 : 0;
		chan |= (ap->getChannel() == 9) ? 0x200 : 0;
		chan |= (ap->getChannel() == 10) ? 0x400 : 0;
		chan |= (ap->getChannel() == 11) ? 0x800 : 0;
		chan |= (ap->getChannel() == 12) ? 0x1000 : 0;
		chan |= (ap->getChannel() == 13) ? 0x2000 : 0;
		chan |= (ap->getChannel() == 14) ? 0x4000 : 0;
	str += "\t" +  aux.sprintf("%08lx",chan);
	str += "\t0";		// Beacon int not supported in SWScanner
	str += "\t0";		// Same with DataRate
	str += "\t0";		// Same with LastChanner
	addLine(str);

}

void gpslog::addLine(QString line)
{
	QTextStream stream( &logfile );
	stream << line << "\n";
}

bool gpslog::openLogFile()
{
	if (!logfile.open( IO_WriteOnly | IO_Append ))
	{
		KMessageBox::error(0, i18n("Error while opening '%1' for writing: ").arg(logfile.name()) + logfile.errorString());
		return FALSE;
	}
	return TRUE;
}

gpslog::~gpslog()
{
}

