/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "scanthread.h"

ScanThread::ScanThread(KMainWindow * parent, const char * name, char * ifc)
{
	qDebug ("Creating scanning thread...\n");
	parentobject = parent;
	setName(name);
	setIface(ifc);
}


ScanThread::~ScanThread()
{
	if ( objname )	delete [] (char*) objname;
	qDebug ("Deleting scanning thread...");
}

void ScanThread::run()
{
	char temp[32];
	int retval = 0;
	QString errorString;

	printf ("Starting a new scan thread!!\n");
	SWSglobals::nodes()->lock();
		SWSglobals::nodes()->clear();					// Empty the list
		retval = start_scan( getIface(temp), SWSglobals::nodes() );	// Fills the ap list with new scan data
		if (retval == 0)
		{
			scanFinishedEvent* ev = new scanFinishedEvent;
			QApplication::postEvent( parentobject, ev );	// Qt will delete it when done	
		}
		else
		{
			switch(retval)
			{
				case -1:
					errorString=i18n("Interface doesn't support scanning");
					break;
				case -2:
					errorString=i18n("Allocation failed");
					break;
				case -3:
					errorString=i18n(" Failed to read scan data");
					break;
			}
			scanErrorEvent* ev = new scanErrorEvent (errorString);
			QApplication::postEvent( parentobject, ev );
		}
		
		#if SWSDEBUG
			SWSglobals::nodes()->Display();
		#endif	
	SWSglobals::nodes()->unlock();
	printf ("Scan finished!!\n");
}

void ScanThread::setIface(char * i)
{

	mut.lock();
	strcpy(iface,i);
	mut.unlock();
}

char * ScanThread::getIface(char * temp)
{
	mut.lock();
	temp = strcpy(temp,iface);
	mut.unlock();
	return temp;
}
