#! /usr/bin/env python
import gtk
import pango

class FreeSpace(gtk.DrawingArea):
    def __init__(self, percentage):
        super(FreeSpace, self).__init__()        
        self.connect("expose_event", self.expose)
	self.percentage = percentage
	self.set_size_request(100, 25)

    def set_percentage (self, percentage):
	self.percentage = percentage
        
    def expose(self, widget, event):
	#if widget.get_direction == GTK_TEXT_DIR_RTL:
	#	is_rtl = True
	#else:
	#	is_rtl = False

        context = widget.window.cairo_create()
        
        # set a clip region for the expose event
        context.rectangle(event.area.x, event.area.y,
                          event.area.width, event.area.height)
        context.clip()
        
        self.draw(widget, context, *self.window.get_size())
        
        return False
    
    def draw(self, widget, context, width, height):	  
        context.set_source_rgb(1.0, 1.0, 1.0)
        context.rectangle(0, 0, width, height)
        context.fill()

	x_pad = 0
	y_pad = 0
	border = 1

	rel_x = x_pad + border
	rel_y = y_pad + border
	rel_width = width - (x_pad + border) * 2
	rel_height = height - (y_pad + border) * 2

        context.rectangle(x_pad, y_pad, width - x_pad * 2, height - y_pad * 2)
	context.set_source_color (widget.style.fg[gtk.STATE_NORMAL])
	context.fill()

	context.rectangle(rel_x, rel_y, rel_width, rel_height)
	context.set_source_color (widget.style.bg[gtk.STATE_NORMAL])
	context.fill()

	diff = int ((width - x_pad * 2 - border * 2) * (1.0 - self.percentage))

	# draw the free space
        context.rectangle(rel_x, rel_y, rel_width - diff, rel_height)
	context.set_source_color (widget.style.bg[gtk.STATE_SELECTED])
        context.fill()

	layout = widget.create_pango_layout(str(self.percentage * 100) +" %")
	logical_rect = layout.get_pixel_extents()[1]

	gdkcontext = gtk.gdk.GC(widget.window)
	gdkcontext.set_foreground(widget.style.fg[gtk.STATE_NORMAL]);
	gdkcontext.set_clip_rectangle(gtk.gdk.Rectangle(rel_width - diff, rel_y, rel_width, rel_height))

	widget.window.draw_layout(gdkcontext, (width - logical_rect[2]) / 2, (height - logical_rect[3]) / 2, layout)

	gdkcontext.set_foreground(widget.style.bg[gtk.STATE_NORMAL]);
	gdkcontext.set_clip_rectangle(gtk.gdk.Rectangle(rel_x, rel_y, rel_width - diff, rel_height))
	widget.window.draw_layout(gdkcontext, (width - logical_rect[2]) / 2, (height - logical_rect[3]) / 2, layout)

def main():
    window = gtk.Window()
    freespace = FreeSpace(0.46)
    
    window.add(freespace)
    window.connect("destroy", gtk.main_quit)
    window.show_all()
    
    gtk.main()
    
if __name__ == "__main__":
    main()
