# SongTransfer.py 
#  
#  Copyright (c) 2006 INdT (Instituto Nokia de Technologia)
#  
#  Author: Kenneth Rohde Christiansen <kenneth.christiansen@gmail.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

import urllib
import pyid3lib
import os
import sys
import gtk
import Utils

import PlaylistParserPLS


def transfer_songs(parent, view, playlist, playlist_name, device_path):
	songnumber = 0
	playlist_error = False;

	pathname = "%s/Music/"  % (device_path)
	pathname = pathname.encode(sys.getdefaultencoding()).strip()

	if not os.path.exists(pathname):
		os.makedirs (pathname)

	if os.path.exists(pathname + playlist_name + ".pls"):

		## Code that removes existing playlist and deleted the files
		## not in use by other playlists on the device.
		## 
		## The algorithm is as follows:
		##
		## o  read files from playlist - put in dictionary
		## o  delete playlist
		## o  read remote playlists again (not without that deleted playlist)
		## o  iterate through the playlists and look up in the hash and remove if found
		##   
		## Now we will have a hash only consisting of the songs that are not in other 
		## playlists and that we can safely delete.		

		old_pls = open(pathname + playlist_name + ".pls", "r")

		## 1: read files from playlist - put in dictionary

		songs_to_delete = {}
		lines = old_pls.readlines()[:]

		for line in lines:
			if line.startswith ("File"):
				song_location = pathname + line.split("=")[1].strip("\n")

				if not os.path.exists(song_location):
					continue

				songs_to_delete[song_location] = True

		## 2: delete playlist

		os.remove (pathname + playlist_name + ".pls")

		## 3: read remote playlists again (not without that deleted playlist)

		playlists_left = PlaylistParserPLS.parse_playlists(device_path)

		## 4: iterate through the playlists and look up in the hash and remove if found

		for remote_playlist in playlists_left:
			for song_location in remote_playlist[2]:
				songs_to_delete[song_location] = False

		for song_location in songs_to_delete.keys():
			if songs_to_delete[song_location] == True:
				os.remove(song_location)

	# create new playlist to fill:

	playlist_data = []

	for song in playlist[2]:
		if view.model.stop_transfer == True:
			break

		location = song[0]
		songnumber += 1

		temp1 = location.rsplit("/", 1)[-1]
		temp2 = temp1.rsplit(".", 1)
		filename = temp2[0]
		fileext = temp2[-1]

		info = pyid3lib.tag(location)

		try: 
			artist = Utils.unicodify(info.artist)
		except AttributeError, e:
			artist = u"Unknown"
		if artist == "":
			artist = u"Unknown"

		try: 
			album = Utils.unicodify(info.album)
		except AttributeError, e:
			album = u"Unknown"
		if album == "":
			album = u"Unknown"

		try: 
			title = Utils.unicodify(info.title)
		except AttributeError, e:
			title = Utils.unicodify(filename)

		try:
			remote_filename = u"%s/%s/%s. %s.%s" % (artist, album, info.track[0], title, fileext)
		except AttributeError, e:
			remote_filename = u"%s/%s/%s.%s" % (artist, album, title, fileext)		

		playlist_data_file = remote_filename
		playlist_data_title = "%s - %s\n" % (artist, title)
		
		try:
			playlist_data_length = str(info.songlen)	
		except AttributeError, e:
			playlist_data_length = "-1"

		pathname = "%s/Music/%s/%s"  % (device_path, artist, album)
		pathname = pathname.encode(sys.getdefaultencoding()).strip()

		filename = "%s/Music/%s" % (device_path, remote_filename)
		filename = filename.encode(sys.getdefaultencoding()).strip()

		if not os.path.exists(pathname):
			os.makedirs (pathname)

		try:
			if os.path.getsize(location) / 1024 < Utils.freespace(device_path):
				view.model.transferred_data += (os.path.getsize(location) / 1024) + 100

				gtk.gdk.threads_enter()		
				view.progress_image.set_from_pixbuf(gtk.icon_theme_get_default().load_icon("sound", 48, 0))		
				view.progress_label.set_label("Transferring <i>" + playlist_name + "</i>...")
				gtk.gdk.threads_leave()

				Utils.transfer_file(location, filename)

				gtk.gdk.threads_enter()				
				view.refresh_progress_meter()
				gtk.gdk.threads_leave()

				view.refresh_freespace()
			else: 
				print "  WARNING: Ran out of space, ignoring current song (%s - %s)" % (artist, title)
				songnumber -= 1
		except IOError, e:
			os.remove(filename)
			songnumber -= 1
			break

		playlist_data.append( (playlist_data_file, playlist_data_title, playlist_data_length) )
	
	playlist_error = write_pls_playlist(playlist_name, playlist_data, device_path)
	if not playlist_error:
		playlist_error = write_m3u_playlist(playlist_name, playlist_data, device_path)

	if playlist_error:
		dialog = gtk.MessageDialog(parent, 
			gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, 
			gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, 
			"Device ran out of space, playlist not updated")
		dialog.set_title("No space left on device")

		dialog.show()


def write_m3u_playlist(playlist_name, playlist_data, device_path):
	pathname = "%s/Music/"  % (device_path)
	playlist_error = False

	try:
		m3u = open(pathname + ".tmp-" + playlist_name + ".m3u", "w") 
		m3u.write("#EXTM3U\n")

		songnumber = 1

		for playlist_entry in playlist_data:
			line = "#EXTINF:%s,%s\n" % ("-1", playlist_entry[1].strip())
			line += "%s\n" % (playlist_entry[0].strip())
			m3u.write(line)
			m3u.flush()
			songnumber += 1

		m3u.close();	

		if not os.path.exists(pathname + ".tmp-" + playlist_name + ".m3u"):
			playlist_error = True
		if not Utils.BUFFER_SIZE < Utils.freespace (device_path):
			playlist_error = True
		if not os.path.getsize(pathname + ".tmp-" + playlist_name + ".m3u") < Utils.freespace (device_path):
			playlist_error = True

		Utils.transfer_file(pathname + ".tmp-" + playlist_name + ".m3u", pathname + playlist_name + ".m3u")

	except IOError, e:
		playlist_error = True

	return playlist_error

def write_pls_playlist(playlist_name, playlist_data, device_path):
	pathname = "%s/Music/"  % (device_path)
	playlist_error = False

	try:
		pls = open(pathname + ".tmp-" + playlist_name + ".pls", "w") 
		pls.write("[playlist]\n")

		songnumber = 1

		for playlist_entry in playlist_data:
			line = "File%s=%s\n" % (songnumber, playlist_entry[0].strip())
			line += "Title%s=%s\n" % (songnumber, playlist_entry[1].strip())
			line += "Length%s:%s\n" % (songnumber, playlist_entry[2].strip())
			pls.write(line)
			pls.flush()
			songnumber += 1

		pls.write("NumberOfEntries=%s\nVersion=2" % songnumber) 
		pls.close();	

		if not os.path.exists(pathname + ".tmp-" + playlist_name + ".pls"):
			playlist_error = True
		if not Utils.BUFFER_SIZE < Utils.freespace (device_path):
			playlist_error = True
		if not os.path.getsize(pathname + ".tmp-" + playlist_name + ".pls") < Utils.freespace (device_path):
			playlist_error = True

		Utils.transfer_file(pathname + ".tmp-" + playlist_name + ".pls", pathname + playlist_name + ".pls")

	except IOError, e:
		playlist_error = True

	return playlist_error


def transfer_photoalbums(parent, view, photoalbum, photoalbum_name, device_path):
	songnumber = 0

	pathname = "%s/Photos/"  % (device_path)
	pathname = pathname.encode(sys.getdefaultencoding()).strip()

	if not os.path.exists(pathname):
		os.makedirs (pathname)

	if os.path.exists(pathname + photoalbum_name):
		for current_file in os.listdir(pathname + photoalbum_name):
			os.remove(pathname + photoalbum_name + "/" + current_file)
	else:
		os.makedirs (pathname + photoalbum_name)

	for basepath in os.listdir(photoalbum[2]):
		if view.model.stop_transfer == True:
			break

		current_path = photoalbum[2] + "/" + basepath

		# F-Spot uses subdirs with the day number
		# code should be made more general
		if os.path.isdir(current_path):
			for basepath in os.listdir(current_path):
				if view.model.stop_transfer == True:
					break
				source = current_path + "/" + basepath
				target = pathname + photoalbum_name + "/" + basepath
				copy_photo(view, photoalbum_name, source, target, device_path)
		else:
			source = current_path
			target = pathname + photoalbum_name + "/" + basepath
			copy_photo(view, photoalbum_name, source, target, device_path)

def copy_photo(view, photoalbum_name, source, target, device_path):
	try:
		if os.path.getsize(source) / 1024 < Utils.freespace(device_path):
			view.model.transferred_data += (os.path.getsize(source) / 1024)

			gtk.gdk.threads_enter()				
			view.progress_image.set_from_pixbuf(gtk.icon_theme_get_default().load_icon("image", 48, 0))
			view.progress_label.set_label("Transferring <i>" + photoalbum_name + "</i>...")
			gtk.gdk.threads_leave()

			Utils.transfer_file(source, target)

			gtk.gdk.threads_enter()				
			view.refresh_progress_meter()
			gtk.gdk.threads_leave()

			view.refresh_freespace()
		else: 
			print "  WARNING: Ran out of space, ignoring current photo (%s - %s)" % (artist, title)
	except IOError, e:
		print "error"
