/*
  File autogenerated by gengetopt version 2.10
  generated with the following command:
  gengetopt --unamed-opts --no-handle-help --no-handle-version 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "cmdline.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  Synchronize Repositories\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", CMDLINE_PARSER_PACKAGE);
  printf("   -h         --help                     Print help and exit\n");
  printf("   -V         --version                  Print version and exit\n");
  printf("   -v         --verbose                  Enable verbose operation (default=off)\n");
  printf("   -T         --local-temp               Use temporary directory inside repository (default=off)\n");
  printf("              --ignore-origin            Don't warn if snapshot not local in update, merge, makepatch (default=off)\n");
  printf("   -z         --compress                 Compress snapshots or patches (default=off)\n");
  printf("              --list                     List a repository snapshot (default=off)\n");
  printf("              --show-deleted             list: Show deleted entries of repository snapshot (default=off)\n");
  printf("              --show-by-md               list: Show files by message digests (default=off)\n");
  printf("              --show-times               list: Show first and last seen times (default=off)\n");
  printf("              --sort                     list: sort chronologically (default=off)\n");
  printf("              --info                     Show information about a repository or snapshot (default=off)\n");
  printf("              --history                  Show history of a repository or snapshot (default=off)\n");
  printf("              --dump                     Show a structure dump of a repository or snapshot (default=off)\n");
  printf("              --update                   Update a repository snapshot (default=off)\n");
  printf("   -SSTRING   --snapshot=STRING          update: Use the specified snapshot file instead of the one contained in the repository\n");
  printf("   -CSTRING   --cache=STRING             update: Use the specified cache file instead of the one contained in the repository\n");
  printf("              --no-cache                 update: Don't use a message digest cache (default=off)\n");
  printf("              --no-purge                 update: Don't pruge obsolete entries from cache after update run (default=off)\n");
  printf("              --ro-cache                 update: Use read only cache (default=off)\n");
  printf("   -p         --progress                 update: Show progress (default=off)\n");
  printf("              --check-dev                update: Honour stat() st_dev field (default=off)\n");
  printf("              --diff                     Show difference between two repositories or snapshots (default=off)\n");
  printf("   -s         --sizes                    diff: show file sizes to copy (works online on repositories) (default=off)\n");
  printf("   -H         --human-readable           diff: show sizes human readable (default=off)\n");
  printf("              --merge                    Merge a snapshot or a repository into a repository (default=off)\n");
  printf("   -q         --question                 merge: Ask a question before each action (default=off)\n");
  printf("   -P         --prune-empty              merge: Prune empty directories (default=off)\n");
  printf("              --keep-trash               merge: Don't empty trash (default=off)\n");
  printf("              --check-md                 merge: Check message digest of file before deleting or replacing (default=off)\n");
  printf("              --always-copy              merge: Always copy instead of hard linking (default=off)\n");
  printf("              --always-replace           merge: Always replace existing files (default=off)\n");
  printf("              --makepatch                Make a patch against the specified repository (default=off)\n");
  printf("   -oSTRING   --output-file=STRING       makepatch: Write output to specified file instead of STDOUT\n");
  printf("              --include-all              makepatch: Include files in patch which do exist on the other side under a different name (default=off)\n");
  printf("              --extract                  Extract the context of a snapshot or patch (default=off)\n");
  printf("   -DSTRING   --output-directory=STRING  extract: Write output to specified directory\n");
  printf("              --cleanup                  Remove syrep info from repository (default=off)\n");
  printf("   -lINT      --cleanup-level=INT        cleanup: 1 - just remove temporary data and trash (default); 2 - remove MD cache as well; 3 - remove all syrep data (default='1')\n");
  printf("              --forget                   Forget old snapshot entries (default=off)\n");
  printf("   -RINT      --remember=INT             forget: information of how many days to remeber (default='180')\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->local_temp_given = 0 ;
  args_info->ignore_origin_given = 0 ;
  args_info->compress_given = 0 ;
  args_info->list_given = 0 ;
  args_info->show_deleted_given = 0 ;
  args_info->show_by_md_given = 0 ;
  args_info->show_times_given = 0 ;
  args_info->sort_given = 0 ;
  args_info->info_given = 0 ;
  args_info->history_given = 0 ;
  args_info->dump_given = 0 ;
  args_info->update_given = 0 ;
  args_info->snapshot_given = 0 ;
  args_info->cache_given = 0 ;
  args_info->no_cache_given = 0 ;
  args_info->no_purge_given = 0 ;
  args_info->ro_cache_given = 0 ;
  args_info->progress_given = 0 ;
  args_info->check_dev_given = 0 ;
  args_info->diff_given = 0 ;
  args_info->sizes_given = 0 ;
  args_info->human_readable_given = 0 ;
  args_info->merge_given = 0 ;
  args_info->question_given = 0 ;
  args_info->prune_empty_given = 0 ;
  args_info->keep_trash_given = 0 ;
  args_info->check_md_given = 0 ;
  args_info->always_copy_given = 0 ;
  args_info->always_replace_given = 0 ;
  args_info->makepatch_given = 0 ;
  args_info->output_file_given = 0 ;
  args_info->include_all_given = 0 ;
  args_info->extract_given = 0 ;
  args_info->output_directory_given = 0 ;
  args_info->cleanup_given = 0 ;
  args_info->cleanup_level_given = 0 ;
  args_info->forget_given = 0 ;
  args_info->remember_given = 0 ;
#define clear_args() { \
  args_info->verbose_flag = 0;\
  args_info->local_temp_flag = 0;\
  args_info->ignore_origin_flag = 0;\
  args_info->compress_flag = 0;\
  args_info->list_flag = 0;\
  args_info->show_deleted_flag = 0;\
  args_info->show_by_md_flag = 0;\
  args_info->show_times_flag = 0;\
  args_info->sort_flag = 0;\
  args_info->info_flag = 0;\
  args_info->history_flag = 0;\
  args_info->dump_flag = 0;\
  args_info->update_flag = 0;\
  args_info->snapshot_arg = NULL; \
  args_info->cache_arg = NULL; \
  args_info->no_cache_flag = 0;\
  args_info->no_purge_flag = 0;\
  args_info->ro_cache_flag = 0;\
  args_info->progress_flag = 0;\
  args_info->check_dev_flag = 0;\
  args_info->diff_flag = 0;\
  args_info->sizes_flag = 0;\
  args_info->human_readable_flag = 0;\
  args_info->merge_flag = 0;\
  args_info->question_flag = 0;\
  args_info->prune_empty_flag = 0;\
  args_info->keep_trash_flag = 0;\
  args_info->check_md_flag = 0;\
  args_info->always_copy_flag = 0;\
  args_info->always_replace_flag = 0;\
  args_info->makepatch_flag = 0;\
  args_info->output_file_arg = NULL; \
  args_info->include_all_flag = 0;\
  args_info->extract_flag = 0;\
  args_info->output_directory_arg = NULL; \
  args_info->cleanup_flag = 0;\
  args_info->cleanup_level_arg = 1 ;\
  args_info->forget_flag = 0;\
  args_info->remember_arg = 180 ;\
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "local-temp",	0, NULL, 'T' },
        { "ignore-origin",	0, NULL, 0 },
        { "compress",	0, NULL, 'z' },
        { "list",	0, NULL, 0 },
        { "show-deleted",	0, NULL, 0 },
        { "show-by-md",	0, NULL, 0 },
        { "show-times",	0, NULL, 0 },
        { "sort",	0, NULL, 0 },
        { "info",	0, NULL, 0 },
        { "history",	0, NULL, 0 },
        { "dump",	0, NULL, 0 },
        { "update",	0, NULL, 0 },
        { "snapshot",	1, NULL, 'S' },
        { "cache",	1, NULL, 'C' },
        { "no-cache",	0, NULL, 0 },
        { "no-purge",	0, NULL, 0 },
        { "ro-cache",	0, NULL, 0 },
        { "progress",	0, NULL, 'p' },
        { "check-dev",	0, NULL, 0 },
        { "diff",	0, NULL, 0 },
        { "sizes",	0, NULL, 's' },
        { "human-readable",	0, NULL, 'H' },
        { "merge",	0, NULL, 0 },
        { "question",	0, NULL, 'q' },
        { "prune-empty",	0, NULL, 'P' },
        { "keep-trash",	0, NULL, 0 },
        { "check-md",	0, NULL, 0 },
        { "always-copy",	0, NULL, 0 },
        { "always-replace",	0, NULL, 0 },
        { "makepatch",	0, NULL, 0 },
        { "output-file",	1, NULL, 'o' },
        { "include-all",	0, NULL, 0 },
        { "extract",	0, NULL, 0 },
        { "output-directory",	1, NULL, 'D' },
        { "cleanup",	0, NULL, 0 },
        { "cleanup-level",	1, NULL, 'l' },
        { "forget",	0, NULL, 0 },
        { "remember",	1, NULL, 'R' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVvTzS:C:psHqPo:D:l:R:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (args_info->help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (args_info->version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->version_given = 1;
          return 0;

        case 'v':	/* Enable verbose operation.  */
          if (args_info->verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->verbose_given = 1;
          args_info->verbose_flag = !(args_info->verbose_flag);
          break;

        case 'T':	/* Use temporary directory inside repository.  */
          if (args_info->local_temp_given)
            {
              fprintf (stderr, "%s: `--local-temp' (`-T') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->local_temp_given = 1;
          args_info->local_temp_flag = !(args_info->local_temp_flag);
          break;

        case 'z':	/* Compress snapshots or patches.  */
          if (args_info->compress_given)
            {
              fprintf (stderr, "%s: `--compress' (`-z') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->compress_given = 1;
          args_info->compress_flag = !(args_info->compress_flag);
          break;

        case 'S':	/* update: Use the specified snapshot file instead of the one contained in the repository.  */
          if (args_info->snapshot_given)
            {
              fprintf (stderr, "%s: `--snapshot' (`-S') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->snapshot_given = 1;
          args_info->snapshot_arg = gengetopt_strdup (optarg);
          break;

        case 'C':	/* update: Use the specified cache file instead of the one contained in the repository.  */
          if (args_info->cache_given)
            {
              fprintf (stderr, "%s: `--cache' (`-C') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->cache_given = 1;
          args_info->cache_arg = gengetopt_strdup (optarg);
          break;

        case 'p':	/* update: Show progress.  */
          if (args_info->progress_given)
            {
              fprintf (stderr, "%s: `--progress' (`-p') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->progress_given = 1;
          args_info->progress_flag = !(args_info->progress_flag);
          break;

        case 's':	/* diff: show file sizes to copy (works online on repositories).  */
          if (args_info->sizes_given)
            {
              fprintf (stderr, "%s: `--sizes' (`-s') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->sizes_given = 1;
          args_info->sizes_flag = !(args_info->sizes_flag);
          break;

        case 'H':	/* diff: show sizes human readable.  */
          if (args_info->human_readable_given)
            {
              fprintf (stderr, "%s: `--human-readable' (`-H') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->human_readable_given = 1;
          args_info->human_readable_flag = !(args_info->human_readable_flag);
          break;

        case 'q':	/* merge: Ask a question before each action.  */
          if (args_info->question_given)
            {
              fprintf (stderr, "%s: `--question' (`-q') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->question_given = 1;
          args_info->question_flag = !(args_info->question_flag);
          break;

        case 'P':	/* merge: Prune empty directories.  */
          if (args_info->prune_empty_given)
            {
              fprintf (stderr, "%s: `--prune-empty' (`-P') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->prune_empty_given = 1;
          args_info->prune_empty_flag = !(args_info->prune_empty_flag);
          break;

        case 'o':	/* makepatch: Write output to specified file instead of STDOUT.  */
          if (args_info->output_file_given)
            {
              fprintf (stderr, "%s: `--output-file' (`-o') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->output_file_given = 1;
          args_info->output_file_arg = gengetopt_strdup (optarg);
          break;

        case 'D':	/* extract: Write output to specified directory.  */
          if (args_info->output_directory_given)
            {
              fprintf (stderr, "%s: `--output-directory' (`-D') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->output_directory_given = 1;
          args_info->output_directory_arg = gengetopt_strdup (optarg);
          break;

        case 'l':	/* cleanup: 1 - just remove temporary data and trash (default); 2 - remove MD cache as well; 3 - remove all syrep data.  */
          if (args_info->cleanup_level_given)
            {
              fprintf (stderr, "%s: `--cleanup-level' (`-l') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->cleanup_level_given = 1;
          args_info->cleanup_level_arg = strtol (optarg,&stop_char,0);
          break;

        case 'R':	/* forget: information of how many days to remeber.  */
          if (args_info->remember_given)
            {
              fprintf (stderr, "%s: `--remember' (`-R') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->remember_given = 1;
          args_info->remember_arg = strtol (optarg,&stop_char,0);
          break;


        case 0:	/* Long option with no short option */
          /* Don't warn if snapshot not local in update, merge, makepatch.  */
          if (strcmp (long_options[option_index].name, "ignore-origin") == 0)
          {
            if (args_info->ignore_origin_given)
              {
                fprintf (stderr, "%s: `--ignore-origin' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ignore_origin_given = 1;
            args_info->ignore_origin_flag = !(args_info->ignore_origin_flag);
            break;
          }
          
          /* List a repository snapshot.  */
          else if (strcmp (long_options[option_index].name, "list") == 0)
          {
            if (args_info->list_given)
              {
                fprintf (stderr, "%s: `--list' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->list_given = 1;
            args_info->list_flag = !(args_info->list_flag);
            break;
          }
          
          /* list: Show deleted entries of repository snapshot.  */
          else if (strcmp (long_options[option_index].name, "show-deleted") == 0)
          {
            if (args_info->show_deleted_given)
              {
                fprintf (stderr, "%s: `--show-deleted' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->show_deleted_given = 1;
            args_info->show_deleted_flag = !(args_info->show_deleted_flag);
            break;
          }
          
          /* list: Show files by message digests.  */
          else if (strcmp (long_options[option_index].name, "show-by-md") == 0)
          {
            if (args_info->show_by_md_given)
              {
                fprintf (stderr, "%s: `--show-by-md' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->show_by_md_given = 1;
            args_info->show_by_md_flag = !(args_info->show_by_md_flag);
            break;
          }
          
          /* list: Show first and last seen times.  */
          else if (strcmp (long_options[option_index].name, "show-times") == 0)
          {
            if (args_info->show_times_given)
              {
                fprintf (stderr, "%s: `--show-times' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->show_times_given = 1;
            args_info->show_times_flag = !(args_info->show_times_flag);
            break;
          }
          
          /* list: sort chronologically.  */
          else if (strcmp (long_options[option_index].name, "sort") == 0)
          {
            if (args_info->sort_given)
              {
                fprintf (stderr, "%s: `--sort' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->sort_given = 1;
            args_info->sort_flag = !(args_info->sort_flag);
            break;
          }
          
          /* Show information about a repository or snapshot.  */
          else if (strcmp (long_options[option_index].name, "info") == 0)
          {
            if (args_info->info_given)
              {
                fprintf (stderr, "%s: `--info' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->info_given = 1;
            args_info->info_flag = !(args_info->info_flag);
            break;
          }
          
          /* Show history of a repository or snapshot.  */
          else if (strcmp (long_options[option_index].name, "history") == 0)
          {
            if (args_info->history_given)
              {
                fprintf (stderr, "%s: `--history' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->history_given = 1;
            args_info->history_flag = !(args_info->history_flag);
            break;
          }
          
          /* Show a structure dump of a repository or snapshot.  */
          else if (strcmp (long_options[option_index].name, "dump") == 0)
          {
            if (args_info->dump_given)
              {
                fprintf (stderr, "%s: `--dump' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->dump_given = 1;
            args_info->dump_flag = !(args_info->dump_flag);
            break;
          }
          
          /* Update a repository snapshot.  */
          else if (strcmp (long_options[option_index].name, "update") == 0)
          {
            if (args_info->update_given)
              {
                fprintf (stderr, "%s: `--update' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->update_given = 1;
            args_info->update_flag = !(args_info->update_flag);
            break;
          }
          
          /* update: Don't use a message digest cache.  */
          else if (strcmp (long_options[option_index].name, "no-cache") == 0)
          {
            if (args_info->no_cache_given)
              {
                fprintf (stderr, "%s: `--no-cache' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->no_cache_given = 1;
            args_info->no_cache_flag = !(args_info->no_cache_flag);
            break;
          }
          
          /* update: Don't pruge obsolete entries from cache after update run.  */
          else if (strcmp (long_options[option_index].name, "no-purge") == 0)
          {
            if (args_info->no_purge_given)
              {
                fprintf (stderr, "%s: `--no-purge' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->no_purge_given = 1;
            args_info->no_purge_flag = !(args_info->no_purge_flag);
            break;
          }
          
          /* update: Use read only cache.  */
          else if (strcmp (long_options[option_index].name, "ro-cache") == 0)
          {
            if (args_info->ro_cache_given)
              {
                fprintf (stderr, "%s: `--ro-cache' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ro_cache_given = 1;
            args_info->ro_cache_flag = !(args_info->ro_cache_flag);
            break;
          }
          
          /* update: Honour stat() st_dev field.  */
          else if (strcmp (long_options[option_index].name, "check-dev") == 0)
          {
            if (args_info->check_dev_given)
              {
                fprintf (stderr, "%s: `--check-dev' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->check_dev_given = 1;
            args_info->check_dev_flag = !(args_info->check_dev_flag);
            break;
          }
          
          /* Show difference between two repositories or snapshots.  */
          else if (strcmp (long_options[option_index].name, "diff") == 0)
          {
            if (args_info->diff_given)
              {
                fprintf (stderr, "%s: `--diff' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->diff_given = 1;
            args_info->diff_flag = !(args_info->diff_flag);
            break;
          }
          
          /* Merge a snapshot or a repository into a repository.  */
          else if (strcmp (long_options[option_index].name, "merge") == 0)
          {
            if (args_info->merge_given)
              {
                fprintf (stderr, "%s: `--merge' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->merge_given = 1;
            args_info->merge_flag = !(args_info->merge_flag);
            break;
          }
          
          /* merge: Don't empty trash.  */
          else if (strcmp (long_options[option_index].name, "keep-trash") == 0)
          {
            if (args_info->keep_trash_given)
              {
                fprintf (stderr, "%s: `--keep-trash' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->keep_trash_given = 1;
            args_info->keep_trash_flag = !(args_info->keep_trash_flag);
            break;
          }
          
          /* merge: Check message digest of file before deleting or replacing.  */
          else if (strcmp (long_options[option_index].name, "check-md") == 0)
          {
            if (args_info->check_md_given)
              {
                fprintf (stderr, "%s: `--check-md' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->check_md_given = 1;
            args_info->check_md_flag = !(args_info->check_md_flag);
            break;
          }
          
          /* merge: Always copy instead of hard linking.  */
          else if (strcmp (long_options[option_index].name, "always-copy") == 0)
          {
            if (args_info->always_copy_given)
              {
                fprintf (stderr, "%s: `--always-copy' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->always_copy_given = 1;
            args_info->always_copy_flag = !(args_info->always_copy_flag);
            break;
          }
          
          /* merge: Always replace existing files.  */
          else if (strcmp (long_options[option_index].name, "always-replace") == 0)
          {
            if (args_info->always_replace_given)
              {
                fprintf (stderr, "%s: `--always-replace' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->always_replace_given = 1;
            args_info->always_replace_flag = !(args_info->always_replace_flag);
            break;
          }
          
          /* Make a patch against the specified repository.  */
          else if (strcmp (long_options[option_index].name, "makepatch") == 0)
          {
            if (args_info->makepatch_given)
              {
                fprintf (stderr, "%s: `--makepatch' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->makepatch_given = 1;
            args_info->makepatch_flag = !(args_info->makepatch_flag);
            break;
          }
          
          /* makepatch: Include files in patch which do exist on the other side under a different name.  */
          else if (strcmp (long_options[option_index].name, "include-all") == 0)
          {
            if (args_info->include_all_given)
              {
                fprintf (stderr, "%s: `--include-all' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->include_all_given = 1;
            args_info->include_all_flag = !(args_info->include_all_flag);
            break;
          }
          
          /* Extract the context of a snapshot or patch.  */
          else if (strcmp (long_options[option_index].name, "extract") == 0)
          {
            if (args_info->extract_given)
              {
                fprintf (stderr, "%s: `--extract' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->extract_given = 1;
            args_info->extract_flag = !(args_info->extract_flag);
            break;
          }
          
          /* Remove syrep info from repository.  */
          else if (strcmp (long_options[option_index].name, "cleanup") == 0)
          {
            if (args_info->cleanup_given)
              {
                fprintf (stderr, "%s: `--cleanup' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->cleanup_given = 1;
            args_info->cleanup_flag = !(args_info->cleanup_flag);
            break;
          }
          
          /* Forget old snapshot entries.  */
          else if (strcmp (long_options[option_index].name, "forget") == 0)
          {
            if (args_info->forget_given)
              {
                fprintf (stderr, "%s: `--forget' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->forget_given = 1;
            args_info->forget_flag = !(args_info->forget_flag);
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    exit (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;
}
