/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2004 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: teacher_maxperday.c,v 1.2 2004/10/17 09:37:05 avian Exp $ */

/* 
 * AUTHOR:
 *  
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight if a teacher has more than the set number of non-free periods
 *  per day.
 *
 * DEFINED SUBJECT RESTRICTIONS:
 *
 *  <restriction type="teacher-maxperday">X</restriction>
 *
 *  Specify the maximum number of non-free periods for the teacher that is
 *  teaching this subject. 
 *
 * DEFINED OPTIONS:
 *
 *  <option name="teacher-maxperday">X</option>
 *
 *  Specify the maximum number of non-free periods for all teachers. The
 *  maximum defined with the subject restriction overrides this setting. If
 *  this option is not defined and a maximum for a certain teacher wasn't 
 *  defined with a subject restriction, that means that there is no restriction
 *  for that teacher.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "data.h"
#include "gettext.h"
#include "modsup.h"

int *perday;

int init_mod()
{
	int c;

	perday=malloc(sizeof(*perday)*tmapnum);

	for(c=0;c<tmapnum;c++) perday[c]=-1;

	return(0);
}

int option_max(char *type, char *cont, int id)
{
	int p,c;
	
	c=sscanf(cont, "%d", &p);

	if(c<1||p<=0||p>periods) {
		strcpy(moderror, _("invalid number of periods"));
		return(1);
	}

	for(c=0;c<tmapnum;c++) {
		perday[c]=p;
	}

	return 0;
}

int subject_max(char *type, char *cont, int sid)
{
	int p,c,tid;
	
	c=sscanf(cont, "%d", &p);

	if(c<1||p<=0||p>periods) {
		strcpy(moderror, _("invalid number of periods"));
		return(1);
	}

	tid=smap[sid].tid;
	perday[tid]=p;

	return 0;
}

parop options[] = { 
	{ type : "teacher-maxperday", parfunc: option_max },
	{ type : 0, parfunc: 0 }
};

parop subject_restrictions[] = { 
	{ type : "teacher-maxperday", parfunc: subject_max },
	{ type : 0, parfunc: 0 }
};

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int day,b,tid,per;
	int sum;

	sum=0;
	for(tid=0;tid<tmapnum;tid++) {
		if(perday[tid]>0) {
			for(day=0;day<DAYS;day++) {
				b=0;
				for(per=0;per<PERIODS;per++) {
					if((*tpnt)>-1) b++;
					tpnt++;
				}
				if(b>perday[tid]) sum++;
			}
		} else {
			tpnt+=TIMES;
		}
	}

	return(sum);
}
