/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CONTACT_LIST_H
#define QTTAPIOCA_CONTACT_LIST_H

#include <QtCore/QList>
#include <QtCore/QObject>
#include <QtCore/QString>

#include <QtTelepathy/Client/Connection>
#include <QtTelepathy/Client/ConnectionAvatarsInterface>
#include <QtTelepathy/Client/ConnectionPresenceInterface>
#include <QtTelepathy/Client/ConnectionAliasingInterface>
#include <QtTelepathy/Client/ConnectionCapabilitiesInterface>

/** Namespace for Tapioca classes. */
namespace QtTapioca {

class ContactListPrivate;
class Contact;
class Handle;
class HandleFactory;

/**
 * This class is holds all known contacts. New contacts are also created here.
 */
class ContactList: public QObject {
    Q_OBJECT
    Q_DECLARE_PRIVATE(ContactList)

public:
    /** Destructor */
    ~ContactList();

    /**
     * Adds a new contact to the list.
     *
     * @param uri Contact's uri. e.g. "foo@jabber.org"
     * @return The specified contact.
     */
    Contact *addContact(const QString &uri);

    /**
     * Removes a contact from the list.
     *
     * @param contact The contact to be removed.
     */
    void removeContact(Contact *contact);

    Contact *contact(const QString &uri) const;

    QList<Contact *> knownContacts() const;
    QList<Contact *> subscribedContacts() const;
    QList<Contact *> authorizedContacts() const;
    QList<Contact *> blockedContacts() const;
    QList<Contact *> hiddenContacts() const;

    /**
     * Whether it's stored on server (FIXME)
     * @return true or false
     */
    bool isStoredOnServer() const;

Q_SIGNALS:
    void authorizationRequested(QtTapioca::Contact *contact);
    void subscriptionAccepted(QtTapioca::Contact *contact);

private Q_SLOTS:
    void onMembersChangedSubscribe(const QString &, const QList<uint> &, const QList<uint> &, const QList<uint> &, const QList<uint> &, uint, uint);
    void onMembersChangedPublish(const QString &, const QList<uint> &, const QList<uint> &, const QList<uint> &, const QList<uint> &, uint, uint);

private:
    friend class Connection;

    ContactList(org::freedesktop::Telepathy::Connection *telepathyConn,
                org::freedesktop::Telepathy::ConnectionAvatarsInterface *iAvatar,
                org::freedesktop::Telepathy::ConnectionPresenceInterface *iPresence,
                org::freedesktop::Telepathy::ConnectionAliasingInterface *iAliasing,
                org::freedesktop::Telepathy::ConnectionCapabilitiesInterface *iCapabilities,
                HandleFactory *handleFactory,
                QObject *parent = 0);

    void loadContacts();
    Contact *contact(Handle *handle) const;

    ContactListPrivate *d;
};

} // namespace

#endif

