/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "config.h"

#include "QtTapioca/Avatar"

#include <QtCore/QDebug>
#include <QtCore/QFile>

namespace QtTapioca {

class AvatarPrivate {
public:
    AvatarPrivate(const QByteArray &_data, const QString &_mime, const QString &_token)
        : data(_data),
          mime(_mime),
          token(_token)
    {
    }
    ~AvatarPrivate()
    {
    }

    QByteArray data;
    QString mime;
    QString token;
};

};

using namespace QtTapioca;

Avatar::Avatar(const QString &path, QObject *parent)
    : QObject(parent)
{
    QFile file(path);
    QByteArray data;

    if (file.exists()) {
        if (file.open(QIODevice::ReadOnly))
            data = file.readAll();
    }

    // check how to discovery the mime type.
    d = new AvatarPrivate(data, "", "");
}

Avatar::Avatar(const QByteArray &data, QObject *parent)
    : QObject(parent),
      d(new AvatarPrivate(data, "", ""))
{
}

Avatar::Avatar(const QByteArray &data, const QString &mimeType, const QString &token, QObject *parent)
    : QObject(parent),
      d(new AvatarPrivate(data, mimeType, token))
{
}

Avatar::~Avatar()
{
    delete d;
}

QByteArray Avatar::data() const
{
    return d->data;
}

QString Avatar::mimeType() const
{
    return d->mime;
}

QString Avatar::token() const
{
    return d->token;
}

void Avatar::setData(const QByteArray &_data)
{
    d->data = _data;
}

void Avatar::setMimeType(const QString &mime)
{
    d->mime = mime;
}

void Avatar::setToken(const QString &_token)
{
    d->token = _token;
}

