/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "config.h"

#include "QtTapioca/DBusProxyObject"

namespace QtTapioca {

class DBusProxyObjectPrivate {
public:
    DBusProxyObjectPrivate(const QString _serviceName,
                           const QString objPath)
        : serviceName(_serviceName),
          objectPath(objPath)
    {
    }
    ~DBusProxyObjectPrivate()
    {
    }

    QString serviceName;
    QString objectPath;
};

};

using namespace QtTapioca;

DBusProxyObject::DBusProxyObject(const QString &serviceName, const QString &objPath, QObject *parent)
    : QObject(parent),
      d(new DBusProxyObjectPrivate(serviceName, objPath))
{
}

DBusProxyObject::~DBusProxyObject()
{
    delete d;
}

QString DBusProxyObject::serviceName() const
{
    return d->serviceName;
}

QString DBusProxyObject::objectPath() const
{
    return d->objectPath;
}
