/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2001, 2002, 2004 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate file inputs
 */

#include <ac/errno.h>
#include <ac/stdarg.h>
#include <ac/stdio.h>

#include <error.h>
#include <file/input.h>


file_input::~file_input()
{
	/* nothing to do */
}


file_input::file_input()
{
	/* nothing to do */
}


file_input::file_input(const file_input &)
{
	fatal("%s: %d: copy constructor is private (bug)",
		__FILE__, __LINE__);
}


file_input &
file_input::operator = (const file_input &)
{
	fatal("%s: %d: assignment operator is private (bug)",
		__FILE__, __LINE__);
	return *this;
}


void
file_input::fatal(const char *fmt, ...)
	const
{
	va_list ap;
	va_start(ap, fmt);
	char buffer[2000];
	vsnprintf(buffer, sizeof(buffer), fmt, ap);
	va_end(ap);
	const char *s = filename();
	::fatal("%s: %s", s, buffer);
}


void
file_input::nfatal(const char *fmt, ...)
	const
{
	int err = errno;
	va_list ap;
	char buffer[2000];
	va_start(ap, fmt);
	vsnprintf(buffer, sizeof(buffer), fmt, ap);
	va_end(ap);
	const char *s = filename();
	errno = err;
	::nfatal("%s: %s", s, buffer);
}
