/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.Iterator;

public class CallPathUtilFuncs {
    private CallPathUtilFuncs() {
    }

    public static boolean checkCallPathsPresent(Iterator iterator) {
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!function.isCallPathFunction()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDoublePath(String string) {
        int n = string.indexOf("=>");
        return n != -1 && (string = string.substring(n + 2)).indexOf("=>") != -1;
    }

    public static void buildThreadRelations(DataSource dataSource, Thread thread) {
        if (thread.relationsBuilt()) {
            return;
        }
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        Iterator iterator = thread.getFunctionProfileIterator();
        while (iterator.hasNext()) {
            String string;
            int n;
            FunctionProfile functionProfile = (FunctionProfile)iterator.next();
            if (functionProfile == null || !functionProfile.isCallPathFunction() || functionProfile.getFunction().isGroupMember(group) || (n = (string = functionProfile.getName()).lastIndexOf("=>")) <= 0) continue;
            String string2 = string.substring(n + 2, string.length());
            string = string.substring(0, n);
            n = string.lastIndexOf("=>");
            String string3 = null;
            string3 = n > 0 ? string.substring(n + 2) : string;
            Function function = dataSource.getFunction(string3);
            Function function2 = dataSource.getFunction(string2);
            if (function == null || function2 == null) {
                System.err.println("Warning: Callpath data not complete: " + string3 + " => " + string2);
                continue;
            }
            FunctionProfile functionProfile2 = thread.getFunctionProfile(dataSource.getFunction(string3));
            FunctionProfile functionProfile3 = thread.getFunctionProfile(dataSource.getFunction(string2));
            if (functionProfile2 == null || functionProfile3 == null) {
                System.err.println("Warning: Callpath data not complete: " + string3 + " => " + string2);
                continue;
            }
            if (functionProfile2 != null) {
                functionProfile2.addChildProfile(functionProfile3, functionProfile);
            }
            if (functionProfile3 == null) continue;
            functionProfile3.addParentProfile(functionProfile2, functionProfile);
        }
    }
}

