/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.analysis;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.analysis.DistanceMatrix;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class ClusterAnalysis {
    protected DB db = null;
    protected DistanceMatrix results = null;
    protected Trial trial = null;
    protected Metric metric = null;

    public ClusterAnalysis(DatabaseAPI databaseAPI, Trial trial, Metric metric) {
        this.db = databaseAPI.db();
        this.trial = trial;
        this.metric = metric;
    }

    private void getRawData() {
        int n = Integer.parseInt(this.trial.getField("node_count")) * Integer.parseInt(this.trial.getField("contexts_per_node")) * Integer.parseInt(this.trial.getField("threads_per_context"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select count(id) from interval_event where trial = ");
        stringBuffer.append(this.trial.getID());
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.db.getDataItem(stringBuffer.toString()));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.out.println(n + " " + n2);
        this.results = this.createTheMatrix(n, n2);
        stringBuffer = new StringBuffer();
        stringBuffer.append("select name from interval_event where trial = ? order by id");
        try {
            PreparedStatement preparedStatement = this.db.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.trial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            while (resultSet.next()) {
                this.results.eventName[n3++] = resultSet.getString(1);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("select l.node, l.context, l.thread, sum(l.exclusive) ");
        stringBuffer.append("from interval_location_profile l ");
        stringBuffer.append("inner join interval_event e ");
        stringBuffer.append("on l.interval_event = e.id ");
        stringBuffer.append("where e.trial = ? and l.metric = ? ");
        stringBuffer.append("group by l.node, l.context, l.thread ");
        stringBuffer.append("order by l.node, l.context, l.thread ");
        this.getTotals();
        this.getMatrixData();
    }

    protected abstract void getTotals();

    protected abstract void getMatrixData();

    protected abstract DistanceMatrix createTheMatrix(int var1, int var2);

    public double[][] getManhattanDistance() {
        if (this.results == null) {
            this.getRawData();
        }
        this.results.getManhattanDistance();
        return this.results.distanceMatrix;
    }

    public double[][] getEuclideanDistance() {
        if (this.results == null) {
            this.getRawData();
        }
        this.results.getEuclideanDistance();
        return this.results.distanceMatrix;
    }

    public String toString() {
        return this.results == null ? new String("") : this.results.toString();
    }

    public int[] toImage(boolean bl, boolean bl2) {
        if (this.results == null) {
            return new int[0];
        }
        return this.results.toImage(bl, bl2);
    }
}

