/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.analysis;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.analysis.DistanceAnalysis;
import edu.uoregon.tau.perfdmf.analysis.DistanceMatrix;
import edu.uoregon.tau.perfdmf.analysis.EventMatrix;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class EventDistance
extends DistanceAnalysis {
    public EventDistance(DatabaseAPI databaseAPI, Trial trial, Metric metric) {
        super(databaseAPI, trial, metric);
    }

    protected void getTotals() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select e.id, sum(l.exclusive) ");
        stringBuffer.append("from interval_event e ");
        stringBuffer.append("inner join interval_location_profile l ");
        stringBuffer.append("on e.id = l.interval_event ");
        stringBuffer.append("where e.trial = ? and l.metric = ? ");
        stringBuffer.append("group by e.id ");
        stringBuffer.append("order by e.id ");
        try {
            PreparedStatement preparedStatement = this.db.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.trial.getID());
            preparedStatement.setInt(2, this.metric.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                this.results.total[n++] = resultSet.getDouble(2);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
    }

    protected void getMatrixData() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.parseInt(this.trial.getField("threads_per_context"));
        int n2 = n * Integer.parseInt(this.trial.getField("contexts_per_node"));
        stringBuffer.append("select (l.node * ");
        stringBuffer.append(n2);
        stringBuffer.append(") + (l.context * ");
        stringBuffer.append(n);
        stringBuffer.append(") + l.thread as idx, e.id, ");
        stringBuffer.append("COALESCE(l.exclusive, 0.0) from interval_event e ");
        stringBuffer.append("left outer join interval_location_profile l ");
        stringBuffer.append("on e.id = l.interval_event ");
        stringBuffer.append("where e.trial = ? and l.metric = ? ");
        stringBuffer.append("order by e.id, idx ");
        try {
            PreparedStatement preparedStatement = this.db.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.trial.getID());
            preparedStatement.setInt(2, this.metric.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (resultSet.next()) {
                n4 = resultSet.getInt(1);
                n5 = resultSet.getInt(2);
                this.results.dataMatrix[n3][n4] = this.results.total[n3] == 0.0 ? 0.0 : resultSet.getDouble(3) / this.results.total[n3];
            }
            while (resultSet.next()) {
                n4 = resultSet.getInt(1);
                if (n5 != resultSet.getInt(2)) {
                    ++n3;
                    n5 = resultSet.getInt(2);
                }
                if (this.results.total[n3] == 0.0) {
                    this.results.dataMatrix[n3][n4] = 0.0;
                    continue;
                }
                this.results.dataMatrix[n3][n4] = resultSet.getDouble(3) / this.results.total[n3];
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
    }

    public int getThreadCount() {
        return this.results == null ? 0 : this.results.matrixSize;
    }

    public int getEventCount() {
        return this.results == null ? 0 : this.results.dimensionCount;
    }

    protected DistanceMatrix createTheMatrix(int n, int n2) {
        return new EventMatrix(n, n2);
    }
}

