/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;

public class DefaultGraphSelectionModel
implements GraphSelectionModel,
Cloneable,
Serializable {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    public static final int SELECTED = -1;
    public static final Integer UNSELECTED = new Integer(0);
    protected JGraph graph;
    protected SwingPropertyChangeSupport changeSupport;
    protected EventListenerList listenerList = new EventListenerList();
    protected int selectionMode;
    protected boolean childrenSelectable = true;
    protected Map cellStates = new Hashtable();
    protected List selection = new ArrayList();
    static /* synthetic */ Class class$org$jgraph$event$GraphSelectionListener;

    public DefaultGraphSelectionModel(JGraph jGraph) {
        this.graph = jGraph;
    }

    public void setSelectionMode(int n) {
        int n2 = this.selectionMode;
        this.selectionMode = n;
        if (this.selectionMode != 4 && this.selectionMode != 1) {
            this.selectionMode = 4;
        }
        if (n2 != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(n2), new Integer(this.selectionMode));
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setChildrenSelectable(boolean bl) {
        this.childrenSelectable = bl;
    }

    public boolean isChildrenSelectable() {
        return this.childrenSelectable;
    }

    protected boolean isChildrenSelectable(Object object) {
        return this.childrenSelectable;
    }

    public void setSelectionCell(Object object) {
        if (object == null) {
            this.setSelectionCells(null);
        } else {
            this.setSelectionCells(new Object[]{object});
        }
    }

    public void setSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            Object object;
            if (this.selectionMode == 1 && objectArray.length > 0) {
                objectArray = new Object[]{objectArray[objectArray.length - 1]};
            }
            this.cellStates.clear();
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                this.selection.remove(objectArray[i]);
                vector.addElement(new CellPlaceHolder(objectArray[i], !this.selection.remove(objectArray[i])));
                this.select(arrayList, objectArray[i]);
                object = this.graph.getModel().getParent(objectArray[i]);
                if (object == null) continue;
                vector.addElement(new CellPlaceHolder(object, false));
            }
            Iterator iterator = this.selection.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                while (object != null) {
                    vector.addElement(new CellPlaceHolder(object, false));
                    object = this.graph.getModel().getParent(object);
                }
            }
            this.selection = arrayList;
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    public void addSelectionCell(Object object) {
        if (object != null) {
            this.addSelectionCells(new Object[]{object});
        }
    }

    public void addSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            if (this.selectionMode == 1) {
                this.setSelectionCells(objectArray);
            } else {
                Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
                for (int i = 0; i < objectArray.length; ++i) {
                    boolean bl;
                    if (objectArray[i] == null || !(bl = this.select(this.selection, objectArray[i]))) continue;
                    vector.addElement(new CellPlaceHolder(objectArray[i], true));
                    Object object = this.graph.getModel().getParent(objectArray[i]);
                    if (object == null) continue;
                    vector.addElement(new CellPlaceHolder(object, false));
                }
                if (vector.size() > 0) {
                    this.notifyCellChange(vector);
                }
            }
        }
    }

    public void removeSelectionCell(Object object) {
        if (object != null) {
            this.removeSelectionCells(new Object[]{object});
        }
    }

    public void removeSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl;
                if (objectArray[i] == null || !(bl = this.deselect(objectArray[i]))) continue;
                vector.addElement(new CellPlaceHolder(objectArray[i], false));
                Object object = this.graph.getModel().getParent(objectArray[i]);
                if (object == null) continue;
                vector.addElement(new CellPlaceHolder(object, false));
            }
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    public Object[] getSelectables() {
        if (this.isChildrenSelectable()) {
            ArrayList arrayList = new ArrayList();
            Stack<Object> stack = new Stack<Object>();
            GraphModel graphModel = this.graph.getModel();
            for (int i = 0; i < graphModel.getRootCount(); ++i) {
                stack.add(graphModel.getRootAt(i));
            }
            while (!stack.isEmpty()) {
                Object e = stack.pop();
                if (!graphModel.isPort(e)) {
                    arrayList.add(e);
                }
                if (!this.isChildrenSelectable(e)) continue;
                for (int i = 0; i < graphModel.getChildCount(e); ++i) {
                    stack.add(graphModel.getChild(e, i));
                }
            }
            return arrayList.toArray();
        }
        return this.graph.getRoots();
    }

    public Object getSelectionCell() {
        if (this.selection != null && this.selection.size() > 0) {
            return this.selection.toArray()[0];
        }
        return null;
    }

    public Object[] getSelectionCells() {
        if (this.selection != null) {
            return this.selection.toArray();
        }
        return null;
    }

    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.size();
    }

    public boolean isCellSelected(Object object) {
        int n = this.getSelectedChildCount(object);
        return n == -1;
    }

    public boolean isChildrenSelected(Object object) {
        int n = this.getSelectedChildCount(object);
        return n > 0;
    }

    public boolean isSelectionEmpty() {
        return this.selection.isEmpty();
    }

    public void clearSelection() {
        if (this.selection != null) {
            Vector<CellPlaceHolder> vector = new Vector<CellPlaceHolder>();
            Iterator iterator = this.cellStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object object = entry.getKey();
                while (object != null) {
                    vector.addElement(new CellPlaceHolder(object, false));
                    object = this.graph.getModel().getParent(object);
                }
            }
            this.selection.clear();
            this.cellStates.clear();
            if (vector.size() > 0) {
                this.notifyCellChange(vector);
            }
        }
    }

    protected int getSelectedChildCount(Object object) {
        if (object != null) {
            Integer n = (Integer)this.cellStates.get(object);
            if (n == null) {
                n = UNSELECTED;
                this.cellStates.put(object, n);
            }
            return n;
        }
        return 0;
    }

    protected void setSelectedChildCount(Object object, int n) {
        Integer n2 = new Integer(n);
        this.cellStates.put(object, n2);
    }

    protected boolean select(List list, Object object) {
        if (!this.isCellSelected(object) && this.graph.getGraphLayoutCache().isVisible(object)) {
            GraphModel graphModel = this.graph.getModel();
            Object object2 = graphModel.getParent(object);
            while (object2 != null) {
                int n = this.getSelectedChildCount(object2);
                if (n == -1) {
                    n = 0;
                }
                this.setSelectedChildCount(object2, ++n);
                this.selection.remove(object2);
                object2 = graphModel.getParent(object2);
            }
            Object[] objectArray = new Object[]{object};
            List list2 = DefaultGraphModel.getDescendants(graphModel, objectArray);
            list2.remove(object);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null || graphModel.isPort(e)) continue;
                this.selection.remove(e);
                this.cellStates.remove(e);
            }
            this.setSelectedChildCount(object, -1);
            return list.add(object);
        }
        return false;
    }

    protected boolean deselect(Object object) {
        if (this.isCellSelected(object)) {
            Object object2 = this.graph.getModel().getParent(object);
            boolean bl = true;
            int n = -1;
            while (object2 != null && n != 0) {
                int n2 = this.getSelectedChildCount(object2);
                if ((n2 += n) == 0 && bl) {
                    n = 0;
                    n2 = -1;
                    this.selection.add(object2);
                }
                this.setSelectedChildCount(object2, n2);
                object2 = this.graph.getModel().getParent(object2);
                bl = false;
            }
            this.cellStates.remove(object);
            return this.selection.remove(object);
        }
        return false;
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.add(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = DefaultGraphSelectionModel.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener, graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = DefaultGraphSelectionModel.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener, graphSelectionListener);
    }

    protected void fireValueChanged(GraphSelectionEvent graphSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jgraph$event$GraphSelectionListener == null ? DefaultGraphSelectionModel.class$("org.jgraph.event.GraphSelectionListener") : class$org$jgraph$event$GraphSelectionListener)) continue;
            ((GraphSelectionListener)objectArray[i + 1]).valueChanged(graphSelectionEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void notifyCellChange(Vector vector) {
        int n = vector.size();
        boolean[] blArray = new boolean[n];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            CellPlaceHolder cellPlaceHolder = (CellPlaceHolder)vector.elementAt(i);
            blArray[i] = cellPlaceHolder.isNew;
            objectArray[i] = cellPlaceHolder.cell;
        }
        GraphSelectionEvent graphSelectionEvent = new GraphSelectionEvent(this, objectArray, blArray);
        this.fireValueChanged(graphSelectionEvent);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultGraphSelectionModel defaultGraphSelectionModel = (DefaultGraphSelectionModel)super.clone();
        defaultGraphSelectionModel.changeSupport = null;
        if (this.selection != null) {
            defaultGraphSelectionModel.selection = new ArrayList(this.selection);
        }
        defaultGraphSelectionModel.listenerList = new EventListenerList();
        return defaultGraphSelectionModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class CellPlaceHolder {
        protected boolean isNew;
        protected Object cell;

        protected CellPlaceHolder(Object object, boolean bl) {
            this.cell = object;
            this.isNew = bl;
        }

        public Object getCell() {
            return this.cell;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setCell(Object object) {
            this.cell = object;
        }

        public void setNew(boolean bl) {
            this.isNew = bl;
        }
    }
}

