/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.barchart.BarChartModel;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.UserEventBarChartModel;
import edu.uoregon.tau.paraprof.barchart.UserEventThreadBarChartModel;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;

public class UserEventWindow
extends JFrame
implements ActionListener,
Observer,
ChangeListener,
ParaProfWindow {
    private ParaProfTrial ppTrial;
    private DataSorter dataSorter;
    private UserEvent userEvent;
    private Thread thread;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem descendingOrder;
    private JCheckBoxMenuItem sortByNCT;
    private JCheckBoxMenuItem sortByName;
    private JCheckBoxMenuItem showMetaData;
    private JCheckBoxMenuItem displayWidthSlider;
    private JLabel barLengthLabel = new JLabel("Bar Width");
    private JSlider barLengthSlider = new JSlider(0, 2000, 400);
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private BarChartPanel panel;
    private BarChartModel model;
    private List list = new ArrayList();
    private UserEventValueType userEventValueType = UserEventValueType.NUMSAMPLES;

    public UserEventWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.thread = thread;
        this.ppTrial = paraProfTrial;
        paraProfTrial.addObserver(this);
        this.dataSorter = new DataSorter(paraProfTrial);
        int n = 750;
        int n2 = 650;
        this.setSize(ParaProfUtils.checkSize(new Dimension(n, n2)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setTitle("User Event Window: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UserEventWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.model = new UserEventThreadBarChartModel(this, this.dataSorter, thread);
        this.panel = new BarChartPanel(this.model, null);
        this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
        this.setupMenus();
        this.gbl = new GridBagLayout();
        this.getContentPane().setLayout(this.gbl);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.setHeader();
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(400);
        this.barLengthSlider.setMinorTickSpacing(50);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(false);
        this.barLengthSlider.addChangeListener(this);
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 0.95;
        this.gbc.weighty = 0.98;
        this.addCompItem(this.panel, this.gbc, 0, 1, 2, 1);
        this.sortLocalData();
        ParaProf.incrementNumWindows();
    }

    public UserEventWindow(ParaProfTrial paraProfTrial, UserEvent userEvent, Component component) {
        this.userEvent = userEvent;
        this.ppTrial = paraProfTrial;
        paraProfTrial.addObserver(this);
        this.dataSorter = new DataSorter(paraProfTrial);
        int n = 650;
        int n2 = 550;
        this.setSize(ParaProfUtils.checkSize(new Dimension(n, n2)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setTitle("User Event Window: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UserEventWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.model = new UserEventBarChartModel(this, this.dataSorter, userEvent);
        this.panel = new BarChartPanel(this.model, null);
        this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
        this.setupMenus();
        this.gbl = new GridBagLayout();
        this.getContentPane().setLayout(this.gbl);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.setHeader();
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(400);
        this.barLengthSlider.setMinorTickSpacing(50);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(false);
        this.barLengthSlider.addChangeListener(this);
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 0.95;
        this.gbc.weighty = 0.98;
        this.addCompItem(this.panel, this.gbc, 0, 1, 2, 1);
        this.sortLocalData();
        ParaProf.incrementNumWindows();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        this.optionsMenu = new JMenu("Options");
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.displayWidthSlider = new JCheckBoxMenuItem("Show Width Slider", false);
        this.displayWidthSlider.addActionListener(this);
        this.optionsMenu.add(this.displayWidthSlider);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.add(new JSeparator());
        this.descendingOrder = new JCheckBoxMenuItem("Descending Order", true);
        this.descendingOrder.addActionListener(this);
        this.optionsMenu.add(this.descendingOrder);
        if (this.thread == null) {
            this.sortByNCT = new JCheckBoxMenuItem("Sort By N,C,T", false);
            this.sortByNCT.addActionListener(this);
            this.optionsMenu.add(this.sortByNCT);
        } else {
            this.sortByName = new JCheckBoxMenuItem("Sort By Name", false);
            this.sortByName.addActionListener(this);
            this.optionsMenu.add(this.sortByName);
        }
        jMenu = new JMenu("Select Value Type");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Samples", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Min. Value", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Max. Value", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Mean Value", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Standard Deviation", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Number of Samples")) {
                    this.userEventValueType = UserEventValueType.NUMSAMPLES;
                    this.sortLocalData();
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Min. Value")) {
                    this.userEventValueType = UserEventValueType.MIN;
                    this.sortLocalData();
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Max. Value")) {
                    this.userEventValueType = UserEventValueType.MAX;
                    this.sortLocalData();
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Mean Value")) {
                    this.userEventValueType = UserEventValueType.MEAN;
                    this.sortLocalData();
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Standard Deviation")) {
                    this.userEventValueType = UserEventValueType.STDDEV;
                    this.sortLocalData();
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Descending Order")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Sort By N,C,T")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Sort By Name")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Show Width Slider")) {
                    if (this.displayWidthSlider.isSelected()) {
                        this.displaySiders(true);
                    } else {
                        this.displaySiders(false);
                    }
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.getBarChart().setBarLength(this.barLengthSlider.getValue());
            this.panel.repaint();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the userevent data window for:");
        ParaProf.helpWindow.writeText(this.userEvent.getName());
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you this userevent's statistics across all the threads.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
        ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
        ParaProf.helpWindow.writeText("for this userevent.");
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    public void sortLocalData() {
        this.dataSorter.setDescendingOrder(this.descendingOrder.isSelected());
        if (this.sortByNCT != null && this.sortByNCT.isSelected()) {
            this.dataSorter.setSortType(SortType.NCT);
        } else {
            this.dataSorter.setSortType(SortType.VALUE);
        }
        if (this.sortByName != null && this.sortByName.isSelected()) {
            this.dataSorter.setSortType(SortType.NAME);
        }
        this.dataSorter.setUserEventValueType(this.userEventValueType);
        this.model.reloadData();
    }

    public List getData() {
        return this.list;
    }

    public UserEventValueType getValueType() {
        return this.userEventValueType;
    }

    public Dimension getViewportSize() {
        return this.panel.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.panel.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.panel.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setMargin(new Insets(3, 3, 3, 3));
            jTextArea.setEditable(false);
            jTextArea.append(this.getHeaderString());
            this.panel.setColumnHeaderView(jTextArea);
        } else {
            this.panel.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.userEvent != null) {
            return "Name: " + this.userEvent.getName() + "\n" + "Value Type: " + this.userEventValueType.toString() + "\n";
        }
        return "Thread: " + ParaProfUtils.getThreadIdentifier(this.thread) + "\n" + "Value Type: " + this.userEventValueType.toString() + "\n";
    }

    private void displaySiders(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, gridBagConstraints, 1, 0, 1, 1);
        } else {
            this.getContentPane().remove(this.barLengthLabel);
            this.getContentPane().remove(this.barLengthSlider);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            this.setVisible(false);
            this.ppTrial.deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public ParaProfTrial getPpTrial() {
        return this.ppTrial;
    }
}

