/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.paraprof.barchart.LegendModel;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;

public class ComparisonBarChartModel
extends AbstractBarChartModel {
    private List ppTrials = new ArrayList();
    private List threads = new ArrayList();
    private Map rowMap = new HashMap();
    private List rows = new ArrayList();
    private DataSorter dataSorter;
    private FunctionBarChartWindow window;
    private LegendModel legendModel;

    public ComparisonBarChartModel(FunctionBarChartWindow functionBarChartWindow, ParaProfTrial paraProfTrial, Thread thread, DataSorter dataSorter) {
        this.window = functionBarChartWindow;
        this.dataSorter = dataSorter;
        this.addThread(paraProfTrial, thread);
    }

    public LegendModel getLegendModel() {
        if (this.legendModel == null) {
            this.legendModel = new LegendModel(){

                public int getNumElements() {
                    return ComparisonBarChartModel.this.ppTrials.size();
                }

                public String getLabel(int n) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)ComparisonBarChartModel.this.ppTrials.get(n);
                    Thread thread = (Thread)ComparisonBarChartModel.this.threads.get(n);
                    return paraProfTrial.getName() + " - " + ParaProfUtils.getThreadIdentifier(thread);
                }

                public Color getColor(int n) {
                    return ComparisonBarChartModel.this.getValueColor(0, n);
                }
            };
        }
        return this.legendModel;
    }

    public void addThread(ParaProfTrial paraProfTrial, Thread thread) {
        this.ppTrials.add(paraProfTrial);
        this.threads.add(thread);
    }

    public void reloadData() {
        RowBlob rowBlob;
        Object object;
        this.rows.clear();
        this.rowMap.clear();
        ParaProfTrial paraProfTrial = (ParaProfTrial)this.ppTrials.get(0);
        Thread thread = (Thread)this.threads.get(0);
        this.dataSorter.setPpTrial(paraProfTrial);
        List list = this.dataSorter.getFunctionProfiles(thread);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (PPFunctionProfile)iterator.next();
            rowBlob = new RowBlob(((PPFunctionProfile)object).getDisplayName());
            this.rows.add(rowBlob);
            rowBlob.add(object);
            this.rowMap.put(((PPFunctionProfile)object).getDisplayName(), rowBlob);
        }
        for (int i = 1; i < this.ppTrials.size(); ++i) {
            object = (ParaProfTrial)this.ppTrials.get(i);
            rowBlob = (Thread)this.threads.get(i);
            this.dataSorter.setPpTrial((ParaProfTrial)object);
            list = this.dataSorter.getFunctionProfiles((Thread)rowBlob);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator2.next();
                if (!((ParaProfTrial)object).displayFunction(pPFunctionProfile.getFunction())) continue;
                RowBlob rowBlob2 = (RowBlob)this.rowMap.get(pPFunctionProfile.getFunction().getName());
                if (rowBlob2 != null) {
                    rowBlob2.add(i, pPFunctionProfile);
                    continue;
                }
                rowBlob2 = new RowBlob(pPFunctionProfile.getDisplayName());
                this.rows.add(rowBlob2);
                this.rowMap.put(pPFunctionProfile.getFunction(), rowBlob2);
                rowBlob2.add(i, pPFunctionProfile);
            }
        }
        this.fireModelChanged();
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public int getSubSize() {
        return this.ppTrials.size();
    }

    public String getLabel(int n) {
        return null;
    }

    public double getValue(int n, int n2) {
        RowBlob rowBlob = (RowBlob)this.rows.get(n);
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)rowBlob.get(n2);
        if (pPFunctionProfile == null) {
            return -1.0;
        }
        return pPFunctionProfile.getValue();
    }

    public String getValueLabel(int n, int n2) {
        double d = this.getValue(n, n2);
        if (this.window.getDataSorter().getValueType() == ValueType.EXCLUSIVE_PERCENT || this.window.getDataSorter().getValueType() == ValueType.INCLUSIVE_PERCENT) {
            return UtilFncs.getOutputString((int)0, (double)d, (int)6) + "%";
        }
        return UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision);
    }

    public String getRowLabel(int n) {
        RowBlob rowBlob = (RowBlob)this.rows.get(n);
        return rowBlob.getFunctionName();
    }

    public Color getValueColor(int n, int n2) {
        Vector vector = ParaProf.colorChooser.getColors();
        return (Color)vector.get(n2 % vector.size());
    }

    public Color getValueHighlightColor(int n, int n2) {
        return null;
    }

    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
    }

    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
    }

    public String getValueToolTipText(int n, int n2) {
        return null;
    }

    public String getRowLabelToolTipText(int n) {
        return null;
    }

    public String getOtherToolTopText(int n) {
        return null;
    }

    public static void main(String[] stringArray) {
        ParaProf paraProf = new ParaProf();
        paraProf.startSystem();
        File[] fileArray = new File[]{new File("/home/amorris/data/packed/lu.C.512.ppk")};
        ParaProfTrial paraProfTrial = ComparisonBarChartModel.loadTrial(fileArray, 7);
        fileArray[0] = new File("/home/amorris/data/packed/lu.A.128.ppk");
        ParaProfTrial paraProfTrial2 = ComparisonBarChartModel.loadTrial(fileArray, 7);
        FunctionBarChartWindow functionBarChartWindow = FunctionBarChartWindow.CreateComparisonWindow(paraProfTrial, paraProfTrial.getDataSource().getMeanData(), null);
        functionBarChartWindow.addThread(paraProfTrial, paraProfTrial.getDataSource().getThread(0, 0, 0));
        functionBarChartWindow.addThread(paraProfTrial, paraProfTrial.getDataSource().getThread(1, 0, 0));
        functionBarChartWindow.addThread(paraProfTrial2, paraProfTrial2.getDataSource().getMeanData());
        functionBarChartWindow.show();
    }

    public static ParaProfTrial loadTrial(File[] fileArray, int n) {
        ParaProfApplication paraProfApplication = ParaProf.applicationManager.addApplication();
        paraProfApplication.setName("New Application");
        ParaProfExperiment paraProfExperiment = paraProfApplication.addExperiment();
        ParaProf.paraProfManagerWindow.addTrial(paraProfApplication, paraProfExperiment, fileArray, n, false, false);
        Vector vector = paraProfExperiment.getTrials();
        ParaProfTrial paraProfTrial = (ParaProfTrial)vector.get(0);
        while (paraProfTrial.loading()) {
            ComparisonBarChartModel.sleep(500);
        }
        return paraProfTrial;
    }

    private static void sleep(int n) {
        try {
            java.lang.Thread.sleep(n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while sleeping");
        }
    }

    public List getThreads() {
        return this.threads;
    }

    public List getPpTrials() {
        return this.ppTrials;
    }

    public void setThreads(List list) {
        this.threads = list;
    }

    private static class RowBlob
    extends ArrayList {
        String functionName;

        public RowBlob(String string) {
            this.functionName = string;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void add(int n, Object object) {
            while (n >= this.size()) {
                this.add(null);
            }
            super.set(n, object);
        }

        public Object get(int n) {
            if (n >= this.size()) {
                return null;
            }
            return super.get(n);
        }
    }
}

