/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.Size2D;
import org.jfree.ui.Spacer;
import org.jfree.util.ObjectUtils;

public class TextBox
implements Serializable {
    private transient Paint outlinePaint = Color.black;
    private transient Stroke outlineStroke = new BasicStroke(1.0f);
    private Spacer interiorGap = new Spacer(1, 3.0, 1.0, 3.0, 1.0);
    private transient Paint backgroundPaint = new Color(255, 255, 192);
    private transient Paint shadowPaint = Color.gray;
    private double shadowXOffset = 2.0;
    private double shadowYOffset = 2.0;
    private TextBlock textBlock;

    public TextBox() {
        this((TextBlock)null);
    }

    public TextBox(String string) {
        this((TextBlock)null);
        if (string != null) {
            this.textBlock = new TextBlock();
            this.textBlock.addLine(string, new Font("SansSerif", 0, 10), Color.black);
        }
    }

    public TextBox(TextBlock textBlock) {
        this.textBlock = textBlock;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    public Spacer getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(Spacer spacer) {
        this.interiorGap = spacer;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double d) {
        this.shadowXOffset = d;
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double d) {
        this.shadowYOffset = d;
    }

    public TextBlock getTextBlock() {
        return this.textBlock;
    }

    public void setTextBlock(TextBlock textBlock) {
        this.textBlock = textBlock;
    }

    public void draw(Graphics2D graphics2D, float f, float f2, RectangleAnchor rectangleAnchor) {
        Size2D size2D = this.textBlock.calculateDimensions(graphics2D);
        double d = this.interiorGap.getAdjustedWidth(size2D.getWidth());
        double d2 = this.interiorGap.getAdjustedHeight(size2D.getHeight());
        Size2D size2D2 = new Size2D(d, d2);
        Rectangle2D rectangle2D = RectangleAnchor.createRectangle(size2D2, f, f2, rectangleAnchor);
        if (this.shadowPaint != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + this.shadowXOffset, rectangle2D.getY() + this.shadowYOffset, rectangle2D.getWidth(), rectangle2D.getHeight());
            graphics2D.setPaint(this.shadowPaint);
            graphics2D.fill(double_);
        }
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
        }
        if (this.outlinePaint != null && this.outlineStroke != null) {
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.draw(rectangle2D);
        }
        this.textBlock.draw(graphics2D, (float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY(), TextBlockAnchor.CENTER);
    }

    public double getHeight(Graphics2D graphics2D) {
        Size2D size2D = this.textBlock.calculateDimensions(graphics2D);
        return this.interiorGap.getAdjustedHeight(size2D.getHeight());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TextBox) {
            TextBox textBox = (TextBox)object;
            boolean bl = ObjectUtils.equal(this.outlinePaint, textBox.outlinePaint);
            boolean bl2 = ObjectUtils.equal(this.outlineStroke, textBox.outlineStroke);
            boolean bl3 = ObjectUtils.equal(this.interiorGap, textBox.interiorGap);
            boolean bl4 = ObjectUtils.equal(this.backgroundPaint, textBox.backgroundPaint);
            boolean bl5 = ObjectUtils.equal(this.shadowPaint, textBox.shadowPaint);
            boolean bl6 = this.shadowXOffset == textBox.shadowXOffset;
            boolean bl7 = this.shadowYOffset == textBox.shadowYOffset;
            boolean bl8 = ObjectUtils.equal(this.textBlock, textBox.textBlock);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.shadowPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.shadowPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

