/*
 * Decompiled with CFR 0.152.
 */
package clustering.weka;

import clustering.ClusterDescription;
import clustering.ClusterException;
import clustering.KMeansClusterInterface;
import clustering.RawDataInterface;
import clustering.weka.ImprovedSimpleKMeans;
import clustering.weka.WekaRawData;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instances;

public class WekaKMeansCluster
implements KMeansClusterInterface {
    private boolean doPCA = false;
    private int k = 0;
    private Instances instances = null;
    private Instances clusterCentroids = null;
    private Instances clusterMaximums = null;
    private Instances clusterMinimums = null;
    private Instances clusterStandardDeviations = null;
    private ImprovedSimpleKMeans kmeans = null;

    public WekaKMeansCluster() {
        this.reset();
    }

    public void reset() {
        this.clusterCentroids = null;
        this.clusterMaximums = null;
        this.clusterMinimums = null;
        this.clusterStandardDeviations = null;
    }

    public void setInputData(RawDataInterface rawDataInterface) {
        this.instances = (Instances)rawDataInterface.getData();
    }

    public void findClusters() throws ClusterException {
        try {
            this.kmeans = new ImprovedSimpleKMeans();
            this.kmeans.setNumClusters(this.k);
            Instances instances = null;
            if (this.doPCA) {
                PrincipalComponents principalComponents = new PrincipalComponents();
                principalComponents.setMaximumAttributeNames(1);
                principalComponents.setNormalize(true);
                principalComponents.setTransformBackToOriginal(true);
                principalComponents.buildEvaluator(this.instances);
                instances = principalComponents.transformedData();
            } else {
                instances = this.instances;
            }
            this.kmeans.buildClusterer(instances);
            this.clusterCentroids = this.kmeans.getClusterCentroids();
            this.clusterMaximums = this.kmeans.getClusterMaximums();
            this.clusterMinimums = this.kmeans.getClusterMinimums();
            this.clusterStandardDeviations = this.kmeans.getClusterStandardDevs();
            this.evaluateCluster();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ClusterDescription getClusterDescription(int n) throws ClusterException {
        return null;
    }

    public void setK(int n) {
        this.k = n;
    }

    public int getK() {
        return this.k;
    }

    public void setInitialCenters(int[] nArray) {
    }

    public RawDataInterface getClusterCentroids() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterCentroids);
        return wekaRawData;
    }

    public RawDataInterface getClusterMaximums() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterMaximums);
        return wekaRawData;
    }

    public RawDataInterface getClusterMinimums() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterMinimums);
        return wekaRawData;
    }

    public RawDataInterface getClusterStandardDeviations() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterStandardDeviations);
        return wekaRawData;
    }

    public int[] getClusterSizes() {
        return this.kmeans.getClusterSizes();
    }

    public void doPCA(boolean bl) {
        this.doPCA = bl;
    }

    public int clusterInstance(int n) {
        int n2 = 0;
        try {
            n2 = this.kmeans.clusterInstance(this.instances.instance(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public int getNumInstances() {
        return this.instances.numInstances();
    }

    private void evaluateCluster() {
        try {
            double d = this.kmeans.getBetweenError();
            double d2 = this.kmeans.getSquaredError();
            double d3 = d * (double)(this.k - 1) / (d2 * (double)(this.instances.numInstances() - this.k));
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

