/*
 * Decompiled with CFR 0.152.
 */
package clustering.weka;

import clustering.AnalysisFactory;
import clustering.ClusterDescription;
import clustering.ClusterException;
import clustering.KMeansClusterInterface;
import clustering.PrincipalComponentsAnalysisInterface;
import clustering.RawDataInterface;
import clustering.weka.WekaRawData;
import common.RMICubeData;
import java.util.ArrayList;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class WekaPrincipalComponents
implements PrincipalComponentsAnalysisInterface {
    private RawDataInterface inputData = null;
    private Instances instances = null;
    private Instances components = null;
    private PrincipalComponents pca = null;
    private int numAttributes = 0;
    private double[][] correlationCoefficients = null;
    private RMICubeData cubeData = null;
    private KMeansClusterInterface clusterer = null;
    private RawDataInterface[] clusters = null;
    private RawDataInterface transformed = null;
    private AnalysisFactory factory = null;

    public WekaPrincipalComponents(RMICubeData rMICubeData, AnalysisFactory analysisFactory) {
        this.cubeData = rMICubeData;
        this.factory = analysisFactory;
    }

    public void doPCA() throws ClusterException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < 2; ++n) {
            arrayList.add(this.cubeData.getNames()[n]);
        }
        this.transformed = this.factory.createRawData("Scatterplot Data", arrayList, 2, this.inputData.numVectors());
        for (n = 0; n < this.inputData.numVectors(); ++n) {
            float[] fArray = this.cubeData.getValues(n);
            for (int i = 0; i < 2; ++i) {
                this.transformed.addValue(i, n, fArray[i]);
            }
        }
    }

    public ClusterDescription getComponentDescription(int n) throws ClusterException {
        return null;
    }

    public void setInputData(RawDataInterface rawDataInterface) {
        this.inputData = rawDataInterface;
        this.instances = (Instances)rawDataInterface.getData();
    }

    public double[][] getCorrelationCoefficients() {
        if (this.correlationCoefficients == null) {
            this.numAttributes = this.instances.numAttributes();
            this.correlationCoefficients = new double[this.numAttributes][this.numAttributes];
            for (int i = 0; i < this.numAttributes; ++i) {
                double[] dArray = this.instances.attributeToDoubleArray(i);
                for (int j = 0; j < i; ++j) {
                    double[] dArray2 = this.instances.attributeToDoubleArray(j);
                    this.correlationCoefficients[i][j] = Utils.correlation((double[])dArray, (double[])dArray2, (int)this.numAttributes);
                }
            }
        }
        return this.correlationCoefficients;
    }

    public RawDataInterface getResults() {
        return this.transformed;
    }

    public void reset() {
    }

    public RawDataInterface[] getClusters() {
        if (this.clusterer != null) {
            int n;
            int[] nArray = this.clusterer.getClusterSizes();
            int n2 = this.clusterer.getK();
            this.clusters = new RawDataInterface[n2];
            Instances[] instancesArray = new Instances[n2];
            int[] nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                instancesArray[n] = n >= nArray.length ? new Instances((Instances)this.transformed.getData(), 0) : new Instances((Instances)this.transformed.getData(), nArray[n]);
                nArray2[n] = 0;
            }
            for (n = 0; n < this.inputData.numVectors(); ++n) {
                double[] dArray = new double[2];
                int n3 = this.clusterer.clusterInstance(n);
                dArray[0] = this.transformed.getValue(0, n);
                dArray[1] = this.transformed.getValue(1, n);
                instancesArray[n3].add(new Instance(1.0, dArray));
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + 1;
            }
            for (n = 0; n < n2; ++n) {
                this.clusters[n] = new WekaRawData(instancesArray[n]);
            }
        }
        return this.clusters;
    }

    public void setClusterer(KMeansClusterInterface kMeansClusterInterface) {
        this.clusterer = kMeansClusterInterface;
    }
}

