/*
 * Decompiled with CFR 0.152.
 */
package clustering.weka;

import clustering.RawDataInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaRawData
implements RawDataInterface {
    private Instances instances = null;
    private int vectors = 0;
    private int dimensions = 0;
    private double maximum = 0.0;
    private boolean normalize = false;
    private double[][] ranges = null;

    public WekaRawData(String string, List list, int n, int n2) {
        Object object;
        int n3;
        this.vectors = n;
        this.dimensions = n2;
        FastVector fastVector = new FastVector(list.size());
        for (n3 = 0; n3 < list.size(); ++n3) {
            object = (String)list.get(n3);
            fastVector.addElement((Object)new Attribute((String)object));
        }
        this.instances = new Instances(string, fastVector, n);
        for (n3 = 0; n3 < n; ++n3) {
            object = new double[n2];
            for (int i = 0; i < n2; ++i) {
                object[i] = 0.0;
            }
            this.instances.add(new Instance(1.0, (double[])object));
        }
    }

    public WekaRawData(Instances instances) {
        this.instances = instances;
        this.vectors = instances.numInstances();
        if (this.vectors > 0) {
            this.dimensions = instances.instance(0).numAttributes();
        }
    }

    public void addValue(int n, int n2, double d) {
        Instance instance = this.instances.instance(n);
        instance.setValue(n2, d);
        if (this.maximum < d) {
            this.maximum = d;
        }
    }

    public double getValue(int n, int n2) {
        if (this.normalize) {
            double d = this.instances.instance(n).value(n2);
            d -= this.ranges[n2][0];
            return d /= this.ranges[n2][1];
        }
        return this.instances.instance(n).value(n2);
    }

    public double getManhattanDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            d += Math.abs(this.instances.instance(n).value(i) - this.instances.instance(n2).value(i));
        }
        return d;
    }

    public double getCartesianDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double d2 = Math.abs(this.instances.instance(n).value(i) - this.instances.instance(n2).value(i));
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public Object getData() {
        return this.instances;
    }

    public List getEventNames() {
        Enumeration enumeration = this.instances.enumerateAttributes();
        ArrayList<String> arrayList = new ArrayList<String>(this.instances.numDistinctValues(0));
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            arrayList.add(attribute.name());
        }
        return arrayList;
    }

    public int numVectors() {
        return this.vectors;
    }

    public int numDimensions() {
        return this.dimensions;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double[] getVector(int n) {
        double[] dArray = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            dArray[i] = this.instances.instance(n).value(i);
        }
        return dArray;
    }

    public double getCorrelation(int n, int n2) {
        int n3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n3 = 0; n3 < this.vectors; ++n3) {
            d2 += this.instances.instance(n3).value(n);
            d3 += this.instances.instance(n3).value(n2);
        }
        d2 /= (double)this.vectors;
        d3 /= (double)this.vectors;
        for (n3 = 0; n3 < this.vectors; ++n3) {
            d4 += (this.instances.instance(n3).value(n) - d2) * (this.instances.instance(n3).value(n) - d2);
            d5 += (this.instances.instance(n3).value(n2) - d3) * (this.instances.instance(n3).value(n2) - d3);
        }
        d4 /= (double)(this.vectors - 1);
        d4 = Math.sqrt(d4);
        d5 /= (double)(this.vectors - 1);
        d5 = Math.sqrt(d5);
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < this.vectors; ++i) {
            d7 = (this.instances.instance(i).value(n) - d2) / d4;
            d8 = (this.instances.instance(i).value(n2) - d3) / d5;
            d += d7 * d8;
        }
        return d /= (double)(this.vectors - 1);
    }

    public void addMainValue(int n, int n2, double d) {
    }

    public double getMainValue(int n) {
        return 0.0;
    }

    public String getMainEventName() {
        String string = new String("");
        return string;
    }

    public void normalizeData(boolean bl) {
        this.normalize = bl;
        if (bl) {
            this.ranges = new double[this.dimensions][2];
            for (int i = 0; i < this.dimensions; ++i) {
                this.ranges[i][0] = this.instances.instance(0).value(i);
                this.ranges[i][1] = this.instances.instance(0).value(i);
                for (int j = 0; j < this.vectors; ++j) {
                    if (this.ranges[i][0] > this.instances.instance(j).value(i)) {
                        this.ranges[i][0] = this.instances.instance(j).value(i);
                    }
                    if (!(this.ranges[i][1] < this.instances.instance(j).value(i))) continue;
                    this.ranges[i][1] = this.instances.instance(j).value(i);
                }
                this.ranges[i][1] = this.ranges[i][1] - this.ranges[i][0];
            }
        }
    }
}

