'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: crypt.n,v 1.1 2004/09/06 00:43:47 jan Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "crypt" n 1.0 crypt "tcl extension to gen./check 3DES/MD5 passwords"
.BS
.SH "NAME"
crypt \- Procedures to generate/check 3DES/MD5 passwords
.SH "SYNOPSIS"
package require \fBTcl 8\fR
.sp
package require \fBcrypt ?1.0?\fR
.sp
\fB::crypt::random seed\fR \fInumber\fR|\fIchannelId\fR\fR
.sp
\fB::crypt::random get\fR ?\fImin max\fR?\fR
.sp
\fB::crypt::random salt des|md5\fR
.sp
\fB::crypt::password\fR \fIsalt\fR|\fIencryptedPassword\fR\fR
.BE
.SH "DESCRIPTION"
.PP
This package provides functions to generate/check 3DES/MD5 passwords often used in UN*X environments.
It has a pseudo-random generator for "salting" the generated passwords, that means: making them partly random.
.TP
\fB::crypt::random seed\fR \fInumber\fR|\fIchannelId\fR\fR
Sets the random seed to \fInumber\fR, if a number is given. Otherwise, the given argument is treated as a
channel name from which random data can be read. The file should be entropy-driven, e.g. a device
node leading to a hardware random generator or the like. One may use \fB/dev/random\fR on systems that provide it.
The amount of data read is determined by the system's requirements for random seeds and is often from 4 to 8 byte.
.sp
\fBImportant:\fR The call blocks if there is no data to read. In the case of /dev/random, there is no entropy
left to generate \fBreally random\fR numbers. In that case, simply move the mouse to get some randomness into
the computer. \fBNever use another pseudo-random generator like /dev/urandom as seed input! Also never
use a constant as seed!\fR This "seed" function should be used regularily in your program, depending on how often
you generate a random number/salt value. It's a good advice to "re-seed" the random generator each thousand
"salts" produced. If you ignore this notice, the resulting "salts" are only pseudo-random and predictable and the
resulting passwords are weak.
.TP
\fB::crypt::random get\fR ?\fImin max\fR?\fR
Get some random value from within the given range (\fImin\fR is included, \fImax\fR is not included).
None or both parameters have to be given, and both have
to be integers between 0 and RAND_MAX. The latter value is given by the system and the latter pair is the
default for \fImin\fR and \fImax\fR if no values are given.
.sp
\fBNotice:\fR You have to "seed" the random generator before using it. See \fB::crypt::random seed\fR.
.TP
\fB::crypt::random salt des|md5\fR
Generate a salt value for 3DES/MD5 passwords. This value can be used to generate a new password.
.sp
\fBNotice:\fR You have to "seed" the random generator before using it. See \fB::crypt::random seed\fR.
.TP
\fB::crypt::password\fR \fIpassword\fR \fIsalt\fR|\fIencryptedPassword\fR\fR
Encrypt or check a password. The given clear text \fIpassword\fR is encrypted with the given \fIsalt\fR.
If there is given an \fIencryptedPassword\fR instead of a plain "salt", the salt is extracted from the
\fIencryptedPassword\fR and the clear text \fIpassword\fR is encrypted with that "salt".
The latter case can be used to check a clear text \fIpassword\fR against a given encrypted one. Just check if
the encrypted clear text \fIpassword\fR is identical to the \fIencryptedPassword\fR afterwards.
.sp
\fBNotice:\fR It's just not possible to decrypt the \fIencryptedPassword\fR. This is intentional and due
to the 3DES/MD5 algorithm, which was used to encrypt it on first hand. That means, you can only check if the password
has been correct if you have known it, but it's impossible to guess it from the encrypted form.
.SH "EXAMPLES"
.TP
\fBSet up the random generator:\fR
.CS
set fd [ open /dev/random r ]
::crypt::random seed $fd
close $fd
.CE
.TP
\fBEncrypt a password given on stdin and check it:\fR
.CS
puts "Enter clear text password:"
set ENCRYPTED_PASSWORD [ ::crypt::password [ gets stdin ] [ ::crypt::random salt md5 ] ]
puts "\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n"
puts "The encrypted password is $ENCRYPTED_PASSWORD."
puts "Guess the clear text password:" 
if { [ ::crypt::password [ gets stdin ] $ENCRYPTED_PASSWORD ] == $ENCRYPTED_PASSWORD } { puts "Correct." } { puts "Wrong." }
.CE
.SH "KEYWORDS"
encryption, password, random
