/*
 * ext.h - Communication over the external interface
 *
 * Written 2001,2002 by Werner Almesberger
 * Copyright 2001,2002 Bivio Networks, Network Robots
 */


#ifndef EXT_H
#define EXT_H

#include <stdio.h>

#include "tree.h"


/*
 * Usage:
 *
 * ext_open runs the external program and opens a stream for sending data to
 * the program.
 *
 * Once all data is sent, ext_read closes the stream, waits for the process
 * to terminate, opens the stream for reading the output generated by the
 * external program, and returns the exit status. (Or -1 if the process did
 * not exit normally.)
 *
 * ext_close can be called before or after ext_read to close the stream.
 */

FILE *ext_open(char **argv,const char *name);
void ext_read(const char *name,const char *action);
void ext_close(void);

void add_tcc_external_arg(const char *name,const char *arg);

void ext_config(const char *name);
void ext_build(const char *name,const QDISC *qdisc,const FILTER *filter,
  void (*dump_config)(FILE *file,void *user),void *user);

void ext_dump_class(FILE *file,const CLASS *class,const PARAM_DSC **special,
  void (*fn)(FILE *file,const PARAM_DSC *param,const CLASS *class));
void do_ext_dump_qdisc(FILE *file,const QDISC *qdisc,const QDISC_DSC *dsc,
  const PARAM_DSC **special,void (*fn)(FILE *file,const PARAM_DSC *param,
  const QDISC *qdisc));
void ext_dump_qdisc(FILE *file,const QDISC *qdisc,const PARAM_DSC **special,
  void (*fn)(FILE *file,const PARAM_DSC *param,const QDISC *qdisc));

#endif /* EXT_H */
