/*
 * sockprot.h - C++ header for sockprot.cpp
 * socket addresses handling
 * $Id: sockprot.h,v 1.2 2004/06/05 15:15:17 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_SOCKPROT_H
# define __TCPREEN_SOCKPROT_H

# include <stddef.h>
# include <sys/types.h>
# if HAVE_SYS_SOCKET_H
#  include <sys/socket.h> // SOCK_STREAM, PF_UNSPEC
# endif
# include "getaddrinfo.h" // struct addrinfo

# ifndef AF_UNSPEC
#  define AF_UNSPEC 0
#  define PF_UNSPEC 0
# endif

class SocketAddress
{
	private:
		int err_ai, err_sys;
		char myhost[1024], myserv[128];
		struct addrinfo *res;

		int SetFromSocket (int fd, int flags, int side);

	public:
		SocketAddress (void) : err_ai (0), err_sys (0), res (NULL)
		{
		}

		int GetSockName (int fd, int flags = 0)
		{
			return SetFromSocket (fd, flags, 0);
		}

		int GetPeerName (int fd, int flags = 0)
		{
			return SetFromSocket (fd, flags, 1);
		}
		/* Creates a socket address from a bound socket. */

		int SetByName (const char *host, const char *service,
				int flags = 0, int af = AF_UNSPEC,
				int type = SOCK_STREAM, int proto = 0);
		/* Resolves a socket address. */

		SocketAddress& operator= (const SocketAddress& src);
		SocketAddress (const SocketAddress& src);
		/* Copy constructor. */

		~SocketAddress (void);

		int SetError (int ai = EAI_SYSTEM);
		void ClearError (void)
		{
			SetError (0);
		}

		int GetError (void) const
		{
			return err_ai;
		}

		int Bind (void);
		int Connect (int nonblock = 0);
		void CleanUp (void) const;

		int operator! (void) const
		{
			return err_ai;
		}

		const char *StrError (void) const;
		const char *Node (void) const
		{
			return myhost;
		}
		const char *Service (void) const
		{
			return myserv;
		}
};

#endif
