//*****************************************************************************
// copyright (c) 1991-2004 TLK Games all rights reserved
//-----------------------------------------------------------------------------
// file		: "technoBall.h"
// created		: ?
// updates		: 2004-10-10
// fonction	: handle ball of game
//-----------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place - Suite 330, Boston, MA  02111-1307, USA.
//******************************************************************************
#ifndef __TECHNOBALL__
#define __TECHNOBALL__
//...............................................................................
class technoBall;
//...............................................................................
#include "../include/BOB_killer.h"
//-------------------------------------------------------------------------------
// structure of ball start coordinates (ejectors)
//-------------------------------------------------------------------------------
typedef struct
{	Sint32	ejectBall1;
 	Sint32	ejectBall2;
	Sint32	ejectBall3;
	Sint32	ejectBall4;
	Sint32	position_x;
	Sint32	position_y;
} furaxEject;


#include "../include/tecno_bump.h"
#include "../include/lesBriques.h"
#include "../include/ballDirect.h"
#include "../include/ejectBalls.h"

//...............................................................................
class technoBall:public BOB_killer
{
	friend class zeNewBalls;
	friend class ballDirect;
	friend class zeRaquette;
	friend class tecno_caps;
	friend class techno_gem;
	friend class zeguardian;
	friend class directBall;
    
	public:
		static const Sint32              BALLNORMAL = 0;
		static const Sint32              BALLPOWER1 = 1;
		static const Sint32              BALLPOWER2 = 2;
		static const Sint32              BALL_SIZE1 = 0;
		static const Sint32              BALL_SIZE2 = 3;
		static const Sint32              BALL_SIZE3 = 6;
	
		// width and height of collision of the three sizes of ball (low-res)
		static const Sint32              BALLWIDTH1 = 5;
		static const Sint32              BALLWIDTH2 = 7;
		static const Sint32              BALLWIDTH3 = 9;

		// balls moving limits (low-res)
		static const Sint32              MINIMUM_PX = 5;	//left limit
		static const Sint32              MAXIMUM_PX = 250;	//right limit
		static const Sint32              MINIMUM_PY = 0;	//top limit
		static const Sint32              MAXIMUM_PY = 230;	//bottom limit

	
	private:
		Sint32				directBall;		//ball direction (0 to 56 step 4)
		Sint32				save_Dball;		//last directBall (0 to 56 step 4)
		Sint32				countDball;		//counter before rebound forcing
		tecno_bump*			raket_ball;		//pointer to the bumper touched
		tecno_bump*			raket_glue;		//pointer to the bumper sticked
		Sint16*				speedBallT;		//pt/speed table
		Sint16*				speedBallZ;		//pt/speed table
		Sint32*				collisionT;		//pt/bricks collisions table
		Sint32				powerBall1;		//value decreasing bouiboui strength
		Sint32				powerBall2;		//value decreasing brick strength (2 4 or 6) 
		Sint32				eject_ball[4];	//flag pour coins haut-gauche/bas-gauche/bas_droite/haut-droite
		Sint32				colleBallF;		//sticky ball flag
		Sint32				tiltCompte;		//counter before a tilt is possible 
		Sint32				ClBouiBoui;		//0=no bouibouis collisions
		Sint32				speedCount;		//temps que dure la vitesse
		Sint32				speed_init;		//temps que dure la vitesse (valeur initiale)
		Sint32				startCount;		//temps avant que la balle parte
		Sint32				start_init;		//temps avant que la balle parte (valeur initiale)
		Sint32				balle_rota;		//pointeur sur table ballePets 
		Sint32				tempo_rota;		//Tempo rotation du point autour de la balle
		Sint32				ball_sizeX;		//Pointeur Gfx 
		Sint32				ballPowerX;		//Pointeur Gfx
		Sint32				oeilRotate;		//1=rotation autour de l'oeil  
		Sint32				brickWidth;		//brick's width in pixels
		Sint32				colli_wall;		//collision with one wall

		static Sint32		brikPoint1[8];	//Points collision balle taille 1
		static Sint32		brikPoint2[8];	//Points collision balle taille 2
		static Sint32		brikPoint3[8];	//Points collision balle taille 3
		static Sint16		ballSpeed1[];	//Table deplacement balle vitesse 1
		static Sint16		ballSpeed2[];	//Table deplacement balle vitesse 2
		static Sint16		ballSpeed3[];	//Table deplacement balle vitesse 3
		static Sint16		ballSpeed4[];	//Table deplacement balle vitesse 4
		static furaxEject	furaxTable[];	//Table d'apparition des balles dans les ejecteurs
		static const Sint32	tilt_table[16][16];

	public:
							technoBall();
							~technoBall();
		void				littleInit(Sint32 start, Sint32 speed,
										tecno_bump *raket, Sint16 *table,
										Sint32 bwght);
		void				reStarting(tecno_bump *raket);
		void				goSleeping(tecno_bump *raket);
		void				startBalle(Sint32 large);
		void				razingBall(tecno_bump *raket);
		void				razingBal0(tecno_bump *raket);
		void				duplicate3(technoBall *balle, Sint32 angle);
		static short*		donneSpeed(Sint32 speed);
		tecno_bump*			donne_bump();
		void				ballPower1();
		void				ballPower2();
		void				ball_size2();
		void				ball_size3();
		void				very_speed();
		void				ball2eject(Sint32 index, Sint32 otime = 1);
		void				glueLibere();
		void				accelerate();
    
	private:
		void				pointe_GFX();
};
#endif
