#!/bin/sh

########################################################################
#
#   Given a directory with PostScript fonts in font.pfb format, 
#   generate a directory called 'derived ' with material to support 
#   the files from GhostScript. 
#
#   This is an example that is part of the Ted word processor installation.
#   Do not run this script before you know exactly what it does.
#   In particular, realise that it destroys any directory or file 
#   called 'derived' in the current directory.
#   Refer to http://www.nllgg.nl/Ted/index.html for the 'Ted' documentation.
#
########################################################################

rm -rf derived
mkdir derived

for pfb in *.pfb
do
    afm=`basename $pfb .pfb`.afm

    cp $pfb derived/$pfb
    pf2afm derived/$pfb
    rm derived/$pfb

    Ted --AfmToXFontsDir derived/$afm - | \
		sed -e "s/FontFileName/$pfb/" >> derived/fonts.dir.extra

    Ted --AfmToGSFontmap derived/$afm - | \
		sed -e "s/FontFileName/$pfb/" >> derived/Fontmap.extra
done

echo '###########' Generated files:
du -a derived
