import telepathy.server.conn
from telepathy.interfaces import *
from telepathy.constants import *
from tpblue.SmsChannel import SmsChannel
from tpblue.sms import SmsController
import btctl

SERIAL_PORT_SVCLASS_ID = 0x1101

class Connection(telepathy.server.conn.Connection):
	def __init__(self, proto, account):
		telepathy.server.conn.Connection.__init__(self, proto, account)
		self.sms_controller = None
		
	def on_bt_device_service_discovered(self, controller, bt_addr, bt_name, clsid, bt_chan):
		if clsid == SERIAL_PORT_SVCLASS_ID and self.sms_controller == None:
			self.sms_controller = SmsController(bt_addr, bt_chan)
			self.sms_controller.connect('sms-received', self.on_sms_controller_sms_received)
			self.sms_controller.connect('disconnected', self.on_sms_controller_disconnected)
	
	def on_sms_controller_sms_received(self, ctl, number, message):
		print 'SMS Received', message
		
		# FIXME: Ugly hack, return a proper signal here.
		number, message = message.split(":")

		handle = self.RequestHandles(CONNECTION_HANDLE_TYPE_CONTACT, [number], "telepathy-blue")[0]
		handle = self._handles[CONNECTION_HANDLE_TYPE_CONTACT, handle]
		chan = SmsChannel(self, CONNECTION_HANDLE_TYPE_CONTACT, handle)
		self.add_channel(chan, handle, False)
		chan.Received(1, 111, handle.get_id(), CHANNEL_TEXT_MESSAGE_TYPE_NORMAL, 0, message)

	def on_sms_controller_disconnected(self, ctl):
		print 'Sms Controller disconnected'
		self.sms_controller = None
		self.StatusChanged(CONNECTION_STATUS_DISCONNECTED, CONNECTION_STATUS_REASON_NETWORK_ERROR)
	
	def Connect(self):
		ctl=btctl.Controller("hci0")
		ctl.connect ("add-device-service", self.on_bt_device_service_discovered)

		print 'Starting discovery'
		ctl.discover_devices()
		
		if self.sms_controller == None:
			print 'Unable to find a BT phone supporting serial connection'
			self.StatusChanged(CONNECTION_STATUS_DISCONNECTED, CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED)
			return
			
		print 'Connecting to phone'
		connected = self.sms_controller.connect_bt()
		if not connected:
			print 'Unable to connect to BT phone'
			self.sms_controller = None
			self.StatusChanged(CONNECTION_STATUS_DISCONNECTED, CONNECTION_STATUS_REASON_NETWORK_ERROR)
			return
		
		self.StatusChanged(CONNECTION_STATUS_CONNECTED, CONNECTION_STATUS_REASON_REQUESTED)
		
	def Disconnect(self):
		if self.sms_controller != None:
			self.sms_controller.disconnect_bt()
			self.sms_controller = None
			
		self.StatusChanged(CONNECTION_STATUS_DISCONNECTED, CONNECTION_STATUS_REASON_REQUESTED)
	
	def RequestChannel(self, type, handle_type, handle, suppress_handler):
		self.check_connected()
		if type != CHANNEL_TYPE_TEXT:
			raise NotImplemented('unknown channel type %s' % type)
		
		assert (handle_type, handle) in self._handles
		if handle_type != CONNECTION_HANDLE_TYPE_CONTACT:
			raise NotImplemented('unknown handle type %s for channel type %s' % (handle_type, type))
			
		handle = self._handles[handle_type, handle]
		chan = SmsChannel(self, handle_type, handle)
		self.add_channel(chan, handle, suppress_handler)
		return chan._object_path
