import telepathy.server.channel
from telepathy.constants import *

class SmsChannel(telepathy.server.channel.ChannelTypeText):
	def __init__(self, connection, type, handle):
		telepathy.server.channel.ChannelTypeText.__init__(self, connection, handle)
	
	def Send(self, type, text):
		print 'Sending message:', text, self._handle.get_name()
		if self._conn.sms_controller == None:
			self.SendError (CHANNEL_TEXT_SEND_ERROR_OFFLINE, 111, type, text)
			return
			
		sent = self._conn.sms_controller.send_sms (self._handle.get_name(), text)
		if not sent:
			self.SendError (CHANNEL_TEXT_SEND_ERROR_OFFLINE, 111, type, text)
			return
			
		self.Sent(111, type, text)
