/*
 *  Copyright (C) 2006, Raphaël Slinckx <raphael@slinckx.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id$
 */

#ifndef TP_BLUE_AT_CONTROLLER_H
#define TP_BLUE_AT_CONTROLLER_H

#include <glib-object.h>

G_BEGIN_DECLS

#define TP_BLUE_TYPE_AT_CONTROLLER				(tp_blue_at_controller_get_type ())
#define TP_BLUE_AT_CONTROLLER(o)				(G_TYPE_CHECK_INSTANCE_CAST ((o), TP_BLUE_TYPE_AT_CONTROLLER, TpBlueAtController))
#define TP_BLUE_AT_CONTROLLER_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST((k), TP_BLUE_TYPE_AT_CONTROLLER, TpBlueAtControllerClass))
#define TP_BLUE_IS_AT_CONTROLLER(o)			(G_TYPE_CHECK_INSTANCE_TYPE ((o), TP_BLUE_TYPE_AT_CONTROLLER))
#define TP_BLUE_IS_AT_CONTROLLER_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), TP_BLUE_TYPE_AT_CONTROLLER))
#define TP_BLUE_AT_CONTROLLER_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), TP_BLUE_TYPE_AT_CONTROLLER, TpBlueAtControllerClass))

typedef struct _TpBlueAtControllerClass		TpBlueAtControllerClass;
typedef struct _TpBlueAtController				TpBlueAtController;
typedef struct _TpBlueAtControllerPrivate	TpBlueAtControllerPrivate;

struct _TpBlueAtController
{
	GObject parent;

	/*< private >*/
	TpBlueAtControllerPrivate *priv;
};

struct _TpBlueAtControllerClass
{
	GObjectClass parent_class;
	void (* response_received) (gchar *response);
	void (* error_received) (void);
	void (* disconnected) (void);
};

GType tp_blue_at_controller_get_type (void) G_GNUC_CONST;
TpBlueAtController	*tp_blue_at_controller_new (void);
gboolean tp_blue_at_controller_send (TpBlueAtController *controller, gchar *message, gchar *expect, gboolean readline, gchar **answer);
void tp_blue_at_controller_disconnect (TpBlueAtController *self);
gboolean tp_blue_at_controller_connect (TpBlueAtController *self, gchar *bt_address, guint bt_channel);

G_END_DECLS

#endif
