/*
 * This file is part of telepathy-feed
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <string.h>
#include <glib.h>

#include <libgalago/galago.h>

#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

#include "dbus.h"

DBusGConnection *gconnection;
DBusConnection *connection;

static GMainLoop *mainloop;

static void
on_unregister_cb (GalagoObject *core, gpointer user_data)
{
  g_main_loop_quit (mainloop);
}

int
main (int argc, char **argv)
{
  GError *error = NULL;

  /* Initialize glib */
  g_type_init();
  mainloop = g_main_loop_new (NULL, FALSE);

  g_printerr ("Starting telepathy-feed...\n");
  
  /* Get a connection to the session bus */
  gconnection = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
  if (gconnection == NULL) {
    g_critical ("Failed to open connection to bus: %s", error->message);
    g_error_free (error);
    return 1;
  }
  /* Store this too for convenience */
  connection = dbus_g_connection_get_connection (gconnection);
  
  /* Connect to Galago */
  if (!galago_init ("telepathy-feed", GALAGO_INIT_FEED)) {
    g_critical ("Cannot initialise Galago");
    return 1;
  }
  
  g_signal_connect (galago_get_core (), "unregistered",
                    G_CALLBACK (on_unregister_cb), NULL);

  /* Listen for new connections being created */
  listen_for_new ();
  
  /* Get all currently active connections */
  connect_to_existing ();

  /* Go go go */
  g_main_loop_run (mainloop);

  /* Cleanup */
  g_main_loop_unref (mainloop);
  
  return 0;
}
