/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-dlg-advertise-caps.h:
 * Dialog to expose AdvertiseCapabilities() method on interface
 * org.freedesktop.Telepathy.Connection.Interface.Capabilities
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_ADVERTISE_CAPS_H__
#define __TI_DLG_ADVERTISE_CAPS_H__

#include "ti-handle-mapper.h"

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgAdvertiseCaps TIDlgAdvertiseCaps;
typedef struct _TIDlgAdvertiseCapsClass TIDlgAdvertiseCapsClass;

#define TI_TYPE_DLG_ADVERTISE_CAPS               ti_dlg_advertise_caps_get_type()
#define TI_DLG_ADVERTISE_CAPS(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_ADVERTISE_CAPS, TIDlgAdvertiseCaps))
#define TI_DLG_ADVERTISE_CAPS_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_ADVERTISE_CAPS, TIDlgAdvertiseCapsClass))
#define TI_IS_DLG_ADVERTISE_CAPS(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_ADVERTISE_CAPS))
#define TI_IS_DLG_ADVERTISE_CAPS_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_ADVERTISE_CAPS))
#define TI_DLG_ADVERTISE_CAPS_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_ADVERTISE_CAPS, TIDlgAdvertiseCapsClass))

struct _TIDlgAdvertiseCaps
{
    GObject parent;
};

struct _TIDlgAdvertiseCapsClass
{
    GObjectClass parent;
};

GType ti_dlg_advertise_caps_get_type (void);

TIDlgAdvertiseCaps* ti_dlg_advertise_caps_new (GtkWindow* parent);

/**
 * Shows the "Advertise Capabilities" dialog.
 *
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_advertise_caps_run (TIDlgAdvertiseCaps* dlg_advertise_caps, GPtrArray** add_caps, gchar*** remove_caps);

#endif
