/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test preferences managers.
 * 
 * ti-preferences.h:
 * Singleton that holds global application preferences.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PREFERENCES_H__
#define __TI_PREFERENCES_H__

#include <glib-object.h>

/*
 * Type macros.
 */

typedef struct _TIPreferences TIPreferences;
typedef struct _TIPreferencesClass TIPreferencesClass;

#define TI_TYPE_PREFERENCES               ti_preferences_get_type()
#define TI_PREFERENCES(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_PREFERENCES, TIPreferences))
#define TI_PREFERENCES_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PREFERENCES, TIPreferencesClass))
#define TT_IS_PREFERENCES(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_PREFERENCES))
#define TT_IS_PREFERENCES_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PREFERENCES))
#define TI_PREFERENCES_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_PREFERENCES, TIPreferencesClass))

struct _TIPreferences {
    GObject parent;
};

GType ti_preferences_get_type (void);

/**
 * Creates a new preferences
 */
TIPreferences* ti_preferences_new ();

/**
 * Get Handle Display Mode
 * How to display handles.
 */
guint ti_preferences_get_handle_display_mode (TIPreferences* preferences);

/**
 * Set Handle Display Mode
 *
 */
void ti_preferences_set_handle_display_mode (TIPreferences* preferences, guint new_mode);

/**
 * Get Auto Inspect Handles
 * Whether unknown handles should be automatically inspected.
 */
gboolean ti_preferences_get_auto_inspect_handles (TIPreferences* preferences);

/**
 * Set Auto Inspect Handles
 * Whether unknown handles should be automatically inspected.
 */
void ti_preferences_set_auto_inspect_handles (TIPreferences* preferences, gboolean auto_inspect);

#endif
