# -*- Mode: ruby; indent-tabs-mode: nil -*-
#
#  $Id: tc_div.rb,v 1.4 2003/09/22 07:46:20 hisa Exp $
#
#  Copyright (c) 2003 FUJIMOTO Hisakuni <hisa@fobj.com>
#

require 'test/unit'
require 'tempura/div'
require 'tempura/charconv_euc'
require 'div/div'
require 'div/tofusession'
require 'tofu/tofu'
require 'model'

class TC_Div < Test::Unit::TestCase

  class TestDiv < Tempura::Div
    attr_reader :model
    def initialize(session)
      super
      @model = Model.new( [[ 'ebiten', 32 ], [ 'nasu', 12 ], [ 'kakiage', 8 ]] )
    end
  end

  def setup
    bartender = Tofu::Bartender.new(Div::TofuSession)
    @session = Div::TofuSession.new(bartender)
    @path_en = "view.en.html"
    @path_ja = "view.ja.html"
    @div_test_html = "div_test.html"
  end

  def test_s_set_template
    assert_nothing_raised { Tempura::Div.set_template(@path_en) }
    assert_nothing_raised { Tempura::Div.set_template(@path_ja, :ja) }
  end

  def test_s_reload_template
    Tempura::Div.set_template(@path_en)
    Tempura::Div.set_template(@path_ja, :ja)
    assert_nothing_raised { Tempura::Div.reload_template }
  end

  def test_s_set_safe_level
    (0..5).each do |safe_level|
      assert_nothing_raised { Tempura::Div.set_safe_level(safe_level) }
    end
      assert_nothing_raised { Tempura::Div.set_safe_level(nil) }
  end

  def test_s_new
    Tempura::Div.set_template(@path_en)
    Tempura::Div.set_template(@path_ja, :ja)
    div = nil
    assert_nothing_raised { div = Tempura::Div.new(@session) }
    assert_kind_of( Div::Div, div )
    assert_kind_of( Tempura::Div, div )
  end

  def test_select_template
    Tempura::Div.set_template(@path_en)
    Tempura::Div.set_template(@path_ja, :ja)
    div = Tempura::Div.new(@session)
    assert_nothing_raised { div.select_template :ja }
    assert_nothing_raised { div.select_template nil }
  end

  def test_to_html_document
    TestDiv.set_template(@div_test_html)
    div = TestDiv.new(@session)
    elm = nil
    assert_nothing_raised { elm = div.to_html_document }
    assert_kind_of( REXML::Document, elm )
    assert_nothing_raised { elm = div.to_html_document("hello world") }
    assert_kind_of( REXML::Document, elm )
    assert_equal( "hello world", elm.elements["body/h1"].text )
    assert_nothing_raised { elm = div.to_html_document(nil, :ja) }
    assert_kind_of( REXML::Document, elm )
    str = div.model.items.map{|i|"<li>#{i.name}:#{i.price}</li>"}.join
    re = /<ul>.*#{str}.*<\/ul>/m
    assert_match( /<ul>.*#{str}.*<\/ul>/m, elm.elements["body/ul"].to_s )
  end

  def test_to_html
    TestDiv.set_template(@div_test_html)
    div = TestDiv.new(@session)
    str = nil
    assert_nothing_raised { str = div.to_html }
    assert_kind_of( String, str )
    assert_nothing_raised { str = div.to_html("hello world") }
    assert_match( /<h1>hello world<\/h1>/, str )
    assert_nothing_raised { str = div.to_html(nil, :ja) }
    assert_kind_of( String, str )
    lis = div.model.items.map{|i|"<li>#{i.name}:#{i.price}</li>"}.join
    re = /<ul>.*#{lis}.*<\/ul>/m
    assert_match( re, str )
  end

  def test_to_div_document
    TestDiv.set_template(@div_test_html)
    div = TestDiv.new(@session)
    doc = nil
    assert_nothing_raised { doc = div.to_div_document }
    assert_kind_of( REXML::Document, doc )
    assert_nothing_raised { doc = div.to_div_document("hello world") }
    assert_kind_of( REXML::Document, doc )
    assert_equal( "div", doc.root.name )
    assert_equal( "hello world", doc.elements["div/body/h1"].text )
    assert_nothing_raised { doc = div.to_div_document(nil, :ja) }
    assert_kind_of( REXML::Document, doc )
    str = div.model.items.map{|i|"<li>#{i.name}:#{i.price}</li>"}.join
    re = /<ul>.*#{str}.*<\/ul>/m
    assert_match( /<ul>.*#{str}.*<\/ul>/m, doc.elements["div/body/ul"].to_s )
  end

  def test_to_div
    TestDiv.set_template(@div_test_html)
    div = TestDiv.new(@session)
    str = nil
    assert_nothing_raised { str = div.to_div }
    assert_kind_of( String, str )
    assert_nothing_raised { str = div.to_div("hello world") }
    assert_kind_of( String, str )
    assert_match( /<div .*>.*<body>.*<h1>hello world<\/h1>.*<\/body>.*<\/div>/m, str )
    assert_nothing_raised { str = div.to_div(nil, :ja) }
    assert_kind_of( String, str )
    lis = div.model.items.map{|i|"<li>#{i.name}:#{i.price}</li>"}.join
    re = /<ul>.*#{lis}.*<\/ul>/m
    assert_match( re, str )
  end

end
