/* dvipages -  Print the number of pages in a DVI file
 * by Hirotsugu Kakugawa
 *
 */
/*
 * Copyright (C) 2001  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#if HAVE_STDARG_H
#  include <stdarg.h>
#else
#  include <varargs.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif

#include "dvi-2_6.h"
#include "defs.h"
#include "../params.h"

#define PR1(s1)    fprintf(stderr, s1);
#define PR2(s1,s2) fprintf(stderr, s1,s2);

#define  DEFAULT_VFLIBCAP        "vflibcap-tex"
#define  DEFAULT_DPI             300
#define  DEFAULT_KPATHSEA_MODE   "cx"


int      param_dpi           = DEFAULT_DPI;
char    *param_kpathsea_mode = DEFAULT_KPATHSEA_MODE;
char    *param_vflibcap      = DEFAULT_VFLIBCAP;
char    *param_dvi_file      = NULL;
int      param_quiet         = 0;

DVI_PROPERTY   param_dvi_prop = NULL;

DVI_DEVICE   create_dev(void);
void  parse_args(int argc, char **argv);
void  dev_message(DVI_DEVICE,DVI,char*,...);
void  dev_message_null(DVI_DEVICE,DVI,char*,...);
void  usage(void);
void  license(void);



int
main(int argc, char **argv)
{
  DVI          dvi  = NULL;
  DVI_DEVICE   dev  = NULL;
  char         params[1024], tmp[1024];

  parse_args(argc, argv);

  if (param_dvi_file == NULL)
    usage();

  sprintf(params, "%s=%s", PARAM_NAME_PROG, "dvispecials");
  if (param_dpi > 0){
    sprintf(tmp, ", %s=%d", PARAM_NAME_DPI,  param_dpi);
    strcat(params, tmp);
  }
  if (param_kpathsea_mode != NULL){
    sprintf(tmp, ", %s=%s", PARAM_NAME_MODE, param_kpathsea_mode);
    strcat(params, tmp);
  }

  if (DVI_INIT(param_vflibcap, NULL) < 0){
    fprintf(stderr, "%s: Can't initialize DVI interpreter\n", "dvipages");
    exit(1);
  }
  if ((dev = create_dev()) == NULL){
    fprintf(stderr, "%s: Can't initialize device\n", "dvipages");
    exit(1);
  }

  param_dvi_prop = DVI_PROPERTY_ALLOC_DEFAULT();
  DVI_PROPERTY_SET(param_dvi_prop, DVI_PROP_SKIP_RENDERING);
  DVI_PROPERTY_SET(param_dvi_prop, DVI_PROP_SKIP_SPECIALS);
  DVI_PROPERTY_SET(param_dvi_prop, DVI_PROP_DELAYED_FONT_OPEN);

  if ((dvi = DVI_CREATE(dev, param_dvi_file, param_dvi_prop)) == NULL){
    fprintf(stderr, "%s: Can't open a DVI file: %s\n", 
	    "dvipages", param_dvi_file);
    exit(1);
  }
  
  printf("%d\n", dvi->pages);

  return 0;
}


DVI_DEVICE  
create_dev(void)
{
  DVI_DEVICE  dev;
  
  if ((dev = DVI_DEVICE_ALLOC()) == NULL)
    return NULL;
  dev->h_dpi = dev->v_dpi   = param_dpi;
  dev->message_advice       = dev_message_null;
  dev->message_warning      = dev_message;
  dev->message_error        = dev_message;
  dev->message_fatal        = dev_message;
  return dev;
}


void  
dev_message(DVI_DEVICE dev, DVI dvi, char *fmt,...)
{
  va_list ap;
  
  va_start(ap, fmt);
  fprintf(stderr, "%s: ", "dvipages");
  vfprintf(stderr, fmt, ap);  
  fprintf(stderr, "\n");
  va_end(ap);
}

void  
dev_message_null(DVI_DEVICE dev, DVI dvi, char *fmt,...)
{
  ;
}



void
parse_args(int argc, char **argv)
{

  for (--argc, argv++; argc > 0;  argc--, argv++){
    if ((strcmp(*argv, "-h") == 0) || (strcmp(*argv, "--help") == 0)){
      usage();
      exit(0);
    } else if (strcmp(*argv, "-license") == 0){
      license();
      exit(0);
    } else if ((strcmp(*argv, "-v") == 0) && (argc > 1)){
      argc--;  argv++;
      param_vflibcap = *argv;
    } else if (strcmp(*argv, "-cx") == 0){
      param_dpi = 300;  
      param_kpathsea_mode = "cx";
    } else if (strcmp(*argv, "-sparcptr") == 0){
      param_dpi = 400;  
      param_kpathsea_mode = "sparcptr";
    } else if (strcmp(*argv, "-ljfour") == 0){
      param_dpi = 600;  
      param_kpathsea_mode = "ljfour";
    } else if ((strcmp(*argv, "-dpi") == 0) && (argc > 1)){
      argc--;  argv++;
      param_dpi = atoi(*argv);
    } else if ((strcmp(*argv, "-mode") == 0) && (argc > 1)){
      argc--;  argv++;
      param_kpathsea_mode = *argv;
    } else if ((strcmp(*argv, "-f") == 0) && (argc > 1)){
      argc--;  argv++;
      param_dvi_file = *argv;
    } else if (strcmp(*argv, "-q") == 0){
      param_quiet = 1;
    } else if (**argv != '-'){
      param_dvi_file = *argv;
    } else {
      fprintf(stderr, "%s: Unknow option: %s\n", "dvipages", *argv);
      exit(1);
    }
  }

  if (param_dvi_file == NULL){
    fprintf(stderr, "%s: No DVI file\n", "dvipages");
    exit(1);
  }
}

void  
usage(void)
{
  PR1("dvipages --- Print the number of pages in a DVI file.\n");
  PR1("Usage: dvispecials DVI-FILE\n");
  exit(0);
}

void  
license(void)
{
  PR1("Copyright (C) 2001 Hirotsugu Kakugawa.\n");
  PR1("All rights reserved.\n");
  PR1("This program is free software; you can redistribute it and/or\n");
  PR1("modify it under the terms of the GNU General Public License as\n");
  PR1("published by the Free Software Foundation; either version 2, or \n");
  PR1("(at your option) any later version.\n");
  PR1("\n");
  PR1("This program is distributed in the hope that it will be useful,\n");
  PR1("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
  PR1("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
  PR1("GNU General Public License for more details.\n");
  PR1("\n");
  PR1("This program uses DVIlib and VFlib which are distributed under the\n");
  PR1("terms of GNU Lribrary General Public License\n");
}


/*EOF*/
