/* spwx11  -  the Simplest Previewer in the World for X11 */
/* Copyright (C) 1997-2001  Hirotsugu Kakugawa            */
#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "dvi-2_6.h"

#define VERSION                    "1.0.1" 
#define DEFAULT_VFLIBCAP           "vflibcap-tex"
#define DEFAULT_DPI	           300     /* font resolution */
#define DEFAULT_KPATHSEA_MODE      "cx"    /* kpathsea device mode */
#define DEFAULT_OFFSET_X           1.00    /* left margin, in inch */
#define DEFAULT_OFFSET_Y           1.00    /* top margin, in inch */
#define DEFAULT_SHRINK             4       /* shrink factor */
#define PAPER_W                    8.27    /* paper width, in inch*/
#define PAPER_H                   11.7     /* paper height, inch*/
#define EXIT1(s)      { fprintf(stderr,"%s", s); exit(1); }
#define EXIT2(fmt,s)  { fprintf(stderr,fmt, s);  exit(1); }

DVI              dvi   = NULL;
DVI_DEVICE       dev   = NULL;
DVI_FRAME_BUFFER fb    = NULL;
Display         *x_disp;
Window           x_win;
GC               x_gc_win;
int              x_w, x_h, x_ofsx, x_ofsy;

int  main_loop(DVI_DEVICE dev, DVI dvi)
{
  XEvent  xev;
  int  draw, thePage = 1;

  for (;;){
    XNextEvent(x_disp, &xev);
    draw = 0;
    if (xev.type == Expose){
      draw = 1;
      while (XCheckWindowEvent(x_disp, x_win, ExposureMask, &xev) == True)
	;
    } else if (xev.type == KeyPress){
      draw = 1;
      if ((XLookupKeysym(&xev.xkey, 0) == XK_space) && (thePage < dvi->pages))
	thePage++;
      else if ((XLookupKeysym(&xev.xkey, 0) == XK_b) && (1 < thePage))
	thePage--;
      else if (XLookupKeysym(&xev.xkey, 0) == XK_q)
	exit(0);
    }
    if (draw == 1){
      XClearWindow(x_disp, x_win);
      DVI_fb_clear(fb);
      DVI_DRAW_PAGE(dvi, dev, thePage, DEFAULT_SHRINK);
    }
  }
}

void x_draw_fb(long x, long y, unsigned int w, unsigned int h)
{
  int      i, j;
  XImage   *img;
  static unsigned char bits[] = {0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};

  if (((img = XCreateImage(x_disp, DefaultVisual(x_disp,0), 
			   DefaultDepth(x_disp,0),
			   ZPixmap, 0, NULL, w, h, 8, 0)) == NULL)
      || ((img->data = (char*)malloc(img->bytes_per_line * h)) == NULL))
    return;
  for (i = 0; i < h; i++)
    for (j = 0; j < w; j++)
      if ((fb->data[fb->raster * (i+y) + (j+x)/8] & bits[(j+x)%8]) != 0)
	XPutPixel(img, j, i, XBlackPixel(x_disp,0));
      else
	XPutPixel(img, j, i, XWhitePixel(x_disp,0));
  XPutImage(x_disp, x_win, x_gc_win, img, 0, 0, x, y, w, h);
  XDestroyImage(img);
}

void  DEV_put_bitmap(DVI_DEVICE d, DVI v, DVI_BITMAP bm, int i, 
		     long k, long cp, long x, long y)
{
  DVI_fb_put_bitmap(fb, bm, x + x_ofsx, y + x_ofsy);
  x_draw_fb(x + x_ofsx, y + x_ofsy, bm->width, bm->height);
}

void  DEV_put_rectangle(DVI_DEVICE d, DVI v, long x, long y, long w, long h)
{
  DVI_fb_put_rectangle(fb, x + x_ofsx, y + x_ofsy, w, h);
  x_draw_fb(x + x_ofsx, y + x_ofsy, w, h);
}

int  main(int argc, char **argv)
{
  char params[1024];

  if (argc < 2){
    printf("spwx11 - the Simplest Previewer in the World for TeX DVI files\n");
    printf("Usage: spwx11 DVI-FILE\n");
    exit(0);
  }
  x_w = PAPER_W * DEFAULT_DPI / DEFAULT_SHRINK;
  x_h = PAPER_H * DEFAULT_DPI / DEFAULT_SHRINK;
  x_ofsx = DEFAULT_OFFSET_X * DEFAULT_DPI / DEFAULT_SHRINK;
  x_ofsy = DEFAULT_OFFSET_Y * DEFAULT_DPI / DEFAULT_SHRINK;
  if ((fb = DVI_fb_create((long)x_w, (long)x_h)) == NULL)
    EXIT1("No memory.\n");
  DVI_fb_clear(fb);

  if ((x_disp = XOpenDisplay(NULL)) == NULL)
    EXIT1("Can't open X display...\n");
  x_win = XCreateSimpleWindow(x_disp, RootWindow(x_disp, 0), 0, 0, x_w, x_h, 2,
			      XWhitePixel(x_disp,0), XWhitePixel(x_disp,0));
  XSelectInput(x_disp, x_win, (KeyPressMask|ExposureMask));
  XStoreName(x_disp, x_win, "The Simplest Previewer in the World for X11");
  x_gc_win = XCreateGC(x_disp, x_win, 0, 0);
  XSetForeground(x_disp, x_gc_win, XBlackPixel(x_disp,0));
  XSetBackground(x_disp, x_gc_win, XWhitePixel(x_disp,0));
  XMapWindow(x_disp, x_win);

  sprintf(params, "TeX_DPI=%d, TeX_KPATHSEA_MODE=%s, TeX_KPATHSEA_PROGRAM=%s",
	  DEFAULT_DPI, DEFAULT_KPATHSEA_MODE, "spwx11");
  if (DVI_INIT(DEFAULT_VFLIBCAP, params) < 0)
    EXIT1("Cannot initialize DVIlib.\n");
  if ((dev = DVI_DEVICE_ALLOC()) == NULL)
    EXIT1("Cannot initialize device.\n");
  dev->h_dpi = dev->v_dpi   = DEFAULT_DPI;
  dev->put_rectangle        = DEV_put_rectangle;
  dev->put_bitmap           = DEV_put_bitmap;
  if ((dvi = DVI_CREATE(dev, argv[1], NULL)) == NULL)
    EXIT2("Can't open DVI file: %s\n", argv[1]);
  if (DVI_OPEN_FONT(dvi, dev) < 0)
    EXIT1("Cannot find all fonts.\n");

  main_loop(dev, dvi);

  return 0;
}
