/*  XGDVI
 *  Copyright (C) 1999  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#ifdef HAVE_MALLOC_H
#  include <malloc.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include <dvi-2_6.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "defs.h"
#include "xgdvi.h"
#include "gui.h"
#include "state.h"


static  GtkWidget *PageList       = NULL;
static  GtkWidget *PageListScroll = NULL;


void
on_Exit_clicked                        (GtkButton       *button,
                                        gpointer         user_data);
void
on_Reload_clicked                      (GtkButton       *button,
                                        gpointer         user_data);
void
on_ZoomIn_clicked                      (GtkButton       *button,
                                        gpointer         user_data);
void
on_ZoomOut_clicked                     (GtkButton       *button,
                                        gpointer         user_data);
void
on_Scroll_clicked                      (GtkButton       *button,
                                        gpointer         user_data);
void
on_GotoPage_clicked                    (GtkButton       *button,
                                        gpointer         user_data);
void
on_JumpToPage_clicked                  (GtkButton       *button,
                                        gpointer         user_data);
void
on_PageList_clicked                    (GtkWidget *widget,
					gint row, 
					gint column, 
					GdkEventButton *ev,
					gpointer user_data);


gint
event_key_press(GtkWidget *w, GdkEventKey *ev);






GtkWidget*
create_xgdvi ()
{
  GtkWidget *vbox;
  GtkWidget *Buffer;
  GtkWidget *File;
  GtkWidget *Print;
  GtkWidget *Paper;
  GtkWidget *License;
  GtkWidget *Exit;
  GtkWidget *Box;
  GtkWidget *hbox0;
  GtkWidget *hbox1;
  GtkWidget *vbox2;
  GtkWidget *hsep;
  GtkWidget *Reload;
  GtkWidget *ZoomIn;
  GtkWidget *ZoomOut;
  GtkWidget *ScrUp;
  GtkWidget *ScrDown;
  GtkWidget *ScrLeft;
  GtkWidget *ScrRight;
  GtkWidget *ScrCenter;
  GtkWidget *PrevPage;
  GtkWidget *NextPage;
  GtkWidget *FirstPage;
  GtkWidget *LastPage;
  GtkWidget *JumpToPage;
  GtkWidget *ScrolledWindow;
  GtkWidget *DrawingArea;
  GtkWidget *StatusBar;
  static char *titles[2];
  int    no_focus;

  no_focus = 1;

  xgdvi = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (xgdvi), "xgdvi", xgdvi);
  gtk_window_set_title (GTK_WINDOW (xgdvi), _("xgdvi"));
  gtk_window_set_policy (GTK_WINDOW (xgdvi), TRUE, TRUE, FALSE);
  gtk_widget_set_events(xgdvi, GDK_EXPOSURE_MASK|GDK_KEY_PRESS_MASK);
  gtk_signal_connect(GTK_OBJECT(xgdvi), "configure_event",
		     (GtkSignalFunc)event_configure_win, NULL);
  gtk_signal_connect(GTK_OBJECT(xgdvi), "key_press_event", 
		     GTK_SIGNAL_FUNC(event_key_press), NULL);
  gtk_signal_connect(GTK_OBJECT(xgdvi), "destroy", 
		     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
  gtk_window_set_default_size(GTK_WINDOW(xgdvi), 
			      param_win_size_w, param_win_size_h);
  gtk_window_set_policy(GTK_WINDOW(xgdvi), 1, 1, 1);

  vbox = gtk_vbox_new (FALSE, 3);
  gtk_widget_show (vbox);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 3);
  gtk_container_add (GTK_CONTAINER (xgdvi), vbox);

  if ((param_gui_type == 1) || (param_gui_type == 2)){
    hbox0 = NULL;
  } else {
    hbox0 = gtk_hbox_new(FALSE, 0);
    gtk_widget_show (hbox0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  } 

  hbox1 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox), hbox1, TRUE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, FALSE, FALSE, 3);

  if ((param_gui_type == 1) || (param_gui_type == 2)){
    Box = vbox2;
  } else {
    Box = hbox0;
  }


  Reload = gtk_button_new_with_label (_("Reload"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(Reload, GTK_CAN_FOCUS);
  gtk_widget_show (Reload);
  gtk_box_pack_start (GTK_BOX (Box), Reload, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (Reload), "clicked",
                      GTK_SIGNAL_FUNC (on_Reload_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), Reload,
		       (gchar*) _("Read and display current DVI file again."),
		       (gchar*) NULL);

  File = gtk_button_new_with_label (_("Open File..."));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(File, GTK_CAN_FOCUS);
  gtk_widget_show (File);
  gtk_box_pack_start (GTK_BOX (Box), File, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (File), "clicked",
                      GTK_SIGNAL_FUNC (on_File_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), File,
		       (gchar*) _("Open a DVI file."),
		       (gchar*) NULL);

  Buffer = gtk_button_new_with_label (_("Buffers..."));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(Buffer, GTK_CAN_FOCUS);
  gtk_widget_show (Buffer);
  gtk_box_pack_start (GTK_BOX (Box), Buffer, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (Buffer), "clicked",
                      GTK_SIGNAL_FUNC (on_Buffer_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), Buffer,
		       (gchar*) _("Select an opened DVI file in buffer."),
		       (gchar*) NULL);

  if ((param_gui_type == 1) || (param_gui_type == 2)){
    hsep = gtk_hseparator_new();
    gtk_widget_show (hsep);
    gtk_box_pack_start (GTK_BOX (Box), hsep, FALSE, TRUE, 5);
  }

  Print = gtk_button_new_with_label (_("Print..."));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(Print, GTK_CAN_FOCUS);
  gtk_widget_show (Print);
  gtk_box_pack_start (GTK_BOX (Box), Print, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (Print), "clicked",
                      GTK_SIGNAL_FUNC (on_Print_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), Print,
		       (gchar*) _("Print a DVI file."),
		       (gchar*) NULL);

  Paper = gtk_button_new_with_label (_("Paper..."));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(Paper, GTK_CAN_FOCUS);
  gtk_widget_show (Paper);
  gtk_box_pack_start (GTK_BOX (Box), Paper, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (Paper), "clicked",
                      GTK_SIGNAL_FUNC (on_Paper_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), Paper,
		       (gchar*) _("Change paper size and orientation."),
		       (gchar*) NULL);

  if ((param_gui_type == 1) || (param_gui_type == 2)){
    hsep = gtk_hseparator_new();
    gtk_widget_show (hsep);
    gtk_box_pack_start (GTK_BOX (Box), hsep, FALSE, TRUE, 5);
  }

  ZoomIn = gtk_button_new_with_label (_("Zoom In"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(ZoomIn, GTK_CAN_FOCUS);
  gtk_widget_show (ZoomIn);
  gtk_box_pack_start (GTK_BOX (Box), ZoomIn, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (ZoomIn), "clicked",
                      GTK_SIGNAL_FUNC (on_ZoomIn_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), ZoomIn,
		       (gchar*) _("Magnify the preview image."),
		       (gchar*) NULL);

  ZoomOut = gtk_button_new_with_label (_("Zoom Out"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(ZoomOut, GTK_CAN_FOCUS);
  gtk_widget_show (ZoomOut);
  gtk_box_pack_start (GTK_BOX (Box), ZoomOut, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (ZoomOut), "clicked",
		      GTK_SIGNAL_FUNC (on_ZoomOut_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), ZoomOut,
		       (gchar*) _("Shrink the preview image."),
		       (gchar*) NULL);

  if ((param_gui_type == 2) || (param_gui_type == 4)){
    if ((param_gui_type == 1) || (param_gui_type == 2)){
      hsep = gtk_hseparator_new();
      gtk_widget_show (hsep);
      gtk_box_pack_start (GTK_BOX (Box), hsep, FALSE, TRUE, 5);
    }

    ScrCenter = gtk_button_new_with_label (_("Center"));
    if (no_focus == 1)
      GTK_WIDGET_UNSET_FLAGS(ScrCenter, GTK_CAN_FOCUS);
    gtk_widget_show (ScrCenter);
    gtk_box_pack_start (GTK_BOX (Box), ScrCenter, FALSE, TRUE, 3);
    gtk_signal_connect (GTK_OBJECT (ScrCenter), "clicked",
			GTK_SIGNAL_FUNC (on_Scroll_clicked), "+"); 
    gtk_tooltips_set_tip(gtk_tooltips_new(), ScrCenter,
			 (gchar*) _("Center the preview window."),
			 (gchar*) NULL);

    ScrLeft = gtk_button_new_with_label (_("Left"));
    if (no_focus == 1)
      GTK_WIDGET_UNSET_FLAGS(ScrLeft, GTK_CAN_FOCUS);
    gtk_widget_show (ScrLeft);
    gtk_box_pack_start (GTK_BOX (Box), ScrLeft, FALSE, TRUE, 3);
    gtk_signal_connect (GTK_OBJECT (ScrLeft), "clicked",
			GTK_SIGNAL_FUNC (on_Scroll_clicked), "<"); 
    gtk_tooltips_set_tip(gtk_tooltips_new(), ScrLeft,
			 (gchar*) _("Scroll the preview window left."),
			 (gchar*) NULL);

    ScrRight = gtk_button_new_with_label (_("Right"));
    if (no_focus == 1)
      GTK_WIDGET_UNSET_FLAGS(ScrRight, GTK_CAN_FOCUS);
    gtk_widget_show (ScrRight);
    gtk_box_pack_start (GTK_BOX (Box), ScrRight, FALSE, TRUE, 3);
    gtk_signal_connect (GTK_OBJECT (ScrRight), "clicked",
			GTK_SIGNAL_FUNC (on_Scroll_clicked), ">"); 
    gtk_tooltips_set_tip(gtk_tooltips_new(), ScrRight,
			 (gchar*) _("Scroll the preview window right."),
			 (gchar*) NULL);

    ScrUp = gtk_button_new_with_label (_("Up"));
    if (no_focus == 1)
      GTK_WIDGET_UNSET_FLAGS(ScrUp, GTK_CAN_FOCUS);
    gtk_widget_show (ScrUp);
    gtk_box_pack_start (GTK_BOX (Box), ScrUp, FALSE, TRUE, 3);
    gtk_signal_connect (GTK_OBJECT (ScrUp), "clicked",
			GTK_SIGNAL_FUNC (on_Scroll_clicked), "^"); 
    gtk_tooltips_set_tip(gtk_tooltips_new(), ScrUp,
			 (gchar*) _("Scroll the preview window up."),
			 (gchar*) NULL);

    ScrDown = gtk_button_new_with_label (_("Down"));
    if (no_focus == 1)
      GTK_WIDGET_UNSET_FLAGS(ScrDown, GTK_CAN_FOCUS);
    gtk_widget_show (ScrDown);
    gtk_box_pack_start (GTK_BOX (Box), ScrDown, FALSE, TRUE, 3);
    gtk_signal_connect (GTK_OBJECT (ScrDown), "clicked",
			GTK_SIGNAL_FUNC (on_Scroll_clicked), "v"); 
    gtk_tooltips_set_tip(gtk_tooltips_new(), ScrDown,
			 (gchar*) _("Scroll the preview window down."),
			 (gchar*) NULL);
  }

  if ((param_gui_type == 1) || (param_gui_type == 2)){
    hsep = gtk_hseparator_new();
    gtk_widget_show (hsep);
    gtk_box_pack_start (GTK_BOX (vbox2), hsep, FALSE, TRUE, 5);
  }

  FirstPage = gtk_button_new_with_label (_("First Page"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(FirstPage, GTK_CAN_FOCUS);
  gtk_widget_show (FirstPage);
  gtk_box_pack_start (GTK_BOX (vbox2), FirstPage, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (FirstPage), "clicked",
                      GTK_SIGNAL_FUNC (on_GotoPage_clicked), "<"); 
  gtk_tooltips_set_tip(gtk_tooltips_new(), FirstPage,
		       (gchar*) _("Go to the first page of the document."),
		       (gchar*) NULL);

  PrevPage = gtk_button_new_with_label (_("Prev Page"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(PrevPage, GTK_CAN_FOCUS);
  gtk_widget_show (PrevPage);
  gtk_box_pack_start (GTK_BOX (vbox2), PrevPage, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (PrevPage), "clicked",
                      GTK_SIGNAL_FUNC (on_GotoPage_clicked), "b"); 
  gtk_tooltips_set_tip(gtk_tooltips_new(), PrevPage,
		       (gchar*) _("Go to the previous page of the document."),
		       (gchar*) NULL);

  NextPage = gtk_button_new_with_label (_("Next Page"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(NextPage, GTK_CAN_FOCUS);
  gtk_widget_show (NextPage);
  gtk_box_pack_start (GTK_BOX (vbox2), NextPage, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (NextPage), "clicked",
                      GTK_SIGNAL_FUNC (on_GotoPage_clicked), " "); 
  gtk_tooltips_set_tip(gtk_tooltips_new(), NextPage,
		       (gchar*) _("Go to the next page of the document."),
		       (gchar*) NULL);

  LastPage = gtk_button_new_with_label (_("Last Page"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(LastPage, GTK_CAN_FOCUS);
  gtk_widget_show (LastPage);
  gtk_box_pack_start (GTK_BOX (vbox2), LastPage, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (LastPage), "clicked",
                      GTK_SIGNAL_FUNC (on_GotoPage_clicked), ">"); 
  gtk_tooltips_set_tip(gtk_tooltips_new(), LastPage,
		       (gchar*) _("Go to the last page of the document."),
		       (gchar*) NULL);

  hsep = gtk_hseparator_new();
  gtk_widget_show (hsep);
  gtk_box_pack_start (GTK_BOX (vbox2), hsep, FALSE, TRUE, 5);

  JumpToPage = gtk_button_new_with_label (_("Go"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(JumpToPage, GTK_CAN_FOCUS);
  gtk_widget_show (JumpToPage);
  gtk_box_pack_start (GTK_BOX (vbox2), JumpToPage, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (JumpToPage), "clicked",
                      GTK_SIGNAL_FUNC (on_JumpToPage_clicked), NULL); 
  gtk_tooltips_set_tip(gtk_tooltips_new(), JumpToPage,
		       (gchar*) _("Go to the selected page of the document."),
		       (gchar*) NULL);

  titles[0] = _("Pages");
  titles[1] = NULL;
  PageList = gtk_clist_new_with_titles (1, titles);
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(PageList, GTK_CAN_FOCUS);
  gtk_widget_show (PageList);
  gtk_clist_column_titles_passive (GTK_CLIST (PageList));
  gtk_clist_column_titles_hide (GTK_CLIST(PageList));
  gtk_clist_set_selection_mode (GTK_CLIST (PageList), GTK_SELECTION_SINGLE);
  gtk_clist_set_reorderable (GTK_CLIST(PageList), FALSE);
  gtk_signal_connect (GTK_OBJECT (PageList), "select_row",
		      GTK_SIGNAL_FUNC(on_PageList_clicked), NULL);

  PageListScroll = gtk_scrolled_window_new 
    ( gtk_clist_get_hadjustment(GTK_CLIST(PageList)),
      gtk_clist_get_vadjustment(GTK_CLIST(PageList)));
  gtk_widget_show (PageListScroll);
  gtk_box_pack_start (GTK_BOX (vbox2), PageListScroll, TRUE, TRUE, 0);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (PageListScroll),
					 PageList);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (PageListScroll),
				  GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_placement (GTK_SCROLLED_WINDOW (PageListScroll),
				     GTK_CORNER_BOTTOM_RIGHT);
  gtk_object_set_data (GTK_OBJECT (xgdvi), "PageListScroll", PageListScroll);
  gtk_tooltips_set_tip(gtk_tooltips_new(), PageListScroll,
    (gchar*) _("Jump to an arbitrary page in the document."),
    (gchar*) NULL);

  hsep = gtk_hseparator_new();
  gtk_widget_show (hsep);
  gtk_box_pack_start (GTK_BOX (vbox2), hsep, FALSE, TRUE, 5);

  License = gtk_button_new_with_label (_("License..."));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(License, GTK_CAN_FOCUS);
  gtk_widget_show (License);
  gtk_box_pack_start (GTK_BOX (vbox2), License, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (License), "clicked",
                      GTK_SIGNAL_FUNC (on_License_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), License,
    (gchar*) _("Display copyright notice of this software."),
    (gchar*) NULL);

  Exit = gtk_button_new_with_label (_("Exit"));
  if (no_focus == 1)
    GTK_WIDGET_UNSET_FLAGS(Exit, GTK_CAN_FOCUS);
  gtk_widget_show (Exit);
  gtk_box_pack_start (GTK_BOX (vbox2), Exit, FALSE, TRUE, 3);
  gtk_signal_connect (GTK_OBJECT (Exit), "clicked",
                      GTK_SIGNAL_FUNC (on_Exit_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), Exit,
		       (gchar*) _("Finish xgdvi."),
		       (gchar*) NULL);

  
  ScrolledWindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (ScrolledWindow);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ScrolledWindow),
				  GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  gtk_scrolled_window_set_placement (GTK_SCROLLED_WINDOW (ScrolledWindow),
				     GTK_CORNER_BOTTOM_RIGHT);
  gtk_box_pack_start (GTK_BOX (hbox1), ScrolledWindow, TRUE, TRUE, 0);
  gtk_object_set_data (GTK_OBJECT (xgdvi), "ScrolledWindow", ScrolledWindow);

  DrawingArea = gtk_drawing_area_new ();
  gtk_object_set_data (GTK_OBJECT (xgdvi), "DrawingArea", DrawingArea);
  gtk_widget_show (DrawingArea);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (ScrolledWindow),
					 DrawingArea);
  gtk_drawing_area_size(GTK_DRAWING_AREA(DrawingArea), paper_aa_w, paper_aa_h);
  gtk_widget_set_events (DrawingArea, 
			 GDK_EXPOSURE_MASK 
			 | GDK_POINTER_MOTION_MASK 
			 | GDK_POINTER_MOTION_HINT_MASK 
			 | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

  gtk_signal_connect(GTK_OBJECT(DrawingArea), "configure_event",
		     (GtkSignalFunc)event_configure, NULL);
  gtk_signal_connect(GTK_OBJECT(DrawingArea), "expose_event",
		     GTK_SIGNAL_FUNC(event_expose), NULL);

  gtk_signal_connect(GTK_OBJECT(DrawingArea), "button_press_event",
		     GTK_SIGNAL_FUNC(event_button_press), NULL);
  gtk_signal_connect(GTK_OBJECT(DrawingArea), "button_release_event",
		     GTK_SIGNAL_FUNC(event_button_release), NULL);
  gtk_signal_connect(GTK_OBJECT(DrawingArea), "motion_notify_event",
		     GTK_SIGNAL_FUNC(event_motion_notify), NULL);

  StatusBar = gtk_statusbar_new ();
  gtk_object_set_data (GTK_OBJECT (xgdvi), "StatusBar", StatusBar);
  gtk_widget_show (StatusBar);
  gtk_box_pack_start (GTK_BOX (vbox), StatusBar, FALSE, TRUE, 0);

  return xgdvi;
}


gint
event_key_press(GtkWidget *w, GdkEventKey *ev)
{
  char cmd;

  if (ev->length > 1)
    return TRUE;

  if (ev->length == 0){
    switch(ev->keyval){
    default:  return TRUE;
    case GDK_Left:       cmd = CTL('B'); break;
    case GDK_Right:      cmd = CTL('F'); break;
    case GDK_Up:         cmd = CTL('P'); break;
    case GDK_Down:       cmd = CTL('N'); break;
    case GDK_Page_Up:    cmd = 'v';      break;
    case GDK_Page_Down:  cmd = CTL('V'); break;
    case GDK_Home:       cmd = '<';      break;
    case GDK_End:        cmd = '>';      break;
    }
  } else if (ev->length == 1){
    cmd = ev->string[0];
    switch (cmd){
    case 'q':
      return TRUE;
    case CTL('Q'):
      cmd = 'q';
    }
  }

  run_command(cmd);

  return TRUE;
}


void
on_Exit_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  run_command('q');
}


void
on_Reload_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  reload_file();
  draw_page();
}


void
on_ZoomIn_clicked                     (GtkButton       *button,
				       gpointer         user_data)
{
  change_window_params(1, shrink * 9.0/10.0, 0);
}


void
on_ZoomOut_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  change_window_params(1, shrink * 10.0/9.0, 0);
}


void
on_Scroll_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
  double  rx, ry;
  char   *cmd;

  if (user_data == NULL)
    return;
  cmd = (char*) user_data;

  if (*cmd == '+'){
    preview_window_set_pos_center(0.5, 0.5);
  } else {
    preview_window_get_pos(&rx, &ry);
    switch (*cmd){
    case '<':  if ((rx -= 0.05) < 0.0)  rx = 0.0;    break;
    case '>':  if ((rx += 0.05) > 1.0)  rx = 1.0;    break;
    case '^':  if ((ry -= 0.05) < 0.0)  ry = 0.0;    break;
    case 'v':  if ((ry += 0.05) > 1.0)  ry = 1.0;    break;
    }
    preview_window_set_pos(rx, ry);
  }
}


void
on_GotoPage_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  char *cmd;

  if (user_data == NULL)
    return;
  cmd = (char*) user_data;
  run_command(*cmd);
}


void
on_JumpToPage_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList  *clist; 
  int row;

  clist = GTK_CLIST (PageList);
  if (clist->selection != NULL) {
    row = GPOINTER_TO_INT (clist->selection->data);
    goto_page(row + 1);
    if (ui_cmd == CMD_DRAW_PAGE){
      draw_page();
    }
  }
}

void
on_PageList_clicked                     (GtkWidget *widget,
					 gint row, 
					 gint column, 
					 GdkEventButton *ev,
					 gpointer user_data)
{
  if ((ev != NULL) && 
      ((ev->type == GDK_BUTTON_PRESS) || (ev->type == GDK_2BUTTON_PRESS))){
    goto_page(row + 1);
    if (ui_cmd == CMD_DRAW_PAGE){
      draw_page();
    }
  }
}




void
update_page_list(void)
{
  char  s[256], *p[2];
  int   i, nitems;

  p[0] = s;
  p[1] = NULL;
  nitems = (dvi == NULL) ? 0 : dvi->pages;

  gtk_clist_freeze(GTK_CLIST(PageList));
  gtk_clist_clear(GTK_CLIST(PageList));
  for (i = 0; i < nitems; i++){
    sprintf(s, "%ld", dvi->page_no[i].c[0]);
    gtk_clist_append (GTK_CLIST (PageList), p);
  }
  gtk_clist_thaw(GTK_CLIST(PageList));
}


void
update_page_display(void)
{
  GtkAdjustment *vadj;
  double         p, p1, p2, v, v1, v2;

  if (dvi == NULL)
    return;

  vadj = gtk_scrolled_window_get_vadjustment
    (GTK_SCROLLED_WINDOW(PageListScroll));
  p = (double)page / (double)dvi->pages; 
  p1 = ((double) page - 2) / (double)dvi->pages; 
  p2 = ((double) page + 2) / (double)dvi->pages; 
  v1 =  vadj->value                    / (vadj->upper - vadj->lower);
  v2 = (vadj->value + vadj->page_size) / (vadj->upper - vadj->lower);
  if ((p1 <= v1) || (v2 <= p2)){
    if (p1 <= v1){
      p = ((double) page - 2) / (double)dvi->pages; 
      v = p * (vadj->upper - vadj->lower) + vadj->lower;
    } else {
      p = ((double) page + 1) / (double)dvi->pages; 
      v = p * (vadj->upper - vadj->lower) + vadj->lower - vadj->page_size;
    }
    if (v < vadj->lower)
      v = vadj->lower;
    if (vadj->upper - vadj->page_size < v)
      v = vadj->upper - vadj->page_size;
    vadj->value = v;
    gtk_adjustment_value_changed(vadj);
    gtk_widget_draw(PageListScroll, NULL);
  }

  gtk_clist_select_row(GTK_CLIST(PageList), page-1, -1);
}
