/*
 * misc.c - misc procedures for xldvi
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */
#include "../config.h"
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/param.h>

#include "dvi-2_6.h"
#include "cf-xldvi.h"
#include "defs.h"
#include "paper.h"
#include "resource.h"


Public char*
find_dvi_file(char *name)
{
  int  name_len;
  char *path;
  
  if (name == NULL)
    return NULL;

  if (access(name, R_OK) >= 0){
    if ((path = (char*)malloc(strlen(name) + 1)) == NULL){
      DEV_message_fatal(dev, dviobj, "No meomry");
      return NULL;
    }
    strcpy(path, name);
    return path;
  }

  name_len = strlen(name);
  if ((name_len > strlen(".dvi")) 
      && (strcmp(name+name_len-strlen(".dvi"), ".dvi") == 0)){
    return NULL;
  }
  if ((path = (char*)malloc(name_len+strlen(".dvi")+1)) == NULL){
    DEV_message_fatal(dev, dviobj, "No memory");
    return NULL;
  }
  sprintf(path, "%s%s", name, ".dvi");
  if (access(path, R_OK) < 0){
    free(path);
    return NULL;
  }
  return path;
}

Public int
paper_sym2id(char *sym, char *orientation)
{
  int  paper;

  paper = -1;
  if (strcmp(sym, "B7") == 0){
    paper = B7_PAPER;
  } else if (strcmp(sym, "B6") == 0){
    paper = B6_PAPER;
  } else if (strcmp(sym, "B5") == 0){
    paper = B5_PAPER;
  } else if (strcmp(sym, "B4") == 0){
    paper = B4_PAPER;
  } else if (strcmp(sym, "B3") == 0){
    paper = B3_PAPER;
  } else if (strcmp(sym, "B2") == 0){
    paper = B2_PAPER;
  } else if (strcmp(sym, "B1") == 0){
    paper = B1_PAPER;
  } else if (strcmp(sym, "A7") == 0){
    paper = A7_PAPER;
  } else if (strcmp(sym, "A6") == 0){
    paper = A6_PAPER;
  } else if (strcmp(sym, "A5") == 0){
    paper = A5_PAPER;
  } else if (strcmp(sym, "A4") == 0){
    paper = A4_PAPER;
  } else if (strcmp(sym, "A3") == 0){
    paper = A3_PAPER;
  } else if (strcmp(sym, "A2") == 0){
    paper = A2_PAPER;
  } else if (strcmp(sym, "A1") == 0){
    paper = A1_PAPER;
  } else if (strcmp(sym, "LETTER") == 0){
    paper = LETTER_PAPER;
  } else if (strcmp(sym, "US") == 0){
    paper = US_PAPER;
  } else if (strcmp(sym, "LEGAL") == 0){
    paper = LEGAL_PAPER;
  } 
  if (paper == -1)
    return -1;

  if ((orientation != NULL)
      && (   (strcmp(orientation, "landscape") == 0)
	  || (strcmp(orientation, "Landscape") == 0)
	  || (strcmp(orientation, "LANDSCAPE") == 0)))
    paper = LANDSCAPE_PAPER(paper);

  return paper;
}

Public void
paper_size(int paper, unsigned int *wp, unsigned int *hp)
{
  double  w, h;
RETRY:
  switch(paper){
  case A1_PAPER:   w = A1_WIDTH;  h = A1_HEIGHT; break;
  case A1L_PAPER:  w = A1_HEIGHT; h = A1_WIDTH;  break;
  case A2_PAPER:   w = A2_WIDTH;  h = A2_HEIGHT; break;
  case A2L_PAPER:  w = A2_HEIGHT; h = A2_WIDTH;  break;
  case A3_PAPER:   w = A3_WIDTH;  h = A3_HEIGHT; break;
  case A3L_PAPER:  w = A3_HEIGHT; h = A3_WIDTH;  break;
  case A4_PAPER:   w = A4_WIDTH;  h = A4_HEIGHT; break;
  case A4L_PAPER:  w = A4_HEIGHT; h = A4_WIDTH;  break;
  case A5_PAPER:   w = A5_WIDTH;  h = A5_HEIGHT; break;
  case A5L_PAPER:  w = A5_HEIGHT; h = A5_WIDTH;  break;
  case A6_PAPER:   w = A6_WIDTH;  h = A6_HEIGHT; break;
  case A6L_PAPER:  w = A6_HEIGHT; h = A6_WIDTH;  break;
  case A7_PAPER:   w = A7_WIDTH;  h = A7_HEIGHT; break;
  case A7L_PAPER:  w = A7_HEIGHT; h = A7_WIDTH;  break;
  case B1_PAPER:   w = B1_WIDTH;  h = B1_HEIGHT; break;
  case B1L_PAPER:  w = B1_HEIGHT; h = B1_WIDTH;  break;
  case B2_PAPER:   w = B2_WIDTH;  h = B2_HEIGHT; break;
  case B2L_PAPER:  w = B2_HEIGHT; h = B2_WIDTH;  break;
  case B3_PAPER:   w = B3_WIDTH;  h = B3_HEIGHT; break;
  case B3L_PAPER:  w = B3_HEIGHT; h = B3_WIDTH;  break;
  case B4_PAPER:   w = B4_WIDTH;  h = B4_HEIGHT; break;
  case B4L_PAPER:  w = B4_HEIGHT; h = B4_WIDTH;  break;
  case B5_PAPER:   w = B5_WIDTH;  h = B5_HEIGHT; break;
  case B5L_PAPER:  w = B5_HEIGHT; h = B5_WIDTH;  break;
  case B6_PAPER:   w = B6_WIDTH;  h = B6_HEIGHT; break;
  case B6L_PAPER:  w = B6_HEIGHT; h = B6_WIDTH;  break;
  case B7_PAPER:   w = B7_WIDTH;  h = B7_HEIGHT; break;
  case B7L_PAPER:  w = B7_HEIGHT; h = B7_WIDTH;  break;
  case LETTER_PAPER:  w = LETTER_WIDTH;  h = LETTER_HEIGHT; break;
  case LETTERL_PAPER: w = LETTER_HEIGHT; h = LETTER_WIDTH;  break;
  case LEGAL_PAPER:   w = LEGAL_WIDTH;   h = LEGAL_HEIGHT;  break;
  case LEGALL_PAPER:  w = LEGAL_HEIGHT;  h = LEGAL_WIDTH;   break;
  case US_PAPER:      w = US_WIDTH;      h = US_HEIGHT;     break;
  case USL_PAPER:     w = US_HEIGHT;     h = US_WIDTH;      break;
  default:
    DEV_message_advice(dev, dviobj, "Unknown paper size. Use A4 paper.");
    paper = A4_PAPER;
    goto RETRY;
  }
  *wp = w*Resource.dpi/shrink;
  *hp = h*Resource.dpi/shrink;
}


Public Bool
atob(char *s)
{
  if (   (strcmp(s, "true") == 0)
      || (strcmp(s, "True") == 0)
      || (strcmp(s, "TRUE") == 0)
      || (strcmp(s, "yes") == 0) 
      || (strcmp(s, "Yes") == 0)
      || (strcmp(s, "YES") == 0)
      || (strcmp(s, "ok") == 0)
      || (strcmp(s, "Ok") == 0)
      || (strcmp(s, "OK") == 0)
      || (strcmp(s, "1") == 0)   )
    return TRUE;
  return FALSE;
}


/*EOF*/
