/*
 * ui-file.c - a module for file selection UI
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif
#ifdef HAVE_STRING_H
# include <string.h>
#endif
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif
#include <sys/param.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>

#include "cf-xmdvi.h"
#include "dvi-2_6.h"
#include "defs.h"
#include "resource.h"
#include "window.h"
#include "ui.h"

Private Widget  dialog_file_selection; 
Private Widget  box_file_selection;


Private void  cb_file_openfile(Widget,caddr_t, 
			       XmFileSelectionBoxCallbackStruct*);
Private void  cb_file_home_dir(Widget,caddr_t,caddr_t);

#if HAVE_GETCWD
#else
# if HAVE_GETWD
#  define getcwd(s,n)  getwd(s)
# else
#  define getcwd(s,n)  NULL
# endif
#endif

#if HAVE_RINDEX
#else
#  define rindex(s,c)  strrchr(s,c)
#endif

Public Widget
x_make_panel_file(Widget parent)
{
  Widget  xfm, xtitle, xb_close, xsep1;
  Widget  xfs, xb_help;
  char    filedir[MAXPATHLEN], cdir[MAXPATHLEN], direc[MAXPATHLEN];
  char    dvi_extention[32], *p;
  Arg     args[10];
  int     i;

  i = 0;
  XtSetArg(args[i], XmNdialogStyle, XmDIALOG_MODELESS); i++;
  dialog_file_selection 
    = XmCreateBulletinBoardDialog(parent, "DVI File Selection", args, i);
  
  xfm = XmCreateForm(dialog_file_selection, "fileSelect", NULL, 0);
  XtManageChild(xfm);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("File Selection", XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  xtitle = XmCreateLabel(xfm, "title", args, i);
  XtManageChild(xtitle);
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Close", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_NONE);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  xb_close  = XmCreatePushButton(xfm, "close", args, i);
  XtAddCallback(xb_close, XmNactivateCallback, 
		(XtCallbackProc)cb_file_close, NULL);
  XtManageChild(xb_close);

  xsep1 = x_p_make_hsep(xfm);
  x_p_put_below(xsep1, xtitle);
  x_p_put_below(xsep1, xb_close);

  if (DviFileNameNew != NULL){
    strcpy(filedir, DviFileNameNew);
    /**printf("*1 %s\n", filedir);**/
    if ((p = rindex(filedir, '/')) != NULL)
      *p = '\0';
    /**printf("*2 %s\n", filedir);**/
    if (strcmp(filedir, "") == 0){
      strcpy(direc, "/"); 
    } else if (strncmp(filedir, "/", strlen("/")) == 0){
      strncpy(direc, filedir, sizeof(direc));
    } else {
      if ((p = getenv("PWD")) != NULL)
	strcpy(cdir, p);
      else if (getcwd(cdir, sizeof(cdir)) == NULL)
	strcpy(cdir, ".");
      sprintf(direc, "%s%c%s", cdir, '/', filedir);
    }
    /**printf("*3 %s\n", direc);**/
  } else {
    if ((p = getenv("PWD")) != NULL)
      strcpy(direc, p);
    else if (getcwd(direc, sizeof(direc)) == NULL)
      strcpy(direc, "/");
  }
  /**printf("*4 %s\n", direc);**/

  i = 0;
  XtSetArg(args[i], XmNdirectory, 
	   XmStringCreate(direc, XmSTRING_DEFAULT_CHARSET)); i++;
  sprintf(dvi_extention, "*%s", DVI_FILE_EXTENSION);
  XtSetArg(args[i], XmNdirMask, 
	   XmStringCreate(dvi_extention, XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNselectionLabelString, 
	   XmStringCreate("DVI File Selection",
			  XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNlistLabelString, 
	   XmStringCreate("DVI Files", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNokLabelString, 
	   XmStringCreate("Open the File", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNapplyLabelString, 
	   XmStringCreate("Scan Files", 
			  XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNhelpLabelString, 
	   XmStringCreate("Home Directory", XmSTRING_DEFAULT_CHARSET)); i++;
  xfs = XmCreateFileSelectionBox(xfm, "fileSelection", args, i);
  XtManageChild(xfs);
  XtUnmanageChild(XmFileSelectionBoxGetChild(xfs, XmDIALOG_FILTER_TEXT));
  XtUnmanageChild(XmFileSelectionBoxGetChild(xfs, XmDIALOG_FILTER_LABEL));
  XtUnmanageChild(XmFileSelectionBoxGetChild(xfs, XmDIALOG_CANCEL_BUTTON));
  XtAddCallback(xfs, XmNokCallback, (XtCallbackProc)cb_file_openfile, NULL);
  xb_help = XmFileSelectionBoxGetChild(xfs, XmDIALOG_HELP_BUTTON);

  x_p_put_below(xfs, xsep1);
  box_file_selection = xfs;

  XtAddCallback(xb_help, XmNhelpCallback, 
		(XtCallbackProc)cb_file_home_dir, NULL);

  return dialog_file_selection;
}

Public void
cb_file(Widget w, caddr_t d1,caddr_t d2)
{
  cmd_find_file();
}

Public void
cmd_find_file(void)
{
  if (DviDisableCommand == 1)
    ; /* no return */

  XmFileSelectionDoSearch(box_file_selection, NULL);
  if (XtIsManaged(dialog_file_selection)){
    XtUnmanageChild(dialog_file_selection);
  } else {
    ui_close_panel_all();
    XtManageChild(dialog_file_selection);
  }
}

Public void
cb_file_close(Widget w, caddr_t d1, caddr_t d2)
{
  if (XtIsManaged(dialog_file_selection))
    XtUnmanageChild(dialog_file_selection);
}

Private void
cb_file_home_dir(Widget w, caddr_t d1, caddr_t d2)
{
  char     *home;
  XmString str;
  Arg      args[5];
  int      i;

  if ((home = getenv("HOME")) != NULL){
    str = XmStringCreate(home, XmSTRING_DEFAULT_CHARSET);
    i = 0;
    XtSetArg(args[i], XmNdirectory, str); i++;
    XtSetValues(box_file_selection, args, i);
    XmFileSelectionDoSearch(box_file_selection, NULL);
    XmStringFree(str);
  }
}

Private void
cb_file_openfile(Widget w, caddr_t d1, XmFileSelectionBoxCallbackStruct *d)
{
  char  *s;

  if (XmStringGetLtoR(d->value, XmSTRING_DEFAULT_CHARSET, &s) != True){
    x_bell();
    return;
  }
  if ((DviFileNameNew = malloc(strlen(s)+1)) == NULL){
    fprintf(stderr, "No memory.\n");
    exit(1);
  }
  strcpy(DviFileNameNew, s);
  x_ui_command = UI_CMD_LOAD;
}


Public void
cb_reload(Widget w, caddr_t d1, caddr_t d2)
{
  cmd_reload();
}

Public void
cmd_reload(void)
{
  if (DviDisableCommand == 1)
    return;
  if (DviFileName == NULL){
    x_bell();
    return;
  }

  if (DviFileNameNew != NULL){
    fprintf(stderr, "%s: DviFileNameNew != NULL in ui-file.c\n", 
	    "XMDVI Internal Error");
    exit(1);
  }
  if ((DviFileNameNew = malloc(strlen(DviFileName)+1)) == NULL){
    fprintf(stderr, "No memory.\n");
    exit(1);
  }
  strcpy(DviFileNameNew, DviFileName);
  x_ui_command = UI_CMD_RELOAD;
}

