% context pattern file, see lang-all.xml for original comment

% source of data: czhyphen.tex czhyphen.ex

% begin description data

% <!-- copied from lang-all.xml
% 
% <?xml version='1.0' standalone='yes'?>
% 
% <description language='cz'>
%     <sourcefile>czhyphen.tex</sourcefile>
%     <title>TeX hyphenation patterns for the Czech language</title>
%     <copyright>
%         <year>1991</year>
%         <owner>Karel Horak</owner>
%         <comment>List of exceptions</comment>
%     </copyright>
%     <copyright>
%         <year>1995</year>
%         <owner>Pavel Sevecek (\v{S}eve\v{c}ek) (pavel@lingea.cz)</owner>
%         <comment>Macros, adaption for TeX 2</comment>
%     </copyright>
%     <!-- samples>
%         <sample>au-to-ma-tic-k</sample>
%         <sample>bram-bo-rk</sample>
%         <sample>da-ta-b-ze</sample>
%         <sample>kr-ka-vec</sample>
%         <sample>Kro-me-r</sample>
%         <sample>ob-hos-po-da-ro-vat</sample>
%         <sample>rem-dich</sample>
%         <sample>scvrk-nout</sample>
%         <sample>za-les-nit</sample>
%         <sample>e-u-lic-ka</sample>
%     </samples -->
% </description>
% 
% end of copy -->

% end description data

% begin pattern data

\patterns {
.a2
.a4da
.a4de
.a4di
.a4do
.a4d[eacute]
.a4kl
.a4ko
.a4kr
.a4ku
.ale3x
.a4ra
.a4re
.a4ri
.a4ro
.a4ry
.a4r[aacute]
.a4sa
.a4se
.a4so
.as3t3
.a4sy
.a4ta
.a4te
.at3l
.a4to
.a4tr
.a4ty
.a4ve
.b2
.c2
.ch2
.cyk3
.d2
.dez3
.d4na
.dne4
.dne[scaron]4k
.d4ny
.dos4
.d4ve
.d4v[ecaron]
.d4v[iacute]
.e2
.e4ch
.e4ko
.es3k
.es3t
.e4ve
.f4ri
.g2
.h2
.h4le
.h4ne
.i2
.i4na
.i4ni
.i4no
.is3l
.j2
.j4ak
.je4dl
.j4se
.j4zd
.j[aacute]d4
.k2
.k4li
.k4ly
.k[rcaron][iacute]3d
.l2
.le4gr
.li3kv
.m2
.mi3st4
.moud3
.na3[ccaron]4
.ne3c
.ne[ccaron]4
.ne3[scaron]
.ni2t
.no4s3t
.n4vp
.n[aacute]1
.n[aacute][rcaron]4k
.o2
.o4b[eacute]
.ode3
.od3l
.od3r[aacute]
.o4ka
.o4ko
.o4na
.o4ne
.o4ni
.o4no
.o4nu
.o4ny
.o4n[ecaron]
.o4n[iacute]
.o4pe
.o4po
.o4se
.o4sl
.os4to
.os3t3r
.os4t[ecaron]
.ot3r[aacute]
.ot3v
.o4t[iacute]
.o4t[rcaron]
.ov[ecaron]4t
.o4za
.oz3do
.o4zi
.o4zo
.o4zu
.o4[scaron]k
.o4[scaron]l
.o4[zcaron]i
.p2
.pa4re
.pa3t[rcaron]
.polk4l
.po3[ccaron]4
.p4ro
.p4r[yacute]
.p4se
.pu3b
.r2
.rej4
.re3s
.ro4k
.roze3
.roz3r
.ru4dl
.s2
.s4ch
.s4ci
.sem4
.se3pn
.s4ke
.sk4l
.s4k[aacute]
.s4le
.s4na
.s4ny
.s4pe
.s4po
.st2
.s4t[aacute]
.s4[zcaron]i
.t2
.u2
.u4ba
.u4be
.u4bi
.u4bo
.u4de
.u4di
.u4do
.u4du
.u4d[iacute]
.uh4n
.uj4m
.u4ko
.u4ku
.ul4h
.u4ma
.u4me
.u4mi
.u4mu
.u4ne
.u4ni
.u4pa
.u4pe
.u4pi
.up4n
.u4po
.u4pu
.u4p[aacute]
.u4p[ecaron]
.u4p[iacute]
.u4ra
.u4ro
.u4r[aacute]
.us2
.u4so
.u4st
.u4sy
.u4s[iacute]
.ut2
.u4vi
.u4ze
.u4[ccaron]e
.u4[ccaron]i
.u4[ccaron][iacute]
.u4[scaron]e
.u4[scaron]i
.u4[scaron]k
.u[scaron]4t
.u4[scaron][iacute]
.u4[zcaron]i
.u[zcaron]4n
.u4[zcaron]o
.u4[zcaron][iacute]
.v2
.va4dl
.v4po
.vy3
.v4z[aacute]
.v[yacute]1
.v4[zcaron]i
.y4or
.y4ve
.z2
.za3
.zao3s
.zar2
.za[ccaron]2
.zd2
.z4di
.z4dr
.z4ky
.z4mn
.z4no
.z4nu
.z4n[ecaron]
.z4n[iacute]
.z4pe
.z4po
.z4t[rcaron]
.z4ve
.z4vi
.[ccaron]2
.[ccaron]4te
.[eacute]2
.[iacute]2
.[oacute]2
.[scaron]2
.[scaron]e3t
.[scaron]4ka
.[scaron]4ke
.[scaron]4ky
.[scaron]4[tcaron]o
.[scaron]4[tcaron][aacute]
.[uacute]2
.[uacute]4d[uring]
.[zcaron]2
a1
2a.
aa3t2
ab3lon
ab4l[yacute]
ab3ri
ab4sb
ab2st
ac4ci
a2d
a3da
a3de
a3di
ad2la
a4dli
a4dl[aacute]
a4dl[eacute]
ad4me
ad4mu
a3do
ado4s
a3d3ra
ad3ri
a3dr[zcaron]
a3du
a4du[zcaron]
3a3dva
ad3vo
a3dy
a3d[aacute]
a3d[eacute]
a3d[ecaron]
a3d[iacute]
ad4[uacute]z
ad4[uacute][rcaron]
a3d[uring]
a3d[yacute]
ae4vi
afi2a
a2g
a3ga
ag4fa
a3go
ag3ro
a3gu
a3g[aacute]
ah4li
ah3v
a2i
a3in
ai4re
a3iv
a2jd
a2jm
aj4me
aj2o
a2k
a3ke
a3ki
a3kl
ak4ni
a3ko
a3kr
a3ku
a3ky
a3k[aacute]
a3k[eacute]
a3k[oacute]
a3k[uring]
a3k[yacute]
al4fb
al4kl
al4tz
al3[zcaron][iacute]
am4bd
am4kl
am4nu
amo3s
am4[zcaron]i
a4nae
a4name
an4dt
ane4sk
aneu4
an4sc
an4sg
an4sl
an4sm
an2sp
an4sv
an4t[ccaron]
an4[zcaron]h
ao4ed
ao4hm
ao4st[rcaron]
ao4t[ccaron]
ap4r.
a4pso
ap3t
a4p[rcaron].
a2r
a3ra
ar4dw
a3re
a4rer
ar4gl
a3ri
ar4kh
a3ro
a4rox
ar3st
a3ru
ar2va
a3ry
a3r[aacute]
a3r[oacute]
ar3[scaron]2
ar4[scaron]r
a3r[uring]
ar[uring]s3
a3r[yacute]
a2s
a3sa
a3se
a3sh
a3sin
as3n[aacute]
a3so
as3pi
as4tat
a4stk
as4tm
a4stru.
as3tv
a3su
a3sv
a3sy
a3s[aacute]
a3s[eacute]
a3s[iacute]
a3s[uring]
a2t
a3ta
at4ch
a3te
a3ti
a4tio
at4kl
at3lo
a3to
a3tr
at3re
at3ron
at3rov
a4tru
at4r[aacute]
at4th
a3tu
a3tv
a3ty
a3t[aacute]
a3t[eacute]
a3t[ecaron]
a3t[iacute]
a3t[oacute]
at1[rcaron]
a4t[rcaron][iacute].
a3t[uring]
a3t[yacute]
a2u
au4gs
a3uj
auj4m
aus3t
a3u[ccaron]
2av
av3d
av4d.
av3lo
a4vlu
a4vl[iacute]
av3t
av4ti
2ay
ay4on
az3k
az3la
az4l[eacute]
az3ni
a3zp
a2[ccaron]
a3[ccaron]a
a3[ccaron]e
a3[ccaron]i
a3[ccaron]l
a[ccaron]4m[aacute]
a3[ccaron]o
a3[ccaron]u
a3[ccaron][aacute]
a3[ccaron][iacute]
a3[ccaron][uring]
a2[ncaron]
a3[ncaron]o
a3[ncaron]u
a[rcaron]e4k
a3[rcaron][iacute]
a4[scaron]pl
a4[scaron]py
a2[tcaron]
a[uacute]3t
2b.
3ba.
ba4br
ba4chr
ba3ka
ba4se
2b1c
b1d
be4ef
be4et
bej4m
be3p
beu4r
be2z3
beze3
b1h
1bi
bi2b3
bis3
bist4
bi4tr
b1j
2bk
3bl.
bl4bl
b2lem
b2les
3blk
b4l[aacute]n
b2l[eacute]m
b1m
2bn
1bo
bo4et
bo4jm
bo4ok
bo4tr
bou3s
bo4[scaron]k
b2ral
b2ran
2bri
b4rodit
b4rou
broz4
b2ru
b3ru.
b3rub
b2r[aacute]n
2b1s2
bs3tr
2b1t
bt[aacute]h4
bu2c
bu4en
3by.
bys3
by4sm
by4t[ccaron]
by4zn
b2z
1b[aacute]
2b1[ccaron]
b[eacute]4rc
1b[ecaron].
b[ecaron]3ta
1b[iacute]
3b[iacute]n
b[iacute]4rc
2b[ncaron]
b3[rcaron]a
b3[rcaron]e.
b[rcaron]e4s
b1[rcaron][iacute]
2b[scaron]2
2c.
1ca
cad4l
ca4es
2cc
1ce
cech4
ced4l
celo3
ce4ns
ce4ov
ce4ps
cer4v
ce2u
2ch.
1cha
4chalg
3che
4che.
2chl
ch4ly
ch4mb
2ch3n
2cht
4chte
1chu
ch4u.
1chy
1ch[aacute]
2ch[rcaron]
1ci
cien4c
cik4l
2ck2
c4ket
ckte4r[yacute]
2cl
c3la
c3l[eacute]
2cn
1co
co4at
co4mm
co4[zcaron]p
c2p
2ct
c2ti
ctis4
ct4la
ct2n
c3tv
c2t[ecaron]
cuk1
1c2v
cy2
1c[aacute]
1c[iacute]
c[iacute]4pl
2c[ncaron]
1c[uring]
2d.
1da
da3d
da4j[scaron]
da4kl
da4tr
d1b
d2ba
4dbat.
d2b[aacute]
2d1c
dch4l
3dch4n
d1d
dd4ha
1de
de4bre
de3hn
de3jd
dej4mo
de3kl
de3kv
de2na
de2oz
de3sl
de4sm
de4so
de2sp
des4t
de3str
de1x
de4xt
de2z
de3zn
dez3o
de3[ccaron]t
de4[zcaron]p
2d1h
1di
di4gg
4dind
dis3k
di4so
d1j
dj4us
2dk
d3kv
3dl.
d1la
d4lab
d4lak
d3li
1dln
d2lou
d3lou.
d2lu
d3lu[ccaron]
d4l[aacute][zcaron]
d1l[eacute]
2d1l[iacute]
d2l[uring]
d1m
1dmd
dm[yacute][scaron]4
2dn
1do
4dobl
4doboj
dob4rat
do3by
do3b[ecaron]
do3b[yacute]
do1d
4do4dd
4do4dj
dod4n
do3h
doj4m
4dokn
4doly
do3mn
domoh4
do3p
do4pc
dop4n
dor2v
do1s
dos4p
dos4tiv
do3t
do3uk
do3u[ccaron]
do3z2
doz4n
do3[ccaron]
4do4[ccaron]n
do[ccaron]4t
do4[zcaron]p
4dran
d4rap
d1re
d4ren
3drobn
d3ros
d3rou
d3ro[scaron]
dr4sc
d3ru[scaron]
d3r[eacute]
d3r[yacute]
d4r[yacute]v
2d1s2
ds4k[uring]
ds4po
d1t
d3tl
d3t[rcaron]
1du
dum3[rcaron]
du3na
du3p
du4pn
2dur
du3si
du4[iacute].
d2v
d4vac
d3ve
d3vl
d3vr
d3vy
d3v[aacute]
d3v[ecaron]
d3v[iacute]
1dy
dy4su
d3zb
d3zd
d3zn
1d[aacute]
2d1[ccaron]
1d[eacute]
1d[ecaron]
3d[ecaron]j
1d[iacute]
2d[ncaron]
d1[rcaron]a
d[rcaron]e4k
d4[rcaron]ep
d[rcaron]e4pn
d4[rcaron]ev
d1[rcaron][iacute]
d2[rcaron][iacute]t
2d[scaron]2
d3[scaron]k
d3[scaron]t
1d[uring]
3d[uring].
d[uring]3s
1d[yacute]
d2[zcaron]2
2e.
e1a
ea3dr
e2ar
e1b
eb4er
ebez2
eb4li
e2b[rcaron]
e4ch.
e3chl.
e4chm
e3cho
e2chr
e3chv
e4ch[tcaron]
ed4be
ed4kv
ed1l
ed2ma
e3dmn
ed3v
ed4[rcaron][iacute]
e1e
ee4th
ee3xi
eg4gi
e1ha
e1he
ehno4
eh4n[ecaron]
e1ho
e1hr
e1hu
e1hy
e1h[aacute]
e1h[yacute]
e1i
eilus3
ej3ag
e3jas
e1je
e3jed
ej3ele
e3jez
ej3in
e3jis
ej1m
ej3mo
e3jmu
ej1o
ej1u
eju3st
ej3v
e2k
e3ka
e3ke
e4kly
e3ko
e3kr
e3ku
e3ky
e3k[aacute]
e3k[eacute]
e3k[oacute]
e3k[rcaron]
e3k[uring]
e1la
e4lau
el4dv
e1le
e1lo
e1lu
e1ly
el4ze
e1l[aacute]
e1l[eacute]
e1l[iacute]
e1ml
e4ml[iacute]
emo3k
e1mr
e1my
e3m[aacute]
e1m[ecaron]
e1m[iacute]
e3m[rcaron]
e3m[uring]
e1m[yacute]
em3[zcaron]e
en4dv
enitos4
en4sc
en4si
ent3r
e1o
eo3by
eoch3r
eod3l
eo4du
e4ole
eo1s
eo2st
eo4t[rcaron]
eo3z
eo4zb
eo4zd
eo[scaron]e3
epa3t
e2pl
e4pni
ep2no
e4pn[yacute]
epo[ccaron]3t
epro4z[rcaron]
ep4tl
ep4tm
ep4tn
e4ptu
epy3
2er
e1ra
er4a.
e1re
e1ri
e1ro
er3s
er4s.
er4sn
e1ru
e1ry
e1r[aacute]
e1r[eacute]
e1r[uring]
e1r[yacute]
e1s
e4sag
e2sce
e4sin
esi4s
e2sk
es4k.
e4s4kn
es3ku.
es3ky
es3k[eacute]
e2sl
e4s3li
e4sly
es2m
e4sp.
es4pe
e2st
e4st.
e4ste
es3ti[zcaron]
es4tol
e4strou
es3t[aacute]n
e1t
e4tki
e4tkr
e4tli
e4tly
et3ri
et3ro
et3r[uring]
et1[rcaron]
et4[uacute]n
e1u
eu3b
eu3ct
eu3d
eu3k
eu3m
eu4m.
eu3n
eu3p
eu3r
eu4r.
e4ura
eu4ras
eu4rg
eu3s2
eu3t
e4u4t.
eu4tra
eu4ts
eu3v
eu3z
eu3[zcaron]
e3vd
eve4[scaron]
e3v2k
e4vsk
evy3
evyjad4
evyp[aacute]4t
evy4[ccaron]k
ev[ecaron]4tr
ex4ta
e3xu
ey4or
ey4ov
ezaos3
ez4ap
ez4bo
ez3de
ez3dov
ez3du
ez4d[ecaron]
e3ze
ez4ed2
ez4ej
ez4el
ez4er
ez4es
ez4ez
ez4e[scaron]
ezis4
ez4it
ez4le
ez4n[aacute]
ez4n[ecaron]
ez4py
ez2t
ez4[aacute]c
ez4[aacute]h
ez4[ccaron]e
e3z[iacute]
e3z[rcaron]
ez4[rcaron]e
e1[aacute]
e[ccaron]4kat
e1[ccaron]t
e[ccaron]4te
e4[ccaron]ti
e4[ccaron]t[iacute]
e2[ncaron]
e3[ncaron]o
e3[ncaron]u
e3[ncaron][aacute]
e3[oacute]n
e1[rcaron]
e[rcaron]e4k
e[rcaron]4ku
e3[rcaron][iacute]
e2[scaron]
e3[scaron]e
e3[scaron]i
e4[scaron]ka
e3[scaron]l
e[scaron]4l[aacute]
e3[scaron]o
e[scaron]4to
e[scaron]t[iacute]h4
e3[scaron][iacute]
e[uacute]1
e[uacute]my4
e[uacute]3n
e[uacute]3p
e[uacute]3t
e[uacute]3[ccaron]
e[zcaron][iacute][scaron]4
1f
2f.
fe4in
fene4
fe4ue
fi4em
fi4fl
f2l
f3l[iacute]
fl[oacute]4r
fm4no
2fn
2fr
f4ran
f4ras
3frek
f1ri
2fs
fs4te
2ft
fu4ch
2f[eacute]
f2[uacute]
1g
2g.
ga4u[ccaron]
ge2s
ghou4
3gic
3gin
gi4[iacute]m
g4lom
2g1m
2gn
g4noi
g4nos
go1
go4hm
3graf
gu4el
gu4it
gu3m
gu4m.
gus4t
gu3v
2h.
ha4ag
ha4ar
ha4bl
ha4br
ha3dl
ha4dla
ha4ke
has3t
hatos4
ha4yd
h2b
h2c
2hd
he4br
he4id
hej4s
he2s
he2u
he3x
hi4an
hi3er
hi4gh
hi4re
2hk
4hla.
h4led
h3len
2hli
4h3lo.
h3lob
h3lop
h3lov
h3luj
2h1ly
4hl[aacute].
h4l[aacute]s
h3l[iacute].
4hl[iacute]k
2hl[yacute]
h2m
2h2n
h3ne
h4ned
h3niv
h4noj
3hn[ecaron]d
3hodin
ho3str
hos4t[ecaron]
4hove
4hovna
4hovny
4hovn[aacute]
4hovn[ecaron]
h2r
hra4p
2h1t
h4tin
h2t[ecaron]
h4t[iacute]t
hu4ch
hu3mo
hu4t[ncaron]
2h2v
hyd1
hy4do
hy4ps
hys3
hy2t3r
hy4zd
h1[ccaron]
2h[ncaron]
h[rcaron]2
h[rcaron]4by
h[yacute]4bl
h2[zcaron]
2i.
i1a
ia3d
ia3g2
i4al.
ias4t
ia4tr
i1b
ib2l
i2b1r
i1ch
i4ch[zcaron]
i1d
id4ge
id2l
id4lo.
i4dl[yacute]
i1em
i1en
i1et
if1r
ig4ne
i1h
i2hl
i3hl.
i4hli
ih3n
ih4na
i3im
i1j
ijed4
ij4me
ij4mi
i2kl
ik3le
ik3lo.
ik3m
ik4ry
i4kve
ik4[uacute][rcaron]
i1l
il4ba
ili[ccaron]4n
i4lnu
ilu3
i1m
i4mla
i4mly
i4mun
i2n
i3na
ina3d
in4cm
in4dl
i3ne
3infe
in4gh
in4gp
in4gs
in4gt
i3ni
i3no
i3nu
i3ny
i3n[aacute]
i3n[eacute]
i3n[ecaron]
i3n[iacute]
in4[scaron]p
i3n[uring]
i3n[yacute]
i1o
io4sk
i2ps
i1r
iro4s
i1sa
is3c
is4ch
is4k.
is3ka
is3ke
is3ko.
is3kr
is3ku
is3kv
is3ky
i3slav
is3lo
is3l[eacute]
is3pl
is3po
is1t
is4tal
is4tat
is4th
ist3v
is3t[iacute]
i1sy
i3s[aacute]
i1t
it1r
it4rh
it4rp
it4se
it4su
i2tv
i1um
iv3d
i1x
ix4td
i3zp
iz1r
i1[aacute]
i1[ccaron]l
i[ccaron]3t
i[ccaron]4tl
i[ccaron]4to
i2[dcaron]
i1[eacute]
i[eacute]4re.
i1[iacute]c
i1[iacute]m
i1[oacute]
i1[rcaron]
i[rcaron]4kl
i[rcaron]4[ccaron]e
i2[scaron]
i3[scaron]e
i3[scaron]i
i[scaron]3k
i[scaron]4kr
i[scaron]4kv
i3[scaron]o
i[scaron]4to
i3[scaron]u
i3[scaron][aacute]
i3[scaron][iacute]
i2[zcaron]
i3[zcaron]a
i3[zcaron]e
i3[zcaron]i
i3[zcaron]o
i3[zcaron]u
i3[zcaron][aacute]
2j.
ja2b2
jac4k
ja4cq
ja3d
ja3g
j3akt
j1b2
jbyst3
2j1c
j2d
j3dob
j3dok
j3dos
j3dr
j3d[aacute]
jd4[rcaron][iacute]
j3d[uring]
jech4
j3ef
j3ex
jez3d[iacute]
jg4ra
2j1h
1ji
ji4ch
jih3l
ji4m[zcaron]
j4ina
jis3k
jit4ro
ji2zv
j1j
2jk
j3kv
2j1l
j2m
j3ma
j3mi
jmou3d
2jm[iacute]
2jn
jne3
j1ob
j1od
jod2[rcaron]
j1oh
j1op
j4ora
j1os
jo3sv
j2ov
j3ovl
j1o3z2
2jp
jpor4
jpo4zv
jp[rcaron][iacute]z4
2j1r
2j1s2
j4sem
j4si.
j4sk.
js4ko
js4k[aacute]
j4s4k[uring]
j4s4me
j3sn
j4sou.
j4souc
js4po
j4s4te
2j1t
j3tl
ju4an
ju3na
ju3p
j1us
ju3sp
ju3t
ju4t.
ju3v
ju4xt
ju3z
j1u[zcaron]
ju3[zcaron]i
2jv2
j3vd
j3vn
2jz
j3zb
j3zd
j3zk
j3zn
j3zp
j[aacute]d2r
2j1[ccaron]
2j[dcaron]
1j[iacute]
j3[scaron]t
j[scaron]4ti
j3[scaron][tcaron]
2j[uacute]1
j[uacute]3n
j[uacute]3[ccaron]
j[uacute]3[zcaron]
2j[zcaron]
1k
2k.
ka4bl
ka4ch
ka3dl
3kaj
ka3ka
3kami
3kan[ecaron]
ka2p3l
ka2p3r
ka2ps
ka4pv
ka2p[rcaron]
kas3t
kast3r
3kat
ka4u[ccaron]
3kav
3ka[ccaron]
3ka[rcaron]
ka[scaron]3l
ka4[scaron]p
2k1c
k2d
k2e
ke4bl
ke3jo
ke4pr
ke4ps
3ket
2kf
2kk
k2l
3kl.
4k3la.
k3lej
4k3li.
k4lib
k3lic
4kli[ccaron]ka
4klo.
k3los
2k3ly
k3l[aacute].
k3l[eacute]
k3l[oacute]
k3l[yacute]
2k2m
k3m[ecaron]
2kn
kna4s
ko3by
3kof
ko4jm
ko2p[rcaron]
ko4sk
ko2t3v
kous3k
3kov
ko3z[aacute]
4kroa
k3rob
k3rof
kr2s
kr4[uacute].
2ks
2k1t
kt2r
kuch4
ku4f[rcaron]
ku4hr
3kuj
ku3se
ku3si
ku3su
ku4th
ku3v
2k2v
k4vr[ncaron]
3kyn
ky2pr
kyp3[rcaron]
ky4zn
3k[aacute]c
k[aacute]4pl
3k[aacute]r
3k[aacute][rcaron]
2k[ccaron]
k2[ncaron]
k2[rcaron]2
k3[rcaron]ej
k[scaron]4ti
3k[uring].
2l.
1la.
la4br
lab4s
la3ka
la4nq
la4ps
4la3si
la4v[scaron]
la4y.
la2zm
2l1b
2l1c
2l1d
ld4ne
le4ad
le4au
lech3t
leh3n
le2i
1lej
le3jo
4lej[scaron]k
1lel
4lench
lepa3d
lepo4s
le4pr
le4ps
le4sc
le4sm
le4sv
let4li
let3m
le2tr
le4t[ccaron]
le4uk
le4vh
le4vk
le3xi
lez3n
2lf
2lg
2lh
3lhan
1li
li4az
li4bl
li4bv
li4dm
lind4
3lio
li4t[ncaron]
li4vr
2li[zcaron]
2lj
2lk
l4kat
l2kl
lk4nu
2ll
2l1m
2ln
l4nul
lo3br
lo4id
lo4is
1los
lo3sp
lo3st[rcaron]
lo3sv
lo2tr
lo4t[rcaron]
lo4u.
lo3z
loz4d
lo4[scaron]k
2lp
l2p[ecaron]
2l1s2
l4sla
ls3n
lst4n
l4st[iacute]
2l1t
lt4ra
lt4ru
lt4ry
lu4id
lu4j.
lu4k.
lu4lk
lu4m.
lu4mn
lu3pr
lu3va
lu3vl
lu3vy
lu3v[iacute]
2lv
2lz
1l[aacute].
l[aacute]4j[scaron]
l[aacute]4v[scaron]
2l1[ccaron]
1l[eacute].
1l[iacute]k
l[iacute]4pl
l[iacute]4zn
1l[iacute][rcaron]
2l[ncaron]
2l[scaron]2
l3[scaron]t
l4[scaron]t[yacute]
1l[uring]
1l[yacute]
l[yacute]2t
2l2[zcaron]
2m.
1ma
maj4s
ma4kl
ma4kr
4mald
mas3k
mat3r
ma4tra
ma4v[scaron]
maz3l
2m1b
2m1c
2m1d2
m2dl
1me
3me.
me4go
me4is
met3re
me3x
mezi3s
2mf
mh4le
1mi
mid3l
mik3r
mi4xt
2mk2
3m2kl
mk4la
mk4li
m2l
4mla.
2mle
ml3h
ml4h.
2mli
ml4sc
ml4sk
4mlu.
2mn
m3na
mna4s
m4noh
m3nos
m4noz
3mno[zcaron]
m3n[aacute]
m3n[eacute]
m4n[eacute]z
m3n[ecaron]j
m3n[yacute]
1mo
mod3r
mo2hl
mo2k
mo2s
mo4s.
mot3[rcaron]
4mout
moza4
mo3z[rcaron]
mo[uacute]3
2mp
m4plo
mpo4s
m2ps
mp4se
mp2t
mr2s
2m1s2
m4stl
2m1t
1mu
mu4fl
mu3n
mu4n.
mu4nd
mu4nn
mu4ns
mu4n[scaron]
2mu[scaron]
2mv
mys3lo
my4[scaron]k
2mz
3m[aacute].
m[aacute]lo3
m[aacute]2s
2m[ccaron]
m2[ccaron]e
m[iacute]1c
m[iacute]4r[ncaron]
2m2[scaron]
m[scaron]4[ccaron]i
m[scaron]3[tcaron]
m[scaron]4[tcaron]an.
3m[uring].
3m[yacute].
m2[zcaron]
1n
2n.
3na.
na3ch
na4do
na4em
na3h
na4h.
na3jd
na3ka
nam4ne
na3p2
na3s2
na4s.
nat2
na3tl
na3t[rcaron]
na3z
naz4k
na4z[scaron]
na4[ccaron].
na3[scaron]
na[zcaron]4n
2nb
2n1c
n4chc
2n1d
nd4hi
ndo4t
nd2re
nd4ri
nd4[rcaron][iacute]
ne1d
ne4gl
ne1h
ne3h4n
ne2j
nej3t
nej3u
ne3kl
ne4kro
ne3kv
ne4m.
ne3p
ne3s2
ne4s.
nes4le
ne4ss
4nesti
ne3tl
net4r
ne3ud
ne3v2
ne4v.
ne3z
nez4n
ne3[scaron]k
ne3[scaron][tcaron]
2nf
n3fr
2ng
ng1l
ng4la
ng4le
ng4l[iacute]
n4gro
ng4vi
nik4t
ni4mr
ni4m[zcaron]
3nio
3nisk
2nit[rcaron]
n1j
2nk
2n1l
2nn
no3b2
no4bs
no3hn
no4hs
no4ir
no4m[zcaron]
no4sky
no3sm
no3str
not4r
no3z
no4zd
no4[scaron]k
2no[zcaron]
2n1s2
n2sa
ns3ak
ns4ko
n4soc
ns3po
nst4ra
2n1t
nte4r3a
nt4lem
nt4r.
nt3ru
nt3r[aacute]
2nub
nu4gg
3ny.
2nz
3n[aacute]k
n[aacute]3s2
n[aacute]4s.
2n1[ccaron]
2n[dcaron]
2n[iacute]v
2n[iacute][zcaron]
2n[oacute]
2n[scaron]2
n3[scaron]t
n[scaron]4[tcaron]o
n[uring]2
2n[zcaron]
2o.
o1a
oang4
o1ba
o1be
obe3j
obe3s
obe3z
ob1l
ob1r
ob4r[ncaron]
o1bu
obys4
ob3z
o3b[eacute]
ob3[rcaron]ez
o1c
o4chl
o2chr
oc4ke
oc4ko
o4ct.
oct3n
ocy3
oc4[uacute]n
od3b
odej4m
ode3p
ode3s
od1l
o4doc
odos4
odo4tk
od3ra
od4ran
od3r[uring]
o3dr[zcaron]
od3v
od1[rcaron]
o1e2
oe3g
oe3ti
o2fl
ofrek4
og2
o3gn
o1h
oh4ne
o1i
oi4ce
o4int
o1j
o4jar
oje4dl
o4jmi
o4jmov
o4jmu
o4jm[uring]
oj2o
o4juz
2oka
ok2te
o1l
ol4gl
ol4to
o1m
om4kl
om2n
o2n
o3na
ona4s
o3ne
o3ni
o3no
ont4ra
o3nu
o3ny
o3n[aacute]
on[aacute][rcaron]4ka
o3n[ecaron]
o3n[iacute]
o3n[uring]
o3n[yacute]
o1o
oo4h[rcaron]
oote2
opo[ccaron]3t
opro4s
o2ps
o4ptu
op[aacute]4t
o4p[rcaron].
op[rcaron]ej4
op[rcaron]e4jm
o1ra
o4rae
or4dm
o1re
o1ri
o1ro
or3st
o1ru
or4v[aacute]
o1ry
o1r[aacute]
o3r[eacute]
o1r[uring]
or[uring]s3
o3r[yacute]
o1sa
o4sai
ose4s
osi4d
o1sk
o4s3ke
o4sku
osk3v
o4sk[aacute]
o4sk[yacute]
o1sl
os4la
os4li
os4l[yacute]
os3mo
os4mu
o4st.
o4stg
o4stm
os4tor
os3tr[uring]
o4st[eacute]
o4st[scaron]
o4st[yacute]
o1sy
o1t
ot4kl
o4tl[yacute]
oto3s
ot3ro
ot3v[iacute]
o3t[iacute]
o3t[rcaron]
ot3[rcaron]i
o2u
ou3b[ecaron]
ou3d[ecaron]
ou4fl
ou4il
ou4is
ou4k.
ou3ka
o4ukl
ou3kr
ou3k[aacute]
ou3m
oup3n
oupo4
ou4s.
ou3sa
ou3se
ou4sk
ou3sm
ou4tv
ou3v
ou4vl
ou4vn
ouz3d
o4u[ccaron]k
ou3[zcaron]i
ovi4dla
o4vsk
ovy2p
o2v[scaron]t
o1x
o2z
o3za
oz1b
oz4d.
oz3d[aacute]
oz3d[ecaron]
oz3d[iacute]
o3ze
oze3d2
ozer4
oz1h
o3zi
oz3j
oz3k
oz4ko
oz1l
oz3m
o4zn.
o3zo
oz3p
oz4py
oz4p[ecaron]
oz4p[iacute]
oz3ro
oz3ru
oz3r[uring]
oz3t
o3zu
o4zut
oz3vr
oz3v[aacute]
o3z[iacute]
o3z[uring]
oz[uring]4s
o1[ccaron]
o[ccaron]2k
o[ccaron]4ka
o2[ncaron]
o3[ncaron]a
o3[ncaron]o
o1[rcaron]
o[rcaron]i2s
o3[scaron]k
o4[scaron]ku
o4[scaron]ky
o3[scaron]l
o[scaron]4l[aacute]
o[scaron]4mo
o[scaron]4ti
o[scaron]4[tcaron]u
o3[zcaron]l
o[zcaron]4mo
1p
2p.
pa4ed
pa4es
pa4kl
pa3si
pa4t.
pat4ri
2p1c
pe4al
pede4
pe4ig
pe4np
peri3
pes3t3
pe4tra
3pe[ccaron]
pi4kr
pi4pl
2pk
p2kl
p2l
3pl.
4p3la.
pl3h
pl4h.
4p3li.
4plo.
2pn
p2nu
po1b2
po3c2
3pod
podb[ecaron]4h
pod4nes
po3dru
po3dr[aacute]
po3h
poly3
po3m2
po4mp
po4ol
po3p
po4p.
po4pm
po1s2
pos4p
post4r
po3t2
po4t.
po4tn
po3uk
po3u[ccaron]
po3u[zcaron]
3po3v
po3z2
po4zd
po[ccaron]2
po3[ccaron]k
po[ccaron]3te
po3[rcaron][iacute]
po4[scaron]v
2pp
4pra.
pra3st
pr2c
pro1
prob2
pro3p
pro3t4
pro3z
pr2s
4pr[aacute]n
pr[uring]3
pse4s
2p1sk
p4sut
2pt
p4tej
p4ter
p4tev
pt4ri
p3tu
p4t[aacute].
pu4dl
pu4tr
pyt3l
p[aacute]1
p[aacute]2c
p[aacute]d3l
p[aacute]4nv
p[aacute]4sl
2p[ccaron]
p[eacute]4rh
2p[rcaron].
p[rcaron]e3h
p[rcaron]e3j
p[rcaron]e3t4
p[rcaron]e3z
p[rcaron]e3[ccaron]2
p[rcaron]i3
p[rcaron]ih4
2p[scaron]
p[scaron]4ti
2p[tcaron]
qu2
2r.
1ra.
ra4br
ra4em
ra4es
ra4ff
ra4hl
ra4hm
ra4jg
ra4j[scaron]
2rak
ra4nh
ra3si
rast4r
ra4vv
ra4wl
ra4y.
ra4yo
ra4[dcaron]m
4ra[zcaron]i
r1b
r2bl
r1c
rca3
r3cha
r3cho
rc4ki
r1d
r4dla
rdo2s
re4ad
re4au
red4r
re4et
re3kl
re3kvi
re4mr
re2sb
res3l
retis4
ret4r
re4um
r1ha
r3hl.
rh3n
r1ho
r3hu
r1h[aacute]
ri4bb
1ric
ric4ku
ri4dg
ri4dr
ri4fl
ri4gh
ri4zm
2rk
r2kl
r1l
2r1m
r4mio
2rn
rna4v[scaron]
rn4dr
ro4ad
ro3by
rod2l
ro3d4r
3rofy
ro3h
ro4h.
ro4jb
ro4k[scaron]
rom3n
romy4s
rop[aacute]t4
ro2sb
ro4skv
ro4sky
ro3sv
ro3ti
ro3tl
ro4t[ccaron]
ro3vd
rov[ecaron]4t
3rov[yacute]
roz3d
roz3n
ro4zo
roz3v
ro3z[aacute]
ro4[ccaron]p
rpa3d
2rr
rr4ha
rr4ho
2r1s
r2st
r4stu
rs3tv[ecaron]
rs3tv[yacute]
2r1t
r2th
r4tr[aacute]
rt4sm
rtu3
r2t3v
rt4zu
1ru.
ru3se
ru3si
rus3k
ru3[zcaron]i
3rvan[iacute]
r1x
1ry.
rych3
ryd2
rys3ky
rys3t
ry4zk
ry4zn
ry4[iacute].
ry4[scaron]k
2rz
rz3d
rz3l
r[aacute]d4l
r[aacute]4d[zcaron]
1r[aacute]k
r[aacute]3ri
1r[aacute][rcaron]
r1[ccaron]
4r[ccaron]it[yacute].
r[ccaron]3t
3r[eacute].
2r[oacute]
2r[scaron]
r[scaron]4n[iacute]
r[uring]4m.
r[uring]s3ta
r[uring]4v.
3r[yacute].
r[yacute]4zn
2s.
sa4pf
sa4pr
sas3k
s2b2
s2c
s3ca
s3ce.
sch2
sch4l
sch4n
3schop
s3ci
sci4e
s3c[iacute]
s2d
1se
se4au
se3h
se4ig
se4il
sej4m
se4ku
3sel
se3lh
3sem
ser4va
se3s2
ses4k
se4ss
se4stra
se4stru
se4st[rcaron]
set2
se3tk
se3t[rcaron]
se4ur
se3z
se3[ccaron]t
2sf
s3fo
3sf[eacute]
s3f[uacute]
1si
3sic
3sif
si4fl
sig4no
3sik
si3ste
3sit
s2j
s3ju
s2k
4skac
s4kak
4skam
s4kok
2skon
skos4
4skot
sk4ra
sk4ru
sk4ry
4skve
sk4vo
s3k[aacute]n
s3k[uring]
3sl.
4s3la.
s4lav
s3le.
s4led
s3lem
s3len
s3let
s4lib
s4li[ccaron]i
3sln
4s3lo.
s2ly
s3ly.
s1l[iacute]
s2ma
s4mek
s2mo
2sn
s2na
s3nat
s2ne
s3ne.
sn4tl
s2n[aacute]
s3n[aacute].
s4n[iacute]d
1so
sob4l
so3br
so4sk
so4tv
sou3h
sou3s
souz4
so4[scaron]k
s2p
s4pol
spro4s
1sr
2ss
ss4sr
2st.
4sta.
s3taj
s2tan
st4at
4stec
s4tep
st4er
s4tero
s4tich
2stil
s4tink
4stit.
4sti[ccaron]
st3lo
2stn
4sto.
s4tona
4stou.
4str.
4stram
s4trik
4strn
4str[aacute]c
4stupni
s2tv
st4ve
3stv[iacute]
4sty.
s4tyl
3sty[scaron]
s2t[aacute]
4st[aacute].
s3t[aacute][rcaron]
4st[ecaron].
s4t[ecaron]d
3st[ecaron]h
s2t[ecaron]r
s2t[ecaron][zcaron]
s1t[iacute]
2st[iacute].
s3t[rcaron]ej
1su
su4ba
su4bo
suma4
su3ve
s2v
sy3c
sych3r
sy4nes
s[aacute]2d
3s[aacute]h
s[aacute]2kl
2s2[ccaron]
s3[ccaron]i
1s[eacute]
1s[iacute]
2s[ncaron]
2s[tcaron]
s3[tcaron]o
1s[uring]
s2[zcaron]
2t.
1ta.
ta2bl
tac4tvo
t2a3d
1taj
ta4jf
ta4jg
4talt
4tand
3tan[ecaron]
t1ao
2tark
tast4
ta3str
ta4[ccaron]k
2t1b
2t1c
1te
3te.
te4ak
te4fl
te4in
4ten[eacute]m
teob4
tep3l
ters4
tes3ta
te4tr
te4uc
te4ur
te4ut
2tf
2tg
1ti
ti4gr
2tih
ti3kl
tin4g
ti4pl
ti3sl
tis4tr
ti4tr
2titu
tiz4r
4tiz[iacute]
ti[uacute]3
2ti[zcaron]
2tk2
t4kal
4t2kan
t4kat
t2kl
tk4la
tk4li
4tkn[ecaron]
t2k[aacute]
2tl
3tl.
4tla.
t1le
tles3
3tlm
t3lo.
t4lou
tlu3
tlu4s
t1ly
t1l[eacute]
2tm
t2ma
2tn
t3n[iacute]
1to
to4as
to3b
tob4l
to3dr
to4hm
to4ir
2toj
tol4s
to4ol
4top.
4topt
4topu
2torn
2toup
2tp
t3rant
t4rea
t4ref
tre4t
4tric.
trip4
t4rit
t4rog
t3rol
tro4sk
t4rou
4trouh
4tro[ncaron].
4trun
t4rus
4t4ru[zcaron]
t3r[aacute]ln
4tr[aacute][scaron]
2tr[ccaron]
t3r[uring]m
t3r[uring]v
2tr[yacute]
2t1s
ts4ko
ts2t
2t1t
tt4ch
tt4ri
1tu.
tu4ff
1tuj
tu4lk
2tup
tu4r.
tu3ry
tu4s.
tu4[tcaron].
tu3[zcaron]i
t2v
2tve
2t3vi
t4vinn
t4vi[scaron]
t4v[yacute]c
1ty.
ty4g[rcaron]
ty2la
ty4[rcaron]e
ty4[rcaron]h
ty4[rcaron]j
ty4[rcaron]o
ty4[rcaron]r
ty4[rcaron][uacute]
3t[aacute].
t[aacute]4fl
t2[ccaron]
t3[ccaron]i
2t[ccaron][iacute]
1t[eacute]
t[eacute]2bl
3t[eacute]m
1t[ecaron]
t[ecaron]3d4l
2t[ecaron]h
2t[ecaron]nn
2t[ecaron]p
1t[iacute]c
4t[iacute]c.
4t[iacute]ce
1t[iacute]m
2t[iacute]n
2t[iacute]r
2t[rcaron]
t4[rcaron]eb
t[rcaron]eh3n
t2[rcaron]el
t2[rcaron]ic
t3[rcaron]il
t[rcaron]4ti
t1[rcaron]u
t2[rcaron][aacute]
3t[rcaron][aacute]b
t[rcaron][iacute]4s
2t[scaron]
t3[scaron]t
t[scaron]4ti
1t[uring]
1t[yacute].
1t[yacute]m
1t[yacute][rcaron]
3t[yacute][scaron]
u1
2u.
u2at
u2b
u3ba
u3be
u3bi
u3bo
ubs4t
u3bu
u3b[aacute]
u3b[iacute].
u3b[uring]
uc4t[iacute]
2u2d
u3de
u3di
u3do
u3dru
u3du
u3dy
u3d[iacute]
ue4fa
2uf
u2hl
uh3l[aacute]
uh3no
u2in
u2jm
u2k
u3ka.
uk4aj
uk4al
uk4at
u3ke
uk3la
uk3le
u3ko
u3ku
u3ky
uk4[aacute].
u3k[uring]
ul4fa
ul1h
ul4p[iacute]
u2m
u3ma
u3me
u3mi
um4pl
um4ru
u3mu
u3m[aacute]
3um[rcaron]
u2n
un4dl
u3ne
u3no
u3nu
u3n[ecaron]
u3n[iacute]
u3n[uring]
un4[zcaron]r
u2p
u3pa
u3pe
upe2r3
u3pi
u3pln
u3pu
u3py
u3p[aacute]
u3p[ecaron]
u3p[iacute]
u3p[uring]
u2r
u3ra
u3re
u3ri
2u3ro
u3ru
u3ry.
u3r[aacute]
1ur[ccaron]
u3r[uring]
u2s
us3ky
us3k[aacute]
us3k[eacute]
us3k[yacute]
us1l
us2lo
u3so
u4ste
u4sty
u4st[eacute]
u4st[ecaron]
u3st[rcaron]
u4st[scaron]
u4st[yacute]
u3su.
u3sy
u3s[aacute]
u3s[iacute]
u3s[uring]
u4tro
u4tr[aacute]
u2v
u3vi
u3vu
u2z
u3ze
u3zi
uz1l
u3zo
u3zu
u3z[iacute]
u2[ccaron]
u3[ccaron]a
u3[ccaron]e
u3[ccaron]i
u3[ccaron]o
u[ccaron]3t
u3[ccaron]u
u3[ccaron][aacute]
u3[ccaron][iacute]
u2[dcaron]
u2[ncaron]
u2[scaron]
u3[scaron]e
u3[scaron]i
u[scaron]4kl
u3[scaron]o
u[scaron]3t[iacute]
u3[scaron]u
u3[scaron][aacute]
u3[scaron][iacute]
u2[zcaron]
u3[zcaron]e
u3[zcaron]o
u3[zcaron]u
u3[zcaron][aacute]
u3[zcaron][iacute]
1v
2v.
va3dl
va4j[tcaron]
va4kl
2v1b
2v1c
v2ch
2v2d
v4dal
v3di
v4d[ecaron]k
v4d[ecaron][ccaron]
ve3dle
ve3jd
3ven
ve2p
ve3ps
vep3[rcaron]
ves3l
ve4sm
ves4p
ve3sta
ve3t4[rcaron]
ve2z3m
vi4ch
vide2
vi4dr
vi4et
vi4kr
vi2tr
2vk
v2kr
v2l
2v3la.
4vle.
4vlem
2vlo
2vm
2vn
v4nad
vo3b
vo4ic
vo4ja
vo4jb
vo4jd
vo4jj
vo4jm
vo4j[rcaron]
vo2s
vo4t[rcaron]
vou3
vous2
v2p
vr2c
vr2dl
4vrny
v1ro
vr4st
vrst3v
vrs4tv[ecaron]
2vs2
v1sk
v3stv
2v2t
vy3c
vy3d2
vy4dra
vyp2
vy3s2
vy4sn
vys4t
vy3t
vy3[ccaron]
vy[ccaron]4k
vy[scaron]2
vy4[scaron].
vy4[scaron]m
vy4[scaron][scaron]
vy4[zcaron]l
v2z2
vz4no
vz4n[eacute]
vz4n[ecaron]
vz4n[iacute]
v[aacute]3ri
2v2[ccaron]
v3[ccaron][aacute]
v3[ccaron][iacute]
v4[ccaron][iacute]r
v[ecaron]4cm
v[ecaron]3t4a
v[iacute]ce3
v[iacute]4hat
3v[iacute]n
2v[ncaron]
2v[rcaron][iacute]
v3[rcaron][iacute]n
v2[scaron]2
v[scaron]e3s
v3[scaron]t[iacute].
3v[yacute]s
v[yacute]3t
3v[yacute]3z
v2[zcaron]2
wa4fd
3war
wa4re
we2
2x.
xand4
2xf
xisk4
2xn
3xov
x1t
xt4ra
xy4sm
y1
y2a
y2bl
yb3ri
y2ch
y4chr
y2d1l
yd4l[aacute]
y2dr
yd4y.
y2e
y2gr
y3hn
yh4ne
yj4ma
yj4me
y2kl
yk3la
y3klop
yk4ly
yman[eacute]4
ym4kl
yna4s
y3ni
ype4r
yp4si
yp4t[aacute]
y2p[rcaron]
yr2v
y2s
y3sa
y3se
y3si
ys3lu
y3sm
y3so
y3sp
ys2t
ys3te
yst4r
y3su
y3sv
y3sy
y3s[aacute]
y3s[eacute]
y3s[iacute]
yt4me
yu3[zcaron]
y3vs
yv[ecaron]4t
y3zb
y3zd
y3zk
y3zn
yz4n[ecaron]
yz4n[iacute]
y3zp
yz4po
y[ccaron]2k
y2[ncaron]
y[rcaron]3b
y[rcaron]k4n
y[rcaron]4[ccaron]e
y3[rcaron][iacute]
y2[scaron]
y3[scaron]e
y3[scaron]i
y3[scaron]k
y[scaron]1l
y3[scaron]o
y3[scaron]p
y3[scaron]u
y3[scaron][iacute]
y[zcaron]2
y3[zcaron]d
1z
2z.
zab2l
za4bs
za4dk
za3dl
za4dn
za3h
za3i
za3j
za4jk
za3k
za4kt
zal4k
zam4n
za3p2
za3s2
zat2
za3tl
zat4r
za4ut
za3z
zaz4n
za4z[scaron]
za4[ccaron].
za3[scaron]
za[scaron]4k
za4[scaron]s
2zb
zban4
z2by
zbys4
2z1c
2z2d
z3di
zdn[ecaron]4n[iacute]
z4doba
z4dobn[yacute]
zd4re
zd4v[iacute]
z2e
ze3h
ze3p2
4zerot
ze3s2
zes4p
zet2
zev2
ze3vn
ze3z
ze4z.
2z2f
z1h[aacute]
z4ine
z2j
z3j[iacute]
2z2k
z3ka.
z3ky
z3k[eacute]
z3k[uring]
z3k[yacute]
2zl
3zl.
zlhos4
zlik3
z3ly.
z2m2
2zme
z3mn
z3my
z4m[ecaron]n
2z2n
3znak
z4nal
z3ne.
z3nic
z3no
z3nu
z3ny
z3n[eacute]
z3n[ecaron]
z4n[ecaron]l
z3n[iacute]
z4n[iacute]t
z4n[iacute]v
z3n[yacute]
zo4tr
zo4[scaron]k
2z2p
z3pt
z4p[aacute]t
3zrak
2z1s2
2zt
ztros3
z4tr[aacute]
z3t[rcaron]
3zu.
zu3mo
zu3m[ecaron]
zu3m[iacute]
zu3[scaron]
z2v
zva4d
z3va[rcaron]
z3vi
zvik4
zv4n[ecaron]
z3vod
z3voj
z4von
zv4ro
z4v[aacute]n
z4v[ecaron]s
z3v[iacute]j
3zy.
2zz
z[aacute]1
z[aacute]h2
z[aacute]4kl.
3z[aacute]p
z[aacute]3s2
z[aacute]3z
z[aacute][scaron]2
2z[ccaron]
z3[ccaron]l
2z[ncaron]
z2[rcaron]
z[rcaron]ej3
z3[rcaron]ez
z3[rcaron]e[scaron]
2z[scaron]2
z3[scaron]k
z[scaron]4ka
z3[scaron]t
2z2[uacute]1
z[uacute]3[ccaron]
z[uacute]3[zcaron]
z[uring]3s
[aacute]1b
[aacute]2bl
[aacute]b4ry
[aacute]4b[rcaron].
[aacute]3cho
[aacute]c3ti3
[aacute]1d
[aacute]2dl
[aacute]do4s
[aacute]dos4ti
[aacute]d1[rcaron]
[aacute]1ha
[aacute]3he
[aacute]h1l
[aacute]3hl.
[aacute]h3n
[aacute]1ho
[aacute]1hr
[aacute]1h[aacute]
[aacute]1j
[aacute]4jmu
[aacute]j4m[uring]
[aacute]4kli
[aacute]k4ni
[aacute]1la
[aacute]1le
[aacute]1lo
[aacute]1lu
[aacute]1ly
[aacute]3l[eacute]
[aacute]1l[iacute]
[aacute]3my
[aacute]3m[eacute]
[aacute]1m[ecaron]
[aacute]3m[iacute]
[aacute]3m[yacute]
[aacute]ne4v
[aacute]1ra
[aacute]1re
[aacute]r2m
[aacute]1ro
[aacute]1ru
[aacute]3r[uring]
[aacute]1s
[aacute]2sc
[aacute]2s3k
[aacute]s4k.
[aacute]s4kl
[aacute]s4kn
[aacute]2sla
[aacute]s4ly
[aacute]2sm
[aacute]s4po
[aacute]2st
[aacute]t3k
[aacute]t1r
[aacute]1tu
[aacute]1ty
[aacute]1t[iacute]
[aacute]3t[yacute]
[aacute]v4si
[aacute]v4s[iacute]
[aacute]z3k
[aacute]z3ni
[aacute]zni4c
[aacute]z4vi
[aacute]2[ncaron]
[aacute]1[rcaron]
[aacute][rcaron]4ke
[aacute][rcaron]4k[uring]
[aacute]2[scaron]
[aacute]3[scaron]e
[aacute]3[scaron][iacute]
2[ccaron].
1[ccaron]a
[ccaron]a4br
2[ccaron]b
2[ccaron]1c
1[ccaron]e
3[ccaron]e.
[ccaron]e1c
[ccaron]es3k
1[ccaron]i
2[ccaron]k
[ccaron]3ka.
[ccaron]3ko
[ccaron]3ku
[ccaron]3ky
2[ccaron]1m
2[ccaron]n
[ccaron]2ne
1[ccaron]o
[ccaron]2p
2[ccaron]s
[ccaron]1sk
[ccaron]s4la
[ccaron]s4sr
2[ccaron]2t
[ccaron]4ten[eacute].
[ccaron]4ten[yacute]
[ccaron]t4la
[ccaron]4tov[yacute].
3[ccaron]tv
4[ccaron]t[ecaron]n
[ccaron]3t[iacute]
1[ccaron]u
1[ccaron][aacute]
1[ccaron][iacute]
[ccaron][iacute]s3l
1[ccaron][uring]
2[dcaron].
1[dcaron]a
1[dcaron]o
[dcaron]s4te
2[dcaron]1t
3[dcaron]uj
[eacute]1
[eacute]2d
[eacute]3di
[eacute]3do
[eacute]2f
[eacute]3fo
[eacute]f1r
[eacute]2kl
[eacute]2l
[eacute]2m
[eacute]3ma
[eacute]3me
[eacute]3mi
[eacute]3mo
[eacute]3mu
[eacute]3m[uring]
4[eacute]re.
[eacute]2s
[eacute]2t
[eacute]3ta
[eacute]3to
[eacute]3t[aacute]
[eacute]2[scaron]
[eacute]2[zcaron]
[ecaron]1c
[ecaron]d3r
[ecaron]3ha
[ecaron]3he
[ecaron]3hl.
[ecaron]h3lo
[ecaron]h3n
[ecaron]1ho
[ecaron]3hu
[ecaron]3h[uring]
[ecaron]3ja
[ecaron]1je
[ecaron]1jo
[ecaron]3j[uring]
[ecaron]4kl[eacute]
[ecaron]3k2t
[ecaron]1l
[ecaron]1ra
[ecaron]ra3d
[ecaron]1re
[ecaron]1ro
[ecaron]r3s
[ecaron]rs4t
[ecaron]1ru
[ecaron]1ry
[ecaron]1r[uring]
[ecaron]s3k
[ecaron]s3n
[ecaron]t1a3
[ecaron]t4ac
[ecaron]t1l
[ecaron]1tr
[ecaron]t3ra
[ecaron]4traj
[ecaron]t3v
[ecaron]1t[iacute]
[ecaron]t3[rcaron][iacute]
[ecaron]2v
[ecaron]3va
[ecaron]3ve
[ecaron]3vl
[ecaron]3vo
[ecaron]3vu
[ecaron]3v[aacute]
[ecaron]v3[ccaron]
[ecaron]2z
[ecaron]3ze
[ecaron]3zi
[ecaron]z3n
[ecaron]3zo
[ecaron]3z[iacute]
[ecaron]1[rcaron]
[ecaron]2[scaron]
[ecaron]3[scaron]e
[ecaron]3[scaron]i
[ecaron]3[scaron]o
[ecaron]3[scaron]u
[ecaron]3[scaron][aacute]
[ecaron]3[scaron][iacute]
[ecaron][scaron]3[tcaron]
[ecaron][scaron]4[tcaron]s
[ecaron]2[tcaron]
[ecaron]3[tcaron]o
[ecaron]2[zcaron]
[ecaron]3[zcaron]e
[ecaron]3[zcaron]i
[ecaron]3[zcaron]o
[ecaron]3[zcaron]u
[ecaron]3[zcaron][iacute]
[iacute]1b
[iacute]b3[rcaron]
[iacute]3cho
[iacute]ch4t
[iacute]d1l
[iacute]1h
[iacute]2hl
[iacute]h3n
[iacute]1j
[iacute]jed4
[iacute]j4m[uring]
[iacute]2kr
[iacute]1l
[iacute]1m[aacute]
[iacute]3m[eacute]
[iacute]1m[ecaron]
[iacute]1r
[iacute]1sa
[iacute]2s3k
[iacute]s4kl
[iacute]s4kn
[iacute]s4l.
[iacute]s3le
[iacute]s4ln
[iacute]s[aacute]h2
[iacute]1t
[iacute]t3k
[iacute]3t3[rcaron]e
[iacute]z3da
[iacute]z3de
[iacute]z3k
[iacute]3zna
[iacute]3z3ni
[iacute]3zn[ecaron]n
[iacute]2[ncaron]
[iacute]1[rcaron]
[iacute]2[scaron]
[iacute]3[scaron]e
[iacute]3[scaron]i
[iacute]3[scaron]o
[iacute]3[scaron][iacute]
1[ncaron]
2[ncaron].
2[ncaron]a
[ncaron]a3d
2[ncaron]k
2[ncaron]m
3[ncaron]ov
[ncaron]1s
2[ncaron]1t
[oacute]1
[oacute]2z
[oacute]3za
[oacute]3zi
[oacute]3zo
[oacute]3zy
2[rcaron].
[rcaron]a4pl
[rcaron]a4[dcaron]m
2[rcaron]2b
2[rcaron]c
2[rcaron]d
[rcaron]e3ch
[rcaron]e4dob
[rcaron]e1h
[rcaron]e3jd
[rcaron]e3kl
[rcaron]e3kv
[rcaron]e4k[rcaron][iacute]
[rcaron]eo4r
[rcaron]e3p2
[rcaron]e4p.
[rcaron]e4pk
[rcaron]e4p[ccaron]
[rcaron]er4v
2[rcaron]es
[rcaron]e3ska
[rcaron]e3sko
[rcaron]e2sp
[rcaron]es3po
[rcaron]e4sr
[rcaron]e3sta
[rcaron]e3stu
[rcaron]e3st[aacute]
[rcaron]e3st[rcaron]
[rcaron]e3tl
[rcaron]et4[rcaron]
[rcaron]e3zd
[rcaron]e3zk
4[rcaron]ezl
[rcaron]e3[ccaron]t
[rcaron]i1
[rcaron]ia3
[rcaron]i3h
[rcaron]i4h.
[rcaron]i4hn
[rcaron]i4j[dcaron]
[rcaron]i4l.
[rcaron]i4lb
[rcaron]il2n
4[rcaron]ine
[rcaron]is2
3[rcaron]i4t.
[rcaron]i4v.
[rcaron]i4vk
[rcaron]i4vn
[rcaron]i3z
[rcaron]i[ccaron]4t
[rcaron]i3[rcaron]
[rcaron]i4[scaron].
2[rcaron]k
[rcaron]2kl
[rcaron]k4la
[rcaron]k4li
[rcaron]k4ly
[rcaron]k4no
2[rcaron]1l
2[rcaron]1m
2[rcaron]n
1[rcaron]o
2[rcaron]ou
2[rcaron]2p
2[rcaron]1s
[rcaron]s4to
2[rcaron]1t
[rcaron]2v
2[rcaron]z
[rcaron][aacute]4pl
[rcaron][aacute]2sl
2[rcaron]1[ccaron]
2[rcaron][iacute]d
[rcaron][iacute]4k[rcaron]
[rcaron][iacute]1s
2[rcaron][scaron]
[rcaron]3[scaron]t
[rcaron][scaron]4ti
1[scaron]
2[scaron].
[scaron]ab3
[scaron]a4vl
2[scaron]1c
[scaron]ej4d
[scaron]ep3t
[scaron]i4mr
2[scaron]2k
[scaron]3ka
[scaron]3ke
[scaron]3k3li
4[scaron]3kou
4[scaron]kov
3[scaron]kr
[scaron]k4ro
[scaron]3ku.
[scaron]3ky
2[scaron]l
[scaron]2la
[scaron]2li
[scaron]3liv
[scaron]2lo
[scaron]l[aacute]2
[scaron]2l[eacute]
[scaron]2l[yacute]
2[scaron]1m
[scaron]mi4d
2[scaron]n
[scaron]2p
2[scaron]1s
2[scaron]t
[scaron]4tip
[scaron]t4ka
[scaron]t4kl
[scaron]4t[ecaron]k
[scaron]2t[ecaron]s
[scaron]4t[ecaron]v
[scaron]4t[iacute]p
[scaron]2v
[scaron][iacute]3d
[scaron]2[ncaron]
[scaron]3[scaron][iacute]
2[scaron]2[tcaron]
[scaron]3[tcaron]o
[scaron]3[tcaron]u
[scaron]3[tcaron][aacute]
1[tcaron]
2[tcaron].
3[tcaron]al
2[tcaron]k
2[tcaron]m
2[tcaron]t
[tcaron][aacute][ccaron]4k
1[uacute]
[uacute]2c2
[uacute]2d
[uacute]j4ma
[uacute]2k
[uacute]2l
[uacute]2n
[uacute]2p
[uacute]2t
[uacute]t4ko
[uacute]2v
[uacute]2z
[uacute]z3k
[uacute]2[ccaron]
3[uacute][ccaron]e
[uacute][rcaron]e4z
[uacute][scaron]4ti
[uacute]2[zcaron]
[uring]1b
[uring]1c
[uring]1hl
[uring]3jd
[uring]4jmov[yacute]
[uring]1le
[uring]1my
[uring]1m[ecaron]
[uring]1ra
[uring]r4va
[uring]r4vy
[uring]1s2
[uring]2st
[uring]s3te
[uring]s3t[aacute]n
[uring]t2
[uring]3tkl
[uring]2v
[uring]3va
[uring]3vo
[uring]3v[ecaron]
[uring]2z
[uring]3zo
[uring]2[zcaron]
[uring]3[zcaron]e
[uring]3[zcaron]i
[uring]3[zcaron]o
[yacute]1b
[yacute]3cho
[yacute]1d
[yacute]d4la
[yacute]1h
[yacute]1j
[yacute]1l
[yacute]1ml
[yacute]1m[ecaron]
[yacute]2n
[yacute]3no
[yacute]po3[ccaron]4
[yacute]1r
[yacute]1s2
[yacute]2sk
[yacute]1t
[yacute]t4ku
[yacute]t4ky
[yacute]1u
[yacute]4vli
[yacute]3zk
[yacute]3zn
[yacute]4zvu
[yacute][ccaron]4n[ecaron]
[yacute]1[rcaron]
[yacute][scaron]3l
1[zcaron]
2[zcaron].
[zcaron]a3d
[zcaron]a4tv
3[zcaron]a[ccaron]
2[zcaron]1b
2[zcaron]1c
2[zcaron]1d
[zcaron]e2b3
[zcaron]eh3n
[zcaron]e4ml
[zcaron]e4zg
[zcaron]i4dl
[zcaron]i4jm
3[zcaron]il
[zcaron]i2vl
2[zcaron]k
[zcaron]k4ni
2[zcaron]l
[zcaron]4lic
3[zcaron]lo
2[zcaron]1m
2[zcaron]n
[zcaron]on2
2[zcaron]1s2
2[zcaron]1t
[zcaron]2v
[zcaron][aacute]4br
[zcaron][aacute]4nr
2[zcaron][dcaron]
[zcaron][iacute]4zn
2[zcaron][ncaron]
2[zcaron][scaron]
[zcaron][scaron]4ti
[zcaron][scaron]4t[ecaron]
}

% end pattern data

