/* Thoggen deinterlace plugin
 * Copyright (C) 1999 Erik Walthinsen <omega@cse.ogi.edu>
 * Copyright (C) 2006 Tim-Philipp Müller <tim centricular net>
 *
 * (GStreamer-0.10 port of the GStreamer-0.8 deinterlace plugin)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __TH_DEINTERLACE_H__
#define __TH_DEINTERLACE_H__

#include <gst/gst.h>
#include <gst/base/gstbasetransform.h>

G_BEGIN_DECLS

#define TH_TYPE_DEINTERLACE            (th_deinterlace_get_type())
#define TH_DEINTERLACE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),TH_TYPE_DEINTERLACE,ThDeinterlace))
#define TH_DEINTERLACE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),TH_TYPE_DEINTERLACE,ThDeinterlaceClass))
#define TH_IS_DEINTERLACE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),TH_TYPE_DEINTERLACE))
#define TH_IS_DEINTERLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),TH_TYPE_DEINTERLACE))

typedef struct _ThDeinterlace ThDeinterlace;
typedef struct _ThDeinterlaceClass ThDeinterlaceClass;

struct _ThDeinterlace {
  GstBaseTransform basetransform;

  gint         width;
  gint         height;

  gboolean     show_deinterlaced_area_only;
  gboolean     blend;
  gint         threshold_blend; /* here we start blending */
  gint         threshold;       /* here we start interpolating TODO FIXME */
  gint         edge_detect;

  gint         picsize;
  guchar      *src;
};

struct _ThDeinterlaceClass {
  GstBaseTransformClass basetransformclass;
};

GType   th_deinterlace_get_type (void);

G_END_DECLS

#endif /* __TH_DEINTERLACE_H__ */

