/***************************************************************************
                             th-app-window.h
                             ---------------
    begin                : Wed Feb 16 2005
    copyright            : (C) 200t by Tim-Philipp Müller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_app_window_h_included_
#define _th_app_window_h_included_

#include <gtk/gtkwindow.h>

#define TH_TYPE_APP_WINDOW             (th_app_window_get_type())
#define TH_APP_WINDOW(obj)             (G_TYPE_CHECK_INSTANCE_CAST (obj,  TH_TYPE_APP_WINDOW, ThAppWindow))
#define TH_APP_WINDOW_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST (klass,   TH_TYPE_APP_WINDOW, ThAppWindowClass))
#define TH_IS_APP_WINDOW(obj)          (G_TYPE_CHECK_INSTANCE_TYPE (obj,  TH_TYPE_APP_WINDOW))
#define TH_IS_APP_WINDOW_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), TH_TYPE_APP_WINDOW))

typedef struct _ThAppWindow        ThAppWindow;
typedef struct _ThAppWindowClass   ThAppWindowClass;
typedef struct _ThAppWindowPrivate ThAppWindowPrivate;

struct _ThAppWindow
{
	GtkWindow  window;
	
	ThAppWindowPrivate  *priv;
};

struct _ThAppWindowClass
{
	GtkWindowClass  window_class;
};

/* functions */

GType            th_app_window_get_type  (void) G_GNUC_CONST;

GtkWidget       *th_app_window_new (void); 

void             th_app_window_run (ThAppWindow *appwin);

#endif /* _th_app_window_h_included_ */
