# Copyright (c) 2001, 2002, 2003 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.


_locale = None
def install_wx_translation():
    """Install the wx translation function in Thuban.

    For more information about translations in Thuban see the comment in
    Thuban/__init__.py
    """
    global _locale
    import Thuban
    if not Thuban.translation_function_installed():
        # Only import wx modules when we actually can install the
        # function so that the test suite can inhibit this
        import wxPython.wx as wx
        wx.wxLocale_AddCatalogLookupPathPrefix(Thuban._message_dir)
        _locale = wx.wxLocale()
        _locale.AddCatalog("thuban")
        Thuban.install_translation_function(wx.wxGetTranslation)

        # Reset the python locale. This makes sure that the LC_NUMERIC
        # seen by the python interpreter and by C modules is "C" instead
        # of the user's locale. Python code will still see the user's
        # locale where it matters. Without this, drawing the map doesn't
        # work for some reason
        import locale
        locale.setlocale(locale.LC_NUMERIC, "")

install_wx_translation()
