# Copyright (c) 2001 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

__version__ = "$Revision: 1.5 $"

from wxPython.wx import *

from Thuban import _

from controls import SelectableRecordListCtrl

class LabelListCtrl(SelectableRecordListCtrl):

    def __init__(self, parent, id, table, shape):
        SelectableRecordListCtrl.__init__(self, parent, id)
        self.fill_list(table, shape)


class LabelDialog(wxDialog):

    def __init__(self, parent, table, shape_index):
        wxDialog.__init__(self, parent, -1, _("Label Values"),
                          wxDefaultPosition,
                          style = wxRESIZE_BORDER|wxCAPTION|wxDIALOG_MODAL)

        self.parent = parent
        self.dialog_layout(table, shape_index)
        
    def dialog_layout(self, table, shape_index):
        top_box = wxBoxSizer(wxVERTICAL)

        self.list = LabelListCtrl(self, -1, table, shape_index)
        self.list.SetSize(wxSize(305,200))
        top_box.Add(self.list, 1, wxEXPAND|wxALL, 4)

        box = wxBoxSizer(wxHORIZONTAL)
        box.Add(wxButton(self, wxID_OK, _("OK")), 0, wxALL, 4) 
        box.Add(wxButton(self, wxID_CANCEL, _("Cancel")), 0, wxALL, 4) 
        top_box.Add(box, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 10)

        EVT_BUTTON(self, wxID_OK, self.OnOK)
        EVT_BUTTON(self, wxID_CANCEL, self.OnCancel)

        self.SetAutoLayout(True)
        self.SetSizer(top_box)
        top_box.Fit(self)
        top_box.SetSizeHints(self)

    def OnOK(self, event):
        result = self.list.GetValue()
        if result is not None:
            self.end_dialog(wxID_OK, str(result))
        else:
            self.end_dialog(wxID_CANCEL, None)            

    def OnCancel(self, event):
        self.end_dialog(wxID_CANCEL, None)

    def end_dialog(self, wx_result, result):
        self.result = result
        self.EndModal(wx_result)

def run_label_dialog(parent, table, shape_index):
    dialog = LabelDialog(parent, table, shape_index)
    if dialog.ShowModal() == wxID_OK:
        return dialog.result
    else:
        return None

